/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.internal;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.ActionCategory;

public class CategoryTreeItem
implements Comparable {
    private CategoryTreeItem parent;
    private ActionCategory category;
    private ArrayList childs;
    private String name;
    private static final CategoryTreeItem[] EMPTY_CHILDS = new CategoryTreeItem[0];

    public CategoryTreeItem(ActionCategory category) {
        this.category = category;
        this.name = category.getName();
    }

    public String getName() {
        return this.name;
    }

    public CategoryTreeItem getParent() {
        return this.parent;
    }

    public void setParent(CategoryTreeItem parent) {
        this.parent = parent;
    }

    public ActionCategory getCategory() {
        return this.category;
    }

    public void add(CategoryTreeItem item) {
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(item);
    }

    public CategoryTreeItem[] getChilds() {
        if (this.childs == null) {
            return EMPTY_CHILDS;
        }
        return this.childs.toArray(new CategoryTreeItem[this.childs.size()]);
    }

    public int compareTo(Object o) {
        int otherPosition;
        CategoryTreeItem other = (CategoryTreeItem)o;
        int position = this.category.getPosition();
        if (position < (otherPosition = other.getCategory().getPosition())) {
            return -1;
        }
        if (position > otherPosition) {
            return 1;
        }
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryTreeItem)) {
            return false;
        }
        CategoryTreeItem that = (CategoryTreeItem)o;
        if (!this.category.equals(that.category)) {
            return false;
        }
        if (this.childs != null ? !this.childs.equals(that.childs) : that.childs != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.parent != null ? !this.parent.equals(that.parent) : that.parent != null);
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.category.hashCode();
        result = 31 * result + (this.childs != null ? this.childs.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "CategoryTreeItem={name='" + this.name + "', category=" + this.category + '}';
    }
}

