/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.rtf;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class RTFExportDialog
extends AbstractExportDialog {
    private Action actionSelectFile;
    private JTextField txFilename;
    private JCheckBox cbStrictLayout;
    private JFileChooser fileChooser;
    private static final String RTF_FILE_EXTENSION = ".rtf";
    private JStatusBar statusBar;

    public RTFExportDialog(Frame owner) {
        super(owner);
        this.initConstructor();
    }

    public RTFExportDialog(Dialog owner) {
        super(owner);
        this.initConstructor();
    }

    public RTFExportDialog() {
        this.initConstructor();
    }

    @Override
    protected String getConfigurationSuffix() {
        return "_rtfexport";
    }

    private void initConstructor() {
        this.actionSelectFile = new ActionSelectFile(this.getResources());
        this.statusBar = new JStatusBar();
        this.setTitle(this.getResources().getString("rtf-exportdialog.dialogtitle"));
        this.initialize();
        this.clear();
    }

    private Action getActionSelectFile() {
        return this.actionSelectFile;
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    private void initialize() {
        JTabbedPane theTabbedPane = new JTabbedPane();
        theTabbedPane.add(this.getResources().getString("rtf-exportdialog.export-settings"), this.createExportPanel());
        theTabbedPane.add(this.getResources().getString("rtf-exportdialog.parameters"), this.getParametersPanel());
        this.setContentPane(this.createContentPane(theTabbedPane));
    }

    private JPanel createExportPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("rtf-exportdialog.filename"));
        JButton btnSelect = new JButton(this.getActionSelectFile());
        this.txFilename = new JTextField();
        this.cbStrictLayout = new JCheckBox(this.getResources().getString("rtf-exportdialog.strict-layout"));
        this.getFormValidator().registerButton(this.cbStrictLayout);
        this.getFormValidator().registerTextField(this.txFilename);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 5);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.ipadx = 120;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbStrictLayout, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        contentPane.add((Component)btnSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 1, 1, 1);
        contentPane.add((Component)new JPanel(), gbc);
        return contentPane;
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    public boolean isStrictLayout() {
        return this.cbStrictLayout.isSelected();
    }

    public void setStrictLayout(boolean strictLayout) {
        this.cbStrictLayout.setSelected(strictLayout);
    }

    @Override
    public void clear() {
        this.txFilename.setText("");
        this.cbStrictLayout.setSelected(false);
    }

    @Override
    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration p = new DefaultConfiguration();
        if (full) {
            p.setProperty("org.pentaho.reporting.engine.classic.core.modules.gui.rtf.FileName", this.getFilename());
        }
        p.setProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StrictLayout", String.valueOf(this.isStrictLayout()));
        return p;
    }

    @Override
    protected void setDialogContents(Configuration config) {
        String strict = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StrictLayout");
        this.setStrictLayout("true".equals(strict));
        String defaultFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.rtf.FileName");
        if (defaultFileName != null) {
            this.setFilename(this.resolvePath(defaultFileName).getAbsolutePath());
        }
    }

    protected void performSelectFile() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(RTF_FILE_EXTENSION, this.getResources().getString("rtf-exportdialog.rtf-file-description"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        File file = new File(this.getFilename());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(file);
        int option = this.fileChooser.showSaveDialog(this);
        if (option == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)RTF_FILE_EXTENSION)) {
                selFileName = selFileName + RTF_FILE_EXTENSION;
            }
            this.setFilename(selFileName);
        }
    }

    @Override
    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("rtf-exportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("rtf-exportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("rtf-exportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("rtf-exportdialog.targetExistsWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        return true;
    }

    @Override
    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "rtf-exportdialog.targetOverwriteConfirmation";
            String key2 = "rtf-exportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("rtf-exportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("rtf-exportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.messages.messages";
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.";
    }

    private class ActionSelectFile
    extends AbstractAction {
        protected ActionSelectFile(ResourceBundle resources) {
            this.putValue("Name", resources.getString("rtf-exportdialog.selectFile"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RTFExportDialog.this.performSelectFile();
        }
    }
}

