/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Random;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.AbstractSequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.CrosstabTestSequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class CrosstabTestSequence
extends AbstractSequence {
    @Override
    public SequenceDescription getSequenceDescription() {
        return new CrosstabTestSequenceDescription();
    }

    @Override
    public TableModel produce(DataRow parameters, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        Integer colDimsRaw = this.getTypedParameter("column-dimensions", Integer.class, 3);
        if (colDimsRaw == null) {
            throw new ReportDataFactoryException("Parameter column-dimensions is not defined.");
        }
        if (colDimsRaw < 1) {
            throw new ReportDataFactoryException("Parameter column-dimensions has an invalid value.");
        }
        int colDims = colDimsRaw;
        Integer[] colCardsRaw = this.getTypedParameter("column-cardinality", Integer[].class, null);
        String[] colPatternRaw = this.getTypedParameter("column-pattern", String[].class, null);
        Integer rowDimsRaw = this.getTypedParameter("row-dimensions", Integer.class, 3);
        if (rowDimsRaw == null) {
            throw new ReportDataFactoryException("Parameter row-dimensions is not defined.");
        }
        if (rowDimsRaw < 1) {
            throw new ReportDataFactoryException("Parameter row-dimensions has an invalid value.");
        }
        int rowDims = rowDimsRaw;
        Integer[] rowCardsRaw = this.getTypedParameter("row-cardinality", Integer[].class, null);
        String[] rowPatternRaw = this.getTypedParameter("row-pattern", String[].class, null);
        int[] rowCards = this.populateCardinality(rowCardsRaw, rowDims);
        int[] colCards = this.populateCardinality(colCardsRaw, colDims);
        int rowCount = this.computeRowCount(rowCards, colCards);
        int colCount = rowDims + colDims + 1;
        String[] rowPattern = this.populatePatterns("Row-", rowPatternRaw, rowDims);
        String[] colPattern = this.populatePatterns("Col-", colPatternRaw, colDims);
        TypedTableModel model = new TypedTableModel(rowCount, colCount);
        for (int r = 0; r < rowDims; ++r) {
            model.addColumn("r" + r, String.class);
        }
        for (int c = 0; c < colDims; ++c) {
            model.addColumn("c" + c, String.class);
        }
        model.addColumn("value", Double.class);
        Long seed = this.getTypedParameter("random-seed", Long.class, System.currentTimeMillis());
        Random r = new Random(seed);
        Object[] values = new Object[rowDims + colDims + 1];
        int[] cards = new int[rowDims + colDims];
        Arrays.fill(cards, -1);
        int pos = 0;
        while (pos >= 0) {
            if (pos == cards.length) {
                values[pos] = r.nextDouble();
                model.addRow(values);
                --pos;
                continue;
            }
            int n = pos;
            cards[n] = cards[n] + 1;
            values[pos] = MessageFormat.format(this.queryPattern(rowPattern, colPattern, pos), cards[pos]);
            int maxCard = this.queryCardinality(rowCards, colCards, pos);
            if (cards[pos] >= maxCard) {
                cards[pos] = -1;
                --pos;
                continue;
            }
            ++pos;
        }
        return model;
    }

    private int computeRowCount(int[] rowCards, int[] colCards) {
        int rowCard;
        int i;
        int rowCount = 1;
        for (i = 0; i < rowCards.length; ++i) {
            rowCard = rowCards[i];
            rowCount *= rowCard;
        }
        for (i = 0; i < colCards.length; ++i) {
            rowCard = colCards[i];
            rowCount *= rowCard;
        }
        return rowCount;
    }

    private int queryCardinality(int[] rows, int[] cols, int pos) {
        if (pos < rows.length) {
            return rows[pos];
        }
        if ((pos -= rows.length) < cols.length) {
            return cols[pos];
        }
        return -1;
    }

    private String queryPattern(String[] rows, String[] cols, int pos) {
        if (pos < rows.length) {
            return rows[pos];
        }
        if ((pos -= rows.length) < cols.length) {
            return cols[pos];
        }
        return null;
    }

    private int[] populateCardinality(Integer[] array, int size) {
        int[] retval = new int[size];
        Arrays.fill(retval, 1);
        if (array == null) {
            return retval;
        }
        for (int i = 0; i < Math.min(array.length, size); ++i) {
            Integer integer = array[i];
            if (integer == null) continue;
            retval[i] = Math.max(integer, 1);
        }
        return retval;
    }

    private String toSequenceChar(int value) {
        int size = 25;
        if (value <= 25) {
            return String.valueOf((char)(65 + value));
        }
        return String.valueOf(value - 25 - 1);
    }

    private String[] populatePatterns(String prefix, String[] array, int size) {
        int i;
        String[] retval = new String[size];
        for (i = 0; i < retval.length; ++i) {
            retval[i] = prefix + this.toSequenceChar(i) + "-{0}";
        }
        if (array == null) {
            return retval;
        }
        for (i = 0; i < Math.min(array.length, size); ++i) {
            String pattern = array[i];
            if (StringUtils.isEmpty((String)pattern)) continue;
            retval[i] = pattern;
        }
        return retval;
    }
}

