/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;

public class SequenceDataFactory
extends AbstractDataFactory {
    private LinkedHashMap<String, Sequence> sequences = new LinkedHashMap();

    public void addSequence(String query, Sequence sequence) {
        this.sequences.put(query, sequence);
    }

    @Override
    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        Sequence sequence = this.sequences.get(query);
        if (sequence == null) {
            throw new ReportDataFactoryException("No such query '" + query + "'");
        }
        return sequence.produce(parameters, this.getDataFactoryContext());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.sequences.containsKey(query);
    }

    @Override
    public String[] getQueryNames() {
        return this.sequences.keySet().toArray(new String[this.sequences.size()]);
    }

    @Override
    public SequenceDataFactory clone() {
        SequenceDataFactory dataFactory = (SequenceDataFactory)super.clone();
        dataFactory.sequences = (LinkedHashMap)this.sequences.clone();
        for (Map.Entry<String, Sequence> entry : dataFactory.sequences.entrySet()) {
            Sequence value = entry.getValue();
            entry.setValue((Sequence)value.clone());
        }
        return dataFactory;
    }

    public Sequence getSequence(String name) {
        return this.sequences.get(name);
    }
}

