/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.modules.misc.survey.SurveyScaleShapeType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.ReportDrawable;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.serializer.SerializerHelper;

public class SurveyScale
implements ReportDrawable,
Serializable {
    private static final Number[] EMPTY_VALUES = new Number[0];
    private int lowest;
    private int highest;
    private double lowerMargin = 0.1;
    private double upperMargin = 0.1;
    private ArrayList<Boolean> fillShapes;
    private Number[] values;
    private Number rangeLowerBound;
    private Number rangeUpperBound;
    private boolean drawTickMarks;
    private boolean drawScaleValues;
    private Font scaleValueFont;
    private transient Paint scaleValuePaint;
    private transient Paint rangePaint;
    private transient ArrayList<Shape> shapes;
    private transient Paint fillPaint;
    private transient Stroke outlineStroke;
    private transient Shape defaultShape;
    private transient Paint tickMarkPaint;
    private transient Paint borderPaint;
    private int range;
    private double lowerBound;
    private double upperBound;
    private boolean useFontMetricsGetStringBounds;
    private transient StyleSheet styleSheet;
    private boolean autoConfigure;

    public SurveyScale() {
        this(1, 5, EMPTY_VALUES);
    }

    public SurveyScale(int lowest, int highest, Number[] values) {
        String configFontMetricsStringBounds = ClassicEngineBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.misc.survey.UseFontMetricsGetStringBounds", "auto");
        this.useFontMetricsGetStringBounds = "auto".equals(configFontMetricsStringBounds) ? ObjectUtilities.isJDK14() : "true".equals(configFontMetricsStringBounds);
        this.lowest = lowest;
        this.highest = highest;
        this.values = values == null ? EMPTY_VALUES : (Number[])values.clone();
        this.drawTickMarks = true;
        this.tickMarkPaint = Color.gray;
        this.scaleValuePaint = Color.black;
        this.defaultShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        this.rangeLowerBound = null;
        this.rangeUpperBound = null;
        this.rangePaint = Color.LIGHT_GRAY;
        this.shapes = this.createShapeList();
        this.fillShapes = new ArrayList();
        this.fillShapes.add(0, Boolean.TRUE);
        this.fillPaint = Color.BLACK;
        this.outlineStroke = new BasicStroke(0.5f);
        this.recompute();
    }

    public boolean isAutoConfigure() {
        return this.autoConfigure;
    }

    public void setAutoConfigure(boolean autoConfigure) {
        this.autoConfigure = autoConfigure;
        this.recompute();
    }

    public int getLowest() {
        return this.lowest;
    }

    public void setLowest(int lowest) {
        this.lowest = lowest;
        this.recompute();
    }

    public int getHighest() {
        return this.highest;
    }

    public void setHighest(int highest) {
        this.highest = highest;
        this.recompute();
    }

    protected void recompute() {
        this.range = Math.max(0, this.highest - this.lowest);
        this.lowerBound = (double)this.lowest - (double)this.range * this.lowerMargin;
        this.upperBound = (double)this.highest + (double)this.range * this.upperMargin;
    }

    protected int getRange() {
        return this.range;
    }

    protected void setRange(int range) {
        this.range = range;
    }

    protected double getLowerBound() {
        return this.lowerBound;
    }

    protected void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    protected double getUpperBound() {
        return this.upperBound;
    }

    protected void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    protected ArrayList<Shape> createShapeList() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        shapes.add(SurveyScale.createDownTriangle(4.0f));
        shapes.add(SurveyScale.createUpTriangle(4.0f));
        shapes.add(SurveyScale.createDiamond(4.0f));
        shapes.add(new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        shapes.add(new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        return shapes;
    }

    public static Shape createDiamond(float s) {
        GeneralPath p0 = new GeneralPath();
        p0.moveTo(0.0f, -s);
        p0.lineTo(s, 0.0f);
        p0.lineTo(0.0f, s);
        p0.lineTo(-s, 0.0f);
        p0.closePath();
        return p0;
    }

    public static Shape createUpTriangle(float s) {
        GeneralPath p0 = new GeneralPath();
        p0.moveTo(0.0f, -s);
        p0.lineTo(s, s);
        p0.lineTo(-s, s);
        p0.closePath();
        return p0;
    }

    public static Shape createDownTriangle(float s) {
        GeneralPath p0 = new GeneralPath();
        p0.moveTo(0.0f, s);
        p0.lineTo(s, -s);
        p0.lineTo(-s, -s);
        p0.closePath();
        return p0;
    }

    public Number getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public void setRangeLowerBound(Number bound) {
        this.rangeLowerBound = bound;
    }

    public Number getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public void setRangeUpperBound(Number bound) {
        this.rangeUpperBound = bound;
    }

    public boolean isDrawTickMarks() {
        return this.drawTickMarks;
    }

    public void setDrawTickMarks(boolean flag) {
        this.drawTickMarks = flag;
    }

    public boolean isDrawScaleValues() {
        return this.drawScaleValues;
    }

    public void setDrawScaleValues(boolean flag) {
        this.drawScaleValues = flag;
    }

    public Font getScaleValueFont() {
        return this.scaleValueFont;
    }

    public void setScaleValueFont(Font font) {
        this.scaleValueFont = font;
    }

    public Paint getScaleValuePaint() {
        return this.scaleValuePaint;
    }

    public void setScaleValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.scaleValuePaint = paint;
    }

    public Shape getShape(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.shapes.size()) {
            return this.shapes.get(index);
        }
        return null;
    }

    public void setShape(int index, Shape shape) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.shapes.size() > index) {
            this.shapes.set(index, shape);
        } else {
            while (this.shapes.size() < index) {
                this.shapes.ensureCapacity(index);
                this.shapes.add(null);
                this.shapes.add(shape);
            }
        }
    }

    public void setShape(int index, SurveyScaleShapeType shape) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.shapes.size() > index) {
            this.shapes.set(index, shape.getShape());
        } else {
            while (this.shapes.size() < index) {
                this.shapes.ensureCapacity(index);
                this.shapes.add(null);
                this.shapes.add(shape.getShape());
            }
        }
    }

    public boolean isShapeFilled(int index) {
        Boolean b;
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (index < this.fillShapes.size() && (b = this.fillShapes.get(index)) != null) {
            return b;
        }
        return false;
    }

    public void setShapeFilled(int index, boolean fill) {
        this.fillShapes.set(index, fill ? Boolean.TRUE : Boolean.FALSE);
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public void setRangePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangePaint = paint;
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(Shape defaultShape) {
        if (defaultShape == null) {
            throw new NullPointerException("The default shape must not be null.");
        }
        this.defaultShape = defaultShape;
    }

    public void setDefaultShape(SurveyScaleShapeType shapeType) {
        if (shapeType == null) {
            throw new NullPointerException("The default shape must not be null.");
        }
        this.setDefaultShape(shapeType.getShape());
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint tickMarkPaint) {
        if (tickMarkPaint == null) {
            throw new NullPointerException();
        }
        this.tickMarkPaint = tickMarkPaint;
    }

    public Number[] getValues() {
        return (Number[])this.values.clone();
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint fillPaint) {
        if (fillPaint == null) {
            throw new NullPointerException();
        }
        this.fillPaint = fillPaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        if (outlineStroke == null) {
            throw new NullPointerException();
        }
        this.outlineStroke = outlineStroke;
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double upperMargin) {
        this.upperMargin = upperMargin;
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D area) {
        this.drawRangeArea(area, g2);
        if (this.isDrawTickMarks()) {
            this.drawTickMarks(g2, area);
        }
        if (this.isDrawScaleValues()) {
            this.drawScaleValues(g2, area);
        }
        this.drawValues(g2, area);
    }

    protected void drawValues(Graphics2D g2, Rectangle2D area) {
        Number[] values = this.getValues();
        if (values.length == 0) {
            return;
        }
        double y = area.getCenterY();
        Stroke outlineStroke = this.getOutlineStroke();
        Shape defaultShape = this.getDefaultShape();
        g2.setPaint(this.getFillPaint());
        for (int i = 0; i < values.length; ++i) {
            Number n = values[i];
            if (n == null) continue;
            double v = n.doubleValue();
            double x = this.valueToJava2D(v, area);
            Shape valueShape = this.getShape(i);
            if (valueShape == null) {
                valueShape = defaultShape;
            }
            if (this.isShapeFilled(i)) {
                g2.translate(x, y);
                g2.fill(valueShape);
                g2.translate(-x, -y);
                continue;
            }
            g2.setStroke(outlineStroke);
            g2.translate(x, y);
            g2.draw(valueShape);
            g2.translate(-x, -y);
        }
    }

    protected void drawScaleValues(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(this.getScaleValuePaint());
        Font valueFont = this.getScaleValueFont();
        if (valueFont != null) {
            g2.setFont(valueFont);
        } else if (this.styleSheet != null) {
            String fontName = (String)this.styleSheet.getStyleProperty(TextStyleKeys.FONT);
            int fontSize = this.styleSheet.getIntStyleProperty(TextStyleKeys.FONTSIZE, 10);
            boolean bold = this.styleSheet.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italic = this.styleSheet.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            int style = 0;
            if (bold) {
                style |= 1;
            }
            if (italic) {
                style |= 2;
            }
            g2.setFont(new Font(fontName, style, fontSize));
        }
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        FontRenderContext frc = g2.getFontRenderContext();
        double y = area.getCenterY();
        int highest = this.getHighest();
        for (int i = this.getLowest(); i <= highest; ++i) {
            float width;
            double x = this.valueToJava2D(i, area);
            String text = String.valueOf(i);
            if (this.useFontMetricsGetStringBounds) {
                Rectangle2D bounds = fm.getStringBounds(text, g2);
                width = (float)bounds.getWidth();
            } else {
                width = fm.stringWidth(text);
            }
            LineMetrics metrics = f.getLineMetrics(text, frc);
            float descent = metrics.getDescent();
            float leading = metrics.getLeading();
            float yAdj = -descent - leading + (float)((double)metrics.getHeight() / 2.0);
            float xAdj = -width / 2.0f;
            g2.drawString(text, (float)(x + (double)xAdj), (float)(y + (double)yAdj));
        }
    }

    protected void drawTickMarks(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(this.getTickMarkPaint());
        g2.setStroke(new BasicStroke(0.1f));
        int highest = this.getHighest();
        for (int i = this.getLowest(); i <= highest; ++i) {
            for (int j = 0; j < 10; ++j) {
                double xx = this.valueToJava2D((double)i + (double)j / 10.0, area);
                Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
                g2.draw(mark);
            }
        }
        double xx = this.valueToJava2D(highest, area);
        Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
        g2.draw(mark);
    }

    protected void drawRangeArea(Rectangle2D area, Graphics2D g2) {
        Number rangeUpperBound = this.getRangeUpperBound();
        Number rangeLowerBound = this.getRangeLowerBound();
        if (rangeLowerBound == null || rangeUpperBound == null) {
            return;
        }
        double x0 = this.valueToJava2D(rangeLowerBound.doubleValue(), area);
        double x1 = this.valueToJava2D(rangeUpperBound.doubleValue(), area);
        Rectangle2D.Double rangeArea = new Rectangle2D.Double(x0, area.getY(), x1 - x0, area.getHeight());
        g2.setPaint(this.getRangePaint());
        g2.fill(rangeArea);
    }

    private double valueToJava2D(double value, Rectangle2D area) {
        double upperBound = this.getUpperBound();
        double lowerBound = this.getLowerBound();
        return area.getMinX() + (value - lowerBound) / (upperBound - lowerBound) * area.getWidth();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        helper.writeObject((Object)this.scaleValuePaint, out);
        helper.writeObject((Object)this.rangePaint, out);
        helper.writeObject((Object)this.fillPaint, out);
        helper.writeObject((Object)this.outlineStroke, out);
        helper.writeObject((Object)this.defaultShape, out);
        helper.writeObject((Object)this.tickMarkPaint, out);
        helper.writeObject((Object)this.borderPaint, out);
        int size = this.shapes.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            Shape s = this.shapes.get(i);
            helper.writeObject((Object)s, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        this.scaleValuePaint = (Paint)helper.readObject(in);
        this.rangePaint = (Paint)helper.readObject(in);
        this.fillPaint = (Paint)helper.readObject(in);
        this.outlineStroke = (Stroke)helper.readObject(in);
        this.defaultShape = (Shape)helper.readObject(in);
        this.tickMarkPaint = (Paint)helper.readObject(in);
        this.borderPaint = (Paint)helper.readObject(in);
        this.shapes = new ArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Shape s = (Shape)helper.readObject(in);
            this.shapes.add(s);
        }
    }

    @Override
    public void setConfiguration(Configuration config) {
    }

    @Override
    public void setStyleSheet(StyleSheet style) {
        this.styleSheet = style;
        if (this.autoConfigure && this.styleSheet != null) {
            this.scaleValuePaint = (Paint)style.getStyleProperty(ElementStyleKeys.PAINT, this.scaleValuePaint);
            this.fillPaint = (Paint)style.getStyleProperty(ElementStyleKeys.FILL_COLOR, this.fillPaint);
            String fontName = (String)style.getStyleProperty(TextStyleKeys.FONT, "SansSerif");
            boolean bold = style.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italics = style.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            int size = style.getIntStyleProperty(TextStyleKeys.FONTSIZE, 10);
            int fontStyle = 0;
            if (bold) {
                fontStyle |= 1;
            }
            if (italics) {
                fontStyle |= 2;
            }
            this.scaleValueFont = new Font(fontName, fontStyle, size);
        }
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public void setResourceBundleFactory(ResourceBundleFactory bundleFactory) {
    }

    @Override
    public ImageMap getImageMap(Rectangle2D bounds) {
        return null;
    }
}

