/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.html;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlContentItems;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.html.FastHtmlTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.AbstractContentProducerTemplate;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.libraries.repository.ContentIOException;

public class FastHtmlContentProducerTemplate
extends AbstractContentProducerTemplate {
    private FastHtmlContentItems contentItems;
    private FastHtmlPrinter htmlPrinter;

    public FastHtmlContentProducerTemplate(SheetLayout sheetLayout, FastHtmlContentItems contentItems) {
        super(sheetLayout);
        this.contentItems = contentItems;
    }

    @Override
    public void initialize(ReportDefinition report, ExpressionRuntime runtime, boolean pagination) {
        super.initialize(report, runtime, pagination);
        this.htmlPrinter = new FastHtmlPrinter(this.getSharedSheetLayout(), runtime.getProcessingContext().getResourceManager(), this.contentItems);
        this.htmlPrinter.init(this.getMetaData(), report);
    }

    @Override
    protected void writeContent(Band band, ExpressionRuntime runtime, FormattedDataBuilder messageFormatSupport) throws IOException, ReportProcessingException, ContentProcessingException {
        messageFormatSupport.compute(band, runtime, null);
    }

    @Override
    public void finishReport() throws ReportProcessingException {
        try {
            this.htmlPrinter.close();
        }
        catch (IOException e) {
            throw new ReportProcessingException("Failed to close report", e);
        }
        catch (ContentIOException e) {
            throw new ReportProcessingException("Failed to close report", (Exception)((Object)e));
        }
    }

    @Override
    protected FastExportTemplateProducer createTemplateProducer() {
        return new FastHtmlTemplateProducer(this.getMetaData(), this.getSharedSheetLayout(), this.htmlPrinter);
    }
}

