/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.pentaho.reporting.engine.classic.core.layout.model.BorderEdge;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayoutTableCellDefinition;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableCutList;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableExportRenderBoxState;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ShapeDrawable;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class SheetLayout
implements SlimSheetLayout,
Cloneable {
    private static final SheetLayoutTableCellDefinition MARKER_DEFINITION = new SheetLayoutTableCellDefinition();
    private static final boolean UPPER_BOUNDS = true;
    private static final boolean LOWER_BOUNDS = false;
    private final boolean strict;
    private TableCutList xBounds;
    private TableCutList yBounds;
    private long xMaxBounds;
    private long yMaxBounds;
    private boolean ellipseAsRectangle;

    public SheetLayout(boolean strict, boolean ellipseAsRectangle) {
        this.ellipseAsRectangle = ellipseAsRectangle;
        this.xBounds = new TableCutList(50, true);
        this.yBounds = new TableCutList(2500, true);
        this.strict = strict;
        this.xMaxBounds = 0L;
        this.yMaxBounds = 0L;
        this.ensureXMapping(0L, Boolean.FALSE);
        this.ensureYMapping(0L, Boolean.FALSE);
    }

    public SheetLayout(OutputProcessorMetaData metaData) {
        this(metaData.isFeatureSupported(AbstractTableOutputProcessor.STRICT_LAYOUT), metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE));
    }

    public SheetLayout derive() {
        SheetLayout clone = this.clone();
        clone.clearVerticalInfo();
        return clone;
    }

    public SheetLayout clone() {
        try {
            SheetLayout clone = (SheetLayout)super.clone();
            clone.xBounds = this.xBounds.clone();
            clone.yBounds = this.yBounds.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    private SheetLayoutTableCellDefinition createBackground(RenderBox box) {
        if (!box.getBoxDefinition().getBorder().isEmpty()) {
            return MARKER_DEFINITION;
        }
        StyleSheet styleSheet = box.getStyleSheet();
        if (styleSheet.getStyleProperty(ElementStyleKeys.BACKGROUND_COLOR) != null) {
            return MARKER_DEFINITION;
        }
        if (styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME) != null) {
            return MARKER_DEFINITION;
        }
        return null;
    }

    private SheetLayoutTableCellDefinition computeLegacyBackground(RenderBox box, long shift) {
        if (box.getNodeType() != 258) {
            return null;
        }
        RenderableReplacedContentBox contentBox = (RenderableReplacedContentBox)box;
        StyleSheet styleSheet = box.getStyleSheet();
        RenderableReplacedContent rpc = contentBox.getContent();
        Object rawContentObject = rpc.getRawObject();
        if (!(rawContentObject instanceof DrawableWrapper)) {
            return null;
        }
        DrawableWrapper wrapper = (DrawableWrapper)rawContentObject;
        Object rawbackend = wrapper.getBackend();
        if (!(rawbackend instanceof ShapeDrawable)) {
            return null;
        }
        ShapeDrawable drawable = (ShapeDrawable)rawbackend;
        Shape rawObject = drawable.getShape();
        boolean draw = styleSheet.getBooleanStyleProperty(ElementStyleKeys.DRAW_SHAPE);
        if (draw && rawObject instanceof Line2D) {
            long coordinate;
            int lineType;
            boolean horizontal;
            Line2D line = (Line2D)rawObject;
            boolean vertical = line.getX1() == line.getX2();
            boolean bl = horizontal = line.getY1() == line.getY2();
            if (vertical && horizontal) {
                return null;
            }
            if (vertical) {
                lineType = 1;
                coordinate = StrictGeomUtility.toInternalValue(line.getX1()) + box.getX();
            } else if (horizontal) {
                lineType = 2;
                coordinate = StrictGeomUtility.toInternalValue(line.getY1()) + box.getY() + shift;
            } else {
                return null;
            }
            return new SheetLayoutTableCellDefinition(lineType, coordinate);
        }
        if (rawObject instanceof Rectangle2D || this.ellipseAsRectangle && rawObject instanceof Ellipse2D) {
            BorderEdge edge;
            if (draw && (edge = ProcessUtility.produceBorderEdge(box.getStyleSheet())) != null) {
                return MARKER_DEFINITION;
            }
            if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE)) {
                return MARKER_DEFINITION;
            }
            return null;
        }
        if (rawObject instanceof RoundRectangle2D) {
            BorderEdge edge;
            if (draw && (edge = ProcessUtility.produceBorderEdge(box.getStyleSheet())) != null) {
                return MARKER_DEFINITION;
            }
            if (styleSheet.getBooleanStyleProperty(ElementStyleKeys.FILL_SHAPE)) {
                return MARKER_DEFINITION;
            }
            return null;
        }
        return null;
    }

    public boolean add(RenderBox element, long offset, long headerSize, long maxHeight) {
        boolean unmodified;
        SheetLayoutTableCellDefinition background;
        long elementY;
        long shift = headerSize - offset;
        long shiftedY = element.getY() + shift;
        if (shiftedY < 0L) {
            if (shiftedY + element.getHeight() < 0L) {
                return true;
            }
            elementY = 0L;
        } else {
            elementY = shiftedY;
        }
        Object state = element.getTableExportState();
        if (state != null) {
            TableExportRenderBoxState tablestate = (TableExportRenderBoxState)state;
            if (tablestate.getBackgroundDefinitionAge() == element.getChangeTracker()) {
                background = tablestate.getBackgroundDefinition();
                unmodified = true;
            } else {
                background = this.createBackground(element);
                tablestate.setBackgroundDefinition(background, element.getChangeTracker());
                unmodified = false;
            }
        } else {
            TableExportRenderBoxState tablestate = new TableExportRenderBoxState();
            element.setTableExportState(tablestate);
            background = this.createBackground(element);
            tablestate.setBackgroundDefinition(background, element.getChangeTracker());
            unmodified = false;
        }
        if (this.addLine(element, background, elementY, shiftedY, unmodified, headerSize)) {
            return unmodified;
        }
        long elementX = element.getX();
        long elementRightX = element.getWidth() + elementX;
        long elementBottomY = element.getHeight() + shiftedY;
        if (!unmodified) {
            this.ensureXMapping(elementX, Boolean.FALSE);
        }
        if (elementY >= headerSize) {
            this.ensureYMapping(elementY, Boolean.FALSE);
        }
        Boolean aux = background == null && !this.isStrict() ? Boolean.TRUE : Boolean.FALSE;
        this.ensureXMapping(elementRightX, aux);
        if (elementBottomY >= headerSize && elementBottomY <= maxHeight) {
            this.ensureYMapping(elementBottomY, aux);
        }
        return unmodified;
    }

    public void addRenderableContent(RenderableReplacedContentBox element, long offset, long headerSize, long maxHeight) {
        long elementY;
        long shift = headerSize - offset;
        long shiftedY = element.getY() + shift;
        if (shiftedY < 0L) {
            if (shiftedY + element.getHeight() < 0L) {
                return;
            }
            elementY = 0L;
        } else {
            elementY = shiftedY;
        }
        SheetLayoutTableCellDefinition background = this.computeLegacyBackground(element, shift);
        if (this.addLine(element, background, elementY, shiftedY, false, headerSize)) {
            return;
        }
        long elementX = element.getX();
        long elementRightX = element.getWidth() + elementX;
        long elementBottomY = element.getHeight() + shiftedY;
        this.ensureXMapping(elementX, Boolean.FALSE);
        if (elementY >= headerSize) {
            this.ensureYMapping(elementY, Boolean.FALSE);
        }
        this.ensureXMapping(elementRightX, Boolean.FALSE);
        if (elementBottomY >= headerSize && elementBottomY <= maxHeight) {
            this.ensureYMapping(elementBottomY, Boolean.FALSE);
            if (this.yMaxBounds < elementBottomY) {
                this.yMaxBounds = elementBottomY;
            }
        }
    }

    private boolean addLine(RenderBox element, SheetLayoutTableCellDefinition background, long elementY, long shiftedY, boolean unmodified, long headerSize) {
        long width = element.getWidth();
        long height = element.getHeight();
        if (width == 0L && height == 0L) {
            return background == null;
        }
        if (width != 0L && height != 0L) {
            return false;
        }
        if (background == null) {
            return false;
        }
        if (background.getLineType() == 0) {
            return false;
        }
        if (elementY < headerSize) {
            return false;
        }
        long elementX = element.getX();
        long elementRightX = element.getWidth() + elementX;
        long elementBottomY = element.getHeight() + shiftedY;
        if (background.getLineType() == 2) {
            if (!unmodified) {
                this.ensureXMapping(elementX, Boolean.FALSE);
            }
            this.ensureXMapping(elementRightX, Boolean.FALSE);
            if (background.getCoordinate() == 0L) {
                this.ensureYMapping(elementY, Boolean.FALSE);
            } else {
                this.ensureYMapping(elementBottomY, Boolean.FALSE);
            }
        } else {
            this.ensureYMapping(elementY, Boolean.FALSE);
            this.ensureYMapping(elementBottomY, Boolean.FALSE);
            if (background.getCoordinate() == 0L) {
                if (!unmodified) {
                    this.ensureXMapping(elementX, Boolean.FALSE);
                }
            } else {
                this.ensureXMapping(elementRightX, Boolean.FALSE);
            }
        }
        return true;
    }

    public void ensureXMapping(long coordinate, Boolean aux) {
        this.xBounds.put(coordinate, aux);
        if (this.xMaxBounds < coordinate) {
            this.xMaxBounds = coordinate;
        }
    }

    public void ensureYMapping(long coordinate, Boolean aux) {
        this.yBounds.put(coordinate, aux);
        if (this.yMaxBounds < coordinate) {
            this.yMaxBounds = coordinate;
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isEmpty() {
        return this.yMaxBounds == 0L && this.xMaxBounds == 0L;
    }

    public TableRectangle getTableBounds(long x, long y, long width, long height, TableRectangle rect) {
        if (rect == null) {
            rect = new TableRectangle();
        }
        int x1 = this.xBounds.findKeyPosition(x, false);
        int y1 = this.yBounds.findKeyPosition(y, false);
        int x2 = this.xBounds.findKeyPosition(x + width, true);
        int y2 = this.yBounds.findKeyPosition(y + height, true);
        rect.setRect(x1, y1, x2, y2);
        return rect;
    }

    public TableRectangle getTableBoundsWithCache(long x, long y, long width, long height, TableRectangle rect) {
        if (rect == null) {
            throw new NullPointerException();
        }
        int x1 = this.xBounds.findKeyPosition(x, false, rect.getX1());
        int y1 = this.yBounds.findKeyPosition(y, false, rect.getY1());
        int x2 = this.xBounds.findKeyPosition(x + width, true, rect.getX2());
        int y2 = this.yBounds.findKeyPosition(y + height, true, rect.getY2());
        rect.setRect(x1, y1, x2, y2);
        return rect;
    }

    public int getColSpan(int x1, long endPosition) {
        int x2 = this.xBounds.findKeyPosition(endPosition, true);
        return x2 - x1;
    }

    public int getRowSpan(int y1, long endPosition) {
        int y2 = this.yBounds.findKeyPosition(endPosition, true);
        return y2 - y1;
    }

    @Override
    public TableRectangle getTableBounds(StrictBounds bounds, TableRectangle rect) {
        if (bounds == null) {
            throw new NullPointerException();
        }
        if (rect == null) {
            rect = new TableRectangle();
        }
        long xCoord = bounds.getX();
        long yCoord = bounds.getY();
        int x1 = this.xBounds.findKeyPosition(xCoord, false);
        int y1 = this.yBounds.findKeyPosition(yCoord, false);
        int x2 = this.xBounds.findKeyPosition(xCoord + bounds.getWidth(), true);
        int y2 = this.yBounds.findKeyPosition(yCoord + bounds.getHeight(), true);
        rect.setRect(x1, y1, x2, y2);
        return rect;
    }

    public void pageCompleted() {
        this.removeAuxilaryBounds();
    }

    protected void removeAuxilaryBounds() {
        this.ensureXMapping(this.xMaxBounds, Boolean.FALSE);
        this.ensureYMapping(this.yMaxBounds, Boolean.FALSE);
        long[] removedXCuts = new long[this.xBounds.size()];
        Boolean[] xEntries = this.xBounds.getRawEntries();
        int xEntrySize = this.xBounds.size();
        int arrayIdx = 0;
        for (int i = 0; i < xEntrySize; ++i) {
            Boolean cut = xEntries[i];
            if (!Boolean.TRUE.equals(cut)) continue;
            removedXCuts[arrayIdx] = this.xBounds.getKeyAt(i);
            ++arrayIdx;
        }
        this.xBounds.removeAll(removedXCuts, arrayIdx);
        arrayIdx = 0;
        long[] removedYCuts = new long[this.yBounds.size()];
        Boolean[] yEntries = this.yBounds.getRawEntries();
        int ySize = this.yBounds.size();
        for (int i = 0; i < ySize; ++i) {
            Boolean cut = yEntries[i];
            if (!Boolean.TRUE.equals(cut)) continue;
            removedYCuts[arrayIdx] = this.yBounds.getKeyAt(i);
            ++arrayIdx;
        }
        this.yBounds.removeAll(removedYCuts, arrayIdx);
    }

    @Override
    public long getRowHeight(int row) {
        int rowCount = this.yBounds.size();
        if (row >= rowCount) {
            throw new IndexOutOfBoundsException("Row " + row + " is invalid. Max valid row is " + (rowCount - 1));
        }
        long bottomBorder = row + 1 < rowCount ? this.yBounds.getKeyAt(row + 1) : this.yMaxBounds;
        return bottomBorder - this.yBounds.getKeyAt(row);
    }

    public long getMaxHeight() {
        return this.yMaxBounds;
    }

    @Override
    public long getMaxWidth() {
        return this.xMaxBounds;
    }

    @Override
    public long getCellWidth(int startCell) {
        return this.getCellWidth(startCell, startCell + 1);
    }

    @Override
    public long getCellWidth(int startCell, int endCell) {
        if (startCell < 0) {
            throw new IndexOutOfBoundsException("Start-Cell must not be negative");
        }
        if (endCell < 0) {
            throw new IndexOutOfBoundsException("End-Cell must not be negative");
        }
        if (endCell < startCell) {
            throw new IndexOutOfBoundsException("End-Cell must not smaller than end-cell");
        }
        long rightBorder = endCell >= this.xBounds.size() ? this.xMaxBounds : this.xBounds.getKeyAt(endCell);
        return rightBorder - this.xBounds.getKeyAt(startCell);
    }

    public long getRowHeight(int startRow, int endRow) {
        if (startRow < 0) {
            throw new IndexOutOfBoundsException("Start-Cell must not be negative");
        }
        if (endRow < 0) {
            throw new IndexOutOfBoundsException("End-Cell must not be negative");
        }
        if (endRow < startRow) {
            throw new IndexOutOfBoundsException("End-Cell must not smaller than end-cell");
        }
        long bottomBorder = endRow >= this.yBounds.size() ? this.yMaxBounds : this.yBounds.getKeyAt(endRow);
        return bottomBorder - this.yBounds.getKeyAt(startRow);
    }

    @Override
    public int getColumnCount() {
        return Math.max(this.xBounds.size() - 1, 0);
    }

    public int getRowCount() {
        return Math.max(this.yBounds.size() - 1, 0);
    }

    @Override
    public long getXPosition(int col) {
        return this.xBounds.getKeyAt(col);
    }

    @Override
    public long getYPosition(int row) {
        return this.yBounds.getKeyAt(row);
    }

    public void clear() {
        this.xBounds.clear();
        this.xMaxBounds = 0L;
        this.yBounds.clear();
        this.yMaxBounds = 0L;
    }

    public void clearVerticalInfo() {
        this.yBounds.clear();
        this.yMaxBounds = 0L;
    }
}

