/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper;

import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.text.LegacyFontMetrics;
import org.pentaho.reporting.engine.classic.core.modules.output.support.itext.BaseFontModule;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.fonts.FontMappingUtility;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontFontMetrics;
import org.pentaho.reporting.libraries.fonts.itext.ITextFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class RTFOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;
    public static final OutputProcessorFeature.BooleanOutputProcessorFeature IMAGES_ENABLED = new OutputProcessorFeature.BooleanOutputProcessorFeature("RTF.EnableImages");
    private int paginationMode;

    public RTFOutputProcessorMetaData(int paginationMode) {
        super((FontStorage)new ITextFontStorage(BaseFontModule.getFontRegistry()));
        this.paginationMode = paginationMode;
    }

    @Override
    public void initialize(Configuration configuration) {
        super.initialize(configuration);
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.EnableImages"))) {
            this.addFeature(IMAGES_ENABLED);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StrictLayout"))) {
            this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.StrictLayout"))) {
            this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if (this.paginationMode == 2) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        } else if (this.paginationMode == 1) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        } else {
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        }
        ExtendedConfigurationWrapper extendedConfig = new ExtendedConfigurationWrapper(configuration);
        double deviceResolution = extendedConfig.getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.DeviceResolution", 0);
        if (deviceResolution > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.ShapeAsContent"))) {
            this.addFeature(AbstractTableOutputProcessor.SHAPES_CONTENT);
        }
    }

    @Override
    public String getExportDescriptor() {
        return "table/rtf";
    }

    @Override
    public String getNormalizedFontFamilyName(String name) {
        String mappedName = super.getNormalizedFontFamilyName(name);
        if (FontMappingUtility.isSerif((String)mappedName)) {
            return "Times";
        }
        if (FontMappingUtility.isSansSerif((String)mappedName)) {
            return "Helvetica";
        }
        if (FontMappingUtility.isCourier((String)mappedName)) {
            return "Courier";
        }
        if (FontMappingUtility.isSymbol((String)mappedName)) {
            return "Symbol";
        }
        return mappedName;
    }

    public ITextFontStorage getITextFontStorage() {
        return (ITextFontStorage)this.getFontStorage();
    }

    public BaseFontFontMetrics getBaseFontFontMetrics(String fontFamily, double fontSize, boolean bold, boolean italics, String encoding, boolean embedded, boolean antiAliasing) throws IllegalArgumentException {
        try {
            FontMetrics metrics = super.getFontMetrics(fontFamily, fontSize, bold, italics, encoding, embedded, antiAliasing);
            if (metrics instanceof LegacyFontMetrics) {
                LegacyFontMetrics lm = (LegacyFontMetrics)metrics;
                return (BaseFontFontMetrics)lm.getParent();
            }
            return (BaseFontFontMetrics)metrics;
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("Ups, I did it again! ClassCastException in RTFOutputProcessorMetaData");
        }
    }
}

