/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.data;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class SubReportDataDefinition {
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];
    private ParameterMapping[] importParameters;
    private ParameterMapping[] exportParameters;
    private Expression[] expressions;
    private DataFactory primaryDataFactory;
    private String query;
    private int queryLimit;
    private int queryTimeout;

    public SubReportDataDefinition(ParameterMapping[] importParameters, ParameterMapping[] exportParameters, DataFactory primaryDataFactory, String query, int queryLimit, int queryTimeout, Expression[] expressions) {
        this.primaryDataFactory = primaryDataFactory;
        if (exportParameters != null) {
            this.exportParameters = (ParameterMapping[])exportParameters.clone();
        }
        if (importParameters != null) {
            this.importParameters = (ParameterMapping[])importParameters.clone();
        }
        this.query = query;
        this.queryLimit = queryLimit;
        this.queryTimeout = queryTimeout;
        this.expressions = (Expression[])expressions.clone();
    }

    public String getQuery() {
        return this.query;
    }

    public int getQueryLimit() {
        return this.queryLimit;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public Expression[] getExpressions() {
        if (this.expressions == null) {
            return EMPTY_EXPRESSIONS;
        }
        Expression[] targetExpressions = new Expression[this.expressions.length];
        for (int i = 0; i < this.expressions.length; ++i) {
            Expression expression = this.expressions[i];
            targetExpressions[i] = expression.getInstance();
        }
        return targetExpressions;
    }

    public ParameterMapping[] getExportParameters() {
        if (this.exportParameters == null) {
            return null;
        }
        return (ParameterMapping[])this.exportParameters.clone();
    }

    public ParameterMapping[] getImportParameters() {
        if (this.importParameters == null) {
            return null;
        }
        return (ParameterMapping[])this.importParameters.clone();
    }

    public DataFactory getDataFactory() throws ReportDataFactoryException {
        if (this.primaryDataFactory != null) {
            return this.primaryDataFactory.derive();
        }
        return null;
    }
}

