/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout;

import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.layout.StyleReadHandler;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TableLayout;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BandStyleReadHandler
extends AbstractXmlReadHandler
implements StyleReadHandler {
    private ElementStyleSheet styleSheet;

    @Override
    public void setStyleSheet(ElementStyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public ElementStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String tableLayout;
        String layout;
        String pagebreakAfter;
        String pagebreakBefore;
        String bookmark;
        String computedSheetName = attrs.getValue(this.getUri(), "computed-sheetname");
        if (computedSheetName != null) {
            this.styleSheet.setStyleProperty(BandStyleKeys.COMPUTED_SHEETNAME, computedSheetName);
        }
        if ((bookmark = attrs.getValue(this.getUri(), "bookmark")) != null) {
            this.styleSheet.setStyleProperty(BandStyleKeys.BOOKMARK, bookmark);
        }
        if ((pagebreakBefore = attrs.getValue(this.getUri(), "pagebreak-before")) != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_BEFORE, "true".equals(pagebreakBefore));
        }
        if ((pagebreakAfter = attrs.getValue(this.getUri(), "pagebreak-after")) != null) {
            this.styleSheet.setBooleanStyleProperty(BandStyleKeys.PAGEBREAK_AFTER, "true".equals(pagebreakAfter));
        }
        if ((layout = attrs.getValue(this.getUri(), "layout")) != null) {
            this.styleSheet.setStyleProperty(BandStyleKeys.LAYOUT, layout);
        }
        if ((tableLayout = attrs.getValue(this.getUri(), "table-layout")) != null) {
            try {
                TableLayout o = (TableLayout)((Object)ConverterRegistry.toPropertyValue(tableLayout, TableLayout.class));
                this.styleSheet.setStyleProperty(BandStyleKeys.TABLE_LAYOUT, (Object)o);
            }
            catch (BeanException e) {
                throw new ParseException("Attribute 'table-layout' is not of an expected value.", this.getLocator());
            }
        }
    }

    public Object getObject() throws SAXException {
        return this.styleSheet;
    }
}

