/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.elements;

import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.AttributeMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.ResourceReference;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.BundleElementRegistry;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleElementWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.StyleWriterUtility;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public abstract class AbstractElementWriteHandler
implements BundleElementWriteHandler {
    private static final Log logger = LogFactory.getLog(AbstractElementWriteHandler.class);

    protected AbstractElementWriteHandler() {
    }

    protected void copyStaticResources(WriteableDocumentBundle bundle, BundleWriterState state, Element element) throws BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        ResourceKey contentBase = element.getContentBase();
        if (contentBase == null) {
            logger.debug((Object)"No content base, treating all content as linked.");
            return;
        }
        ResourceKey defSource = element.getDefinitionSource();
        if (defSource == null) {
            logger.debug((Object)"No report definition source, treating all content as linked.");
            return;
        }
        if (!ObjectUtilities.equal((Object)contentBase.getParent(), (Object)defSource.getParent())) {
            logger.debug((Object)"Content base points to non-bundle location, treating all content as linked.");
            return;
        }
        Object contentBasePathRaw = contentBase.getIdentifier();
        if (!(contentBasePathRaw instanceof String)) {
            return;
        }
        String contentBasePath = String.valueOf(contentBasePathRaw);
        ResourceManager resourceManager = state.getMasterReport().getResourceManager();
        ElementType type = element.getElementType();
        ElementMetaData data = type.getMetaData();
        AttributeMetaData[] datas = data.getAttributeDescriptions();
        for (int i = 0; i < datas.length; ++i) {
            Object attValue;
            AttributeMetaData attributeMetaData = datas[i];
            if (attributeMetaData.isTransient() || this.isFiltered(attributeMetaData) || (attValue = element.getAttribute(attributeMetaData.getNameSpace(), attributeMetaData.getName())) == null) continue;
            ResourceReference[] referencedResources = attributeMetaData.getReferencedResources(element, state.getMasterReport().getResourceManager(), attValue);
            for (int j = 0; j < referencedResources.length; ++j) {
                ResourceReference reference = referencedResources[j];
                if (reference.isLinked()) {
                    logger.debug((Object)("Linked Resource will not be copied into bundle: " + reference));
                    continue;
                }
                ResourceKey path = reference.getPath();
                Object identifier = path.getIdentifier();
                if (!(identifier instanceof String)) {
                    logger.warn((Object)("Resource-Bundle-Key has no parseable path: " + path));
                    continue;
                }
                String identifierString = String.valueOf(identifier);
                String relativePath = IOUtils.getInstance().createRelativePath(identifierString, contentBasePath);
                try {
                    BundleUtilities.copyInto((WriteableDocumentBundle)bundle, (String)relativePath, (ResourceKey)path, (ResourceManager)resourceManager);
                }
                catch (Exception e) {
                    throw new BundleWriterException("Failed to copy content from key " + path, e);
                }
                logger.debug((Object)("Copied " + path + " as " + relativePath));
            }
        }
    }

    protected boolean isFiltered(AttributeMetaData attributeMetaData) {
        return "http://reporting.pentaho.org/namespaces/engine/attributes/core".equals(attributeMetaData.getNameSpace()) && "element-type".equals(attributeMetaData.getName());
    }

    protected AttributeList createMainAttributes(Element element, XmlWriter writer) {
        return this.createMainAttributes(element, writer, new AttributeList());
    }

    protected AttributeList createMainAttributes(Element element, XmlWriter writer, AttributeList attList) {
        if (element == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        if (attList == null) {
            throw new NullPointerException();
        }
        ElementMetaData metaData = element.getElementType().getMetaData();
        String[] attributeNamespaces = element.getAttributeNamespaces();
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            String namespace = attributeNamespaces[i];
            String[] attributeNames = element.getAttributeNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                Object value = element.getAttribute(namespace, name);
                if (value == null) continue;
                AttributeMetaData attrMeta = metaData.getAttributeDescription(namespace, name);
                if (attrMeta == null) {
                    if (!(value instanceof String)) continue;
                    this.ensureNamespaceDefined(writer, attList, namespace);
                    attList.setAttribute(namespace, name, String.valueOf(value));
                    continue;
                }
                if (attrMeta.isTransient() || this.isFiltered(attrMeta) || attrMeta.isBulk()) continue;
                this.ensureNamespaceDefined(writer, attList, namespace);
                try {
                    PropertyEditor propertyEditor = attrMeta.getEditor();
                    if (propertyEditor != null) {
                        propertyEditor.setValue(value);
                        attList.setAttribute(namespace, name, propertyEditor.getAsText());
                        continue;
                    }
                    String attrValue = ConverterRegistry.toAttributeValue(value);
                    attList.setAttribute(namespace, name, attrValue);
                    continue;
                }
                catch (BeanException e) {
                    logger.warn((Object)("Attribute '" + namespace + '|' + name + "' is not convertible with the bean-methods"));
                }
            }
        }
        return attList;
    }

    protected void ensureNamespaceDefined(XmlWriter writer, AttributeList attList, String namespace) {
        if (!writer.isNamespaceDefined(namespace) && !attList.isNamespaceUriDefined(namespace)) {
            String prefix = ElementTypeRegistry.getInstance().getNamespacePrefix(namespace);
            if (prefix != null && !writer.isNamespacePrefixDefined(prefix)) {
                attList.addNamespaceDeclaration(prefix, namespace);
                return;
            }
            attList.addNamespaceDeclaration("autoGenNs", namespace);
        }
    }

    protected void writeElementBody(WriteableDocumentBundle bundle, BundleWriterState state, Element element, XmlWriter writer) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        StyleWriterUtility.writeStyleRule("http://reporting.pentaho.org/namespaces/engine/classic/bundle/style/1.0", "element-style", writer, element.getStyle());
        this.writeStyleExpressions(bundle, state, element, writer);
        this.writeBulkAttributes(bundle, state, element, writer);
        this.writeAttributeExpressions(bundle, state, element, writer);
    }

    private void writeBulkAttributes(WriteableDocumentBundle bundle, BundleWriterState state, Element element, XmlWriter writer) throws IOException, BundleWriterException {
        ElementMetaData metaData = element.getElementType().getMetaData();
        String[] attributeNamespaces = element.getAttributeNamespaces();
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            String namespace = attributeNamespaces[i];
            String[] attributeNames = element.getAttributeNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                AttributeList attList;
                AttributeMetaData attrMeta;
                String name = attributeNames[j];
                Object value = element.getAttribute(namespace, name);
                if (value == null || (attrMeta = metaData.getAttributeDescription(namespace, name)) == null || attrMeta.isTransient() || this.isFiltered(attrMeta) || !attrMeta.isBulk()) continue;
                if ("Resource".equals(attrMeta.getValueRole())) {
                    attList = new AttributeList();
                    if (!attList.isNamespaceUriDefined(namespace) && !writer.isNamespaceDefined(namespace)) {
                        attList.addNamespaceDeclaration("autoGenNS", namespace);
                    }
                    if (value instanceof URL) {
                        attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-type", "url");
                        writer.writeTag(namespace, attrMeta.getName(), attList, false);
                        writer.writeTextNormalized(String.valueOf(value), true);
                        writer.writeCloseTag();
                        continue;
                    }
                    if (value instanceof ResourceKey) {
                        try {
                            ResourceKey key = (ResourceKey)value;
                            ResourceManager resourceManager = bundle.getResourceManager();
                            ResourceKey bundleKey = bundle.getBundleKey().getParent();
                            String serializedKey = resourceManager.serialize(bundleKey, key);
                            attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-type", "resource-key");
                            writer.writeTag(namespace, attrMeta.getName(), attList, false);
                            writer.writeTextNormalized(serializedKey, true);
                            writer.writeCloseTag();
                            continue;
                        }
                        catch (ResourceException re) {
                            logger.error((Object)("Could not serialize the ResourceKey: " + re.getMessage()), (Throwable)re);
                            throw new IOException("Could not serialize the ResourceKey: ", re);
                        }
                    }
                    if (value instanceof File) {
                        attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-type", "file");
                        writer.writeTag(namespace, attrMeta.getName(), attList, false);
                        writer.writeTextNormalized(String.valueOf(value), true);
                        writer.writeCloseTag();
                        continue;
                    }
                    if (value instanceof String) {
                        attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-type", "local-ref");
                        writer.writeTag(namespace, attrMeta.getName(), attList, false);
                        writer.writeTextNormalized(String.valueOf(value), true);
                        writer.writeCloseTag();
                        continue;
                    }
                    logger.warn((Object)("Unknown value-type in resource-attribute " + namespace + ":" + name));
                    continue;
                }
                if ("Expression".equals(attrMeta.getValueRole()) && value instanceof Expression) {
                    attList = new AttributeList();
                    attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "attribute-namespace", namespace);
                    attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "attribute-name", name);
                    ExpressionWriterUtility.writeExpressionCore(bundle, state, (Expression)value, writer, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "expression", attList);
                    continue;
                }
                try {
                    AttributeList attList2;
                    PropertyEditor propertyEditor = attrMeta.getEditor();
                    if (propertyEditor != null) {
                        propertyEditor.setValue(value);
                        String text = propertyEditor.getAsText();
                        attList2 = new AttributeList();
                        if (!attList2.isNamespaceUriDefined(namespace) && !writer.isNamespaceDefined(namespace)) {
                            attList2.addNamespaceDeclaration("autoGenNS", namespace);
                        }
                        writer.writeTag(namespace, attrMeta.getName(), attList2, false);
                        writer.writeTextNormalized(text, true);
                        writer.writeCloseTag();
                        continue;
                    }
                    String attrValue = ConverterRegistry.toAttributeValue(value);
                    attList2 = new AttributeList();
                    if (!attList2.isNamespaceUriDefined(namespace) && !writer.isNamespaceDefined(namespace)) {
                        attList2.addNamespaceDeclaration("autoGenNS", namespace);
                    }
                    writer.writeTag(namespace, attrMeta.getName(), attList2, false);
                    writer.writeTextNormalized(attrValue, true);
                    writer.writeCloseTag();
                    continue;
                }
                catch (BeanException e) {
                    logger.warn((Object)("Attribute '" + namespace + '|' + name + "' is not convertible with the bean-methods"));
                }
            }
        }
    }

    protected void writeAttributeExpressions(WriteableDocumentBundle bundle, BundleWriterState state, Element element, XmlWriter writer) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        String[] attributeNamespaces = element.getAttributeExpressionNamespaces();
        for (int i = 0; i < attributeNamespaces.length; ++i) {
            String namespace = attributeNamespaces[i];
            String[] attributeNames = element.getAttributeExpressionNames(namespace);
            for (int j = 0; j < attributeNames.length; ++j) {
                String name = attributeNames[j];
                AttributeList attList = new AttributeList();
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "namespace", namespace);
                attList.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "name", name);
                Expression ex = element.getAttributeExpression(namespace, name);
                ExpressionWriterUtility.writeExpressionCore(bundle, state, ex, writer, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "attribute-expression", attList);
            }
        }
    }

    protected void writeStyleExpressions(WriteableDocumentBundle bundle, BundleWriterState state, Element element, XmlWriter writer) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (writer == null) {
            throw new NullPointerException();
        }
        Map<StyleKey, Expression> styleExpressions = element.getStyleExpressions();
        for (Map.Entry<StyleKey, Expression> entry : styleExpressions.entrySet()) {
            StyleKey key = entry.getKey();
            Expression ex = entry.getValue();
            ExpressionWriterUtility.writeStyleExpression(bundle, state, ex, writer, key, "http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "style-expression");
        }
    }

    protected void writeChildElements(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, Section section) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (section == null) {
            throw new NullPointerException();
        }
        if (section instanceof Band) {
            for (Element e : section) {
                if (e instanceof RootLevelBand) {
                    throw new BundleWriterException("This report cannot be saved. A normal band cannot contain other root-level bands as children unless they are contained in a subreport.");
                }
                if (!(e instanceof Section) || e instanceof Band || e instanceof SubReport) continue;
                throw new BundleWriterException(String.format("This report cannot be saved. A normal band can only contain other data elements, bands or subreports as children. You cannot add structural elements such as '%s' here.", e.getElementTypeName()));
            }
        }
        for (Element e : section) {
            BundleElementWriteHandler writeHandler = BundleElementRegistry.getInstance().getWriteHandler(e);
            writeHandler.writeElement(bundle, state, xmlWriter, e);
        }
    }

    protected void writeRootSubReports(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, RootLevelBand rootLevelBand) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (rootLevelBand == null) {
            throw new NullPointerException();
        }
        SubReport[] reports = rootLevelBand.getSubReports();
        for (int i = 0; i < reports.length; ++i) {
            this.writeSubReport(bundle, state, xmlWriter, reports[i]);
        }
    }

    protected void writeSubReport(WriteableDocumentBundle bundle, BundleWriterState state, XmlWriter xmlWriter, SubReport subReport) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        if (xmlWriter == null) {
            throw new NullPointerException();
        }
        if (subReport == null) {
            throw new NullPointerException();
        }
        String absolutePath = this.computePath(state);
        String directory = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)(absolutePath + "/subreport{0}"));
        bundle.createDirectoryEntry(directory, "application/vnd.pentaho.reporting.classic.subreport");
        String dirRelative = IOUtils.getInstance().createRelativePath(directory, absolutePath + "/.");
        BundleWriterState subReportState = new BundleWriterState(state, subReport, dirRelative + '/');
        state.getBundleWriter().writeSubReport(bundle, subReportState);
        ParameterMapping[] inputMappings = subReport.getInputMappings();
        ParameterMapping[] outputMappings = subReport.getExportMappings();
        ElementMetaData metaData = subReport.getMetaData();
        String tagName = metaData.getName();
        String namespace = metaData.getNamespace();
        if (inputMappings.length == 0 && outputMappings.length == 0) {
            xmlWriter.writeTag(namespace, tagName, "href", '/' + subReportState.getFileName() + "content.xml", true);
        } else {
            AttributeList attrs;
            ParameterMapping mapping;
            int i;
            xmlWriter.writeTag(namespace, tagName, "href", '/' + subReportState.getFileName() + "content.xml", false);
            for (i = 0; i < inputMappings.length; ++i) {
                mapping = inputMappings[i];
                attrs = new AttributeList();
                attrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "master-fieldname", mapping.getName());
                attrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "detail-fieldname", mapping.getAlias());
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "input-parameter", attrs, true);
            }
            for (i = 0; i < outputMappings.length; ++i) {
                mapping = outputMappings[i];
                attrs = new AttributeList();
                attrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "master-fieldname", mapping.getName());
                attrs.setAttribute("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "detail-fieldname", mapping.getAlias());
                xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/engine/classic/bundle/layout/1.0", "output-parameter", attrs, true);
            }
            xmlWriter.writeCloseTag();
        }
    }

    private String computePath(BundleWriterState state) {
        String absolutePathWithDummy = IOUtils.getInstance().getAbsolutePath("dummy", state.getFileName());
        String absolutePath = absolutePathWithDummy.substring(0, absolutePathWithDummy.length() - "dummy".length());
        if (absolutePath.endsWith("/")) {
            return absolutePath.substring(0, absolutePath.length() - 1);
        }
        return absolutePath;
    }
}

