/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.sql;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.QueryDefinitionsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.ConfigReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.ConnectionReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.data.sql.ConnectionReadHandlerFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SQLDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private ConnectionReadHandler connectionProviderReadHandler;
    private ArrayList<PropertyReadHandler> queries = new ArrayList();
    private ConfigReadHandler configReadHandler;
    private DataFactory dataFactory;
    private QueryDefinitionsReadHandler queryDefinitionsReadHandler;
    private PropertyReadHandler globalScriptReadHandler;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        ConnectionReadHandlerFactory factory = ConnectionReadHandlerFactory.getInstance();
        XmlReadHandler handler = factory.getHandler(uri, tagName);
        if (handler instanceof ConnectionReadHandler) {
            this.connectionProviderReadHandler = (ConnectionReadHandler)handler;
            return this.connectionProviderReadHandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("config".equals(tagName)) {
            this.configReadHandler = new ConfigReadHandler();
            return this.configReadHandler;
        }
        if ("query".equals(tagName)) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        if ("global-script".equals(tagName)) {
            this.globalScriptReadHandler = new PropertyReadHandler("language", true);
            return this.globalScriptReadHandler;
        }
        if ("query-definitions".equals(tagName)) {
            this.queryDefinitionsReadHandler = new QueryDefinitionsReadHandler();
            return this.queryDefinitionsReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        ConnectionProvider provider = null;
        if (this.connectionProviderReadHandler != null) {
            provider = (ConnectionProvider)this.connectionProviderReadHandler.getObject();
        }
        if (provider == null) {
            provider = (ConnectionProvider)this.getRootHandler().getHelperObject("connection-provider");
        }
        if (provider == null) {
            throw new SAXException("Unable to create SQL Factory: No connection provider specified or recognized.");
        }
        SQLReportDataFactory dataFactory = new SQLReportDataFactory(provider);
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = this.queries.get(i);
            dataFactory.setQuery(handler.getName(), handler.getResult(), null, null);
        }
        if (this.globalScriptReadHandler != null) {
            dataFactory.setGlobalScript(this.globalScriptReadHandler.getResult());
            dataFactory.setGlobalScriptLanguage(this.globalScriptReadHandler.getName());
        }
        if (this.queryDefinitionsReadHandler != null) {
            ArrayList<QueryDefinitionReadHandler> scriptedQueries = this.queryDefinitionsReadHandler.getScriptedQueries();
            for (QueryDefinitionReadHandler scriptedQuery : scriptedQueries) {
                dataFactory.setQuery(scriptedQuery.getName(), scriptedQuery.getQuery(), scriptedQuery.getScriptLanguage(), scriptedQuery.getScript());
            }
        }
        this.dataFactory = dataFactory;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    @Override
    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

