/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.elementfactory.BandElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.sys.GetDataRowValueExpression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.SAXException;

public class AnchorFieldReadHandler
extends AbstractElementReadHandler {
    private BandElementFactory elementFactory = new BandElementFactory();
    private String fieldName;
    private String formula;

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        String posY;
        this.elementFactory.setName(atts.getValue(this.getUri(), "name"));
        String posX = atts.getValue(this.getUri(), "x");
        if (posX != null) {
            this.elementFactory.setX(new Float(ReportParserUtil.parseRelativeFloat(posX, "Attribute 'x' not valid", this.getLocator())));
        }
        if ((posY = atts.getValue(this.getUri(), "y")) != null) {
            this.elementFactory.setY(new Float(ReportParserUtil.parseRelativeFloat(posY, "Attribute 'y' not valid", this.getLocator())));
        }
        this.fieldName = atts.getValue(this.getUri(), "fieldname");
        this.formula = atts.getValue(this.getUri(), "formula");
        if (this.formula == null && this.fieldName == null) {
            throw new ParseException("Either 'fieldname' or 'formula' attribute must be given.", this.getLocator());
        }
    }

    @Override
    protected ElementFactory getElementFactory() {
        return this.elementFactory;
    }

    @Override
    protected void doneParsing() throws SAXException {
        super.doneParsing();
        Element element = this.getElement();
        if (this.fieldName != null) {
            GetDataRowValueExpression ex = new GetDataRowValueExpression();
            ex.setField(this.fieldName);
            element.setStyleExpression(ElementStyleKeys.ANCHOR_NAME, ex);
        } else if (this.formula != null) {
            FormulaExpression fe = new FormulaExpression();
            fe.setFormula(this.formula);
            element.setStyleExpression(ElementStyleKeys.ANCHOR_NAME, fe);
        }
    }
}

