/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.NoDataBand;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.ItemBandType;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.NoDataBandType;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.GroupList;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.SubReportReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.AbstractPropertyXmlReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.FunctionsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.IncludeReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ParameterMappingReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.ParserConfigurationReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.GroupsReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.PageBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.ReportFooterReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.ReportHeaderReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.RootLevelBandReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.WatermarkReadHandler;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.xmlns.parser.IgnoreAnyChildReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.SAXException;

public class SimpleSubReportReadHandler
extends AbstractPropertyXmlReadHandler
implements SubReportReadHandler {
    private static final Log logger = LogFactory.getLog(SimpleSubReportReadHandler.class);
    public static final String REPORT_TAG = "report";
    public static final String NAME_ATT = "name";
    public static final String PAGEFORMAT_ATT = "pageformat";
    public static final String PAGESPAN_ATT = "pagespan";
    public static final String UNIT_ATT = "unit";
    public static final String LEFTMARGIN_ATT = "leftmargin";
    public static final String RIGHTMARGIN_ATT = "rightmargin";
    public static final String TOPMARGIN_ATT = "topmargin";
    public static final String BOTTOMMARGIN_ATT = "bottommargin";
    public static final String WIDTH_ATT = "width";
    public static final String HEIGHT_ATT = "height";
    public static final String ORIENTATION_ATT = "orientation";
    public static final String ORIENTATION_PORTRAIT_VAL = "portrait";
    public static final String ORIENTATION_LANDSCAPE_VAL = "landscape";
    public static final String ORIENTATION_REVERSE_LANDSCAPE_VAL = "reverse_landscape";
    private SubReport report;
    private ArrayList<ParameterMappingReadHandler> importParameters = new ArrayList();
    private ArrayList<ParameterMappingReadHandler> exportParameters = new ArrayList();
    private boolean disableRootTagWarning;
    private GroupList groupList = new GroupList();

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        rootHandler.setHelperObject("property-expansion", (Object)Boolean.TRUE);
    }

    @Override
    public void setDisableRootTagWarning(boolean disableWarning) {
        this.disableRootTagWarning = disableWarning;
    }

    public boolean isDisableRootTagWarning() {
        return this.disableRootTagWarning;
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        String useMinChunkWidth;
        String query;
        RootXmlReadHandler rootHandler;
        Object maybeReport;
        if ("sub-report".equals(this.getTagName()) && !this.disableRootTagWarning) {
            logger.info((Object)"Encountered a subreport with an <sub-report> root-element. As of version 0.8.9-rc1, this tag has been deprecated and the common <report> tag should be used for both standalone and sub-reports.");
        }
        if ((maybeReport = (rootHandler = this.getRootHandler()).getHelperObject("::Report")) instanceof SubReport) {
            this.report = (SubReport)maybeReport;
        } else {
            this.report = new SubReport();
            this.report.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "source", rootHandler.getSource());
        }
        int groupCount = this.report.getGroupCount();
        for (int i = 0; i < groupCount; ++i) {
            Group g = this.report.getGroup(i);
            if (!(g instanceof RelationalGroup)) {
                throw new ParseException("The existing report contains non-default groups. This parser cannot handle such a construct.");
            }
            this.groupList.add((RelationalGroup)g);
        }
        if (!ReportParserUtil.isIncluded(rootHandler) && (query = attrs.getValue(this.getUri(), "query")) != null) {
            this.report.setQuery(query);
        }
        if ((useMinChunkWidth = attrs.getValue(this.getUri(), "use-min-chunkwidth")) != null) {
            this.report.getStyle().setStyleProperty(ElementStyleKeys.USE_MIN_CHUNKWIDTH, ReportParserUtil.parseBoolean(useMinChunkWidth, this.getLocator()));
        }
        if (!(rootHandler.getHelperObject("::Legacy-Styles") instanceof HashMap)) {
            rootHandler.setHelperObject("::Legacy-Styles", new HashMap());
        }
        rootHandler.setHelperObject("::Report", (Object)this.report);
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.getUri().equals(uri)) {
            return null;
        }
        if ("data-factory".equals(tagName)) {
            return new IgnoreAnyChildReadHandler();
        }
        if ("reportheader".equals(tagName)) {
            return new ReportHeaderReadHandler(this.report.getReportHeader());
        }
        if ("reportfooter".equals(tagName)) {
            return new ReportFooterReadHandler(this.report.getReportFooter());
        }
        if ("pageheader".equals(tagName)) {
            return new PageBandReadHandler(this.report.getPageHeader());
        }
        if ("pagefooter".equals(tagName)) {
            return new PageBandReadHandler(this.report.getPageFooter());
        }
        if ("watermark".equals(tagName)) {
            return new WatermarkReadHandler(this.report.getWatermark());
        }
        if ("no-data-band".equals(tagName)) {
            NoDataBand noDataBand = (NoDataBand)this.report.getChildElementByType(NoDataBandType.INSTANCE);
            if (noDataBand == null) {
                throw new ParseException("Not a relational report");
            }
            return new RootLevelBandReadHandler(noDataBand);
        }
        if ("groups".equals(tagName)) {
            return new GroupsReadHandler(this.groupList);
        }
        if ("items".equals(tagName)) {
            ItemBand itemBand = (ItemBand)this.report.getChildElementByType(ItemBandType.INSTANCE);
            if (itemBand == null) {
                throw new ParseException("Not a relational report");
            }
            return new RootLevelBandReadHandler(itemBand);
        }
        if ("functions".equals(tagName)) {
            return new FunctionsReadHandler(this.report);
        }
        if ("include".equals(tagName)) {
            return new IncludeReadHandler();
        }
        if ("parser-config".equals(tagName)) {
            return new ParserConfigurationReadHandler();
        }
        if ("import-parameter".equals(tagName)) {
            ParameterMappingReadHandler handler = new ParameterMappingReadHandler();
            this.importParameters.add(handler);
            return handler;
        }
        if ("export-parameter".equals(tagName)) {
            ParameterMappingReadHandler handler = new ParameterMappingReadHandler();
            this.exportParameters.add(handler);
            return handler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        ParameterMappingReadHandler handler;
        int i;
        super.doneParsing();
        SubReport report = this.getSubReport();
        for (i = 0; i < this.importParameters.size(); ++i) {
            handler = this.importParameters.get(i);
            report.addInputParameter(handler.getName(), handler.getAlias());
        }
        for (i = 0; i < this.exportParameters.size(); ++i) {
            handler = this.exportParameters.get(i);
            report.addExportParameter(handler.getAlias(), handler.getName());
        }
        try {
            GroupList clone = (GroupList)this.groupList.clone();
            clone.installIntoReport(report);
        }
        catch (CloneNotSupportedException e) {
            throw new ParseException("Failed to add group-list to report", this.getLocator());
        }
    }

    public Object getObject() {
        return this.report;
    }

    @Override
    public SubReport getSubReport() {
        return this.report;
    }
}

