/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.sorting;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.sorting.MetaNormalizedTableModel;
import org.pentaho.reporting.engine.classic.core.sorting.SortConstraint;
import org.pentaho.reporting.engine.classic.core.sorting.SortingTableModel;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class SortingDataFactory
extends CompoundDataFactory {
    private static final Log logger = LogFactory.getLog(SortingDataFactory.class);
    private final PerformanceMonitorContext performanceMonitorContext;

    public SortingDataFactory(DataFactory parent, PerformanceMonitorContext performanceMonitorContext) {
        ArgumentNullException.validate((String)"parent", (Object)parent);
        ArgumentNullException.validate((String)"performanceMonitorContext", (Object)performanceMonitorContext);
        this.performanceMonitorContext = performanceMonitorContext;
        this.add(parent);
    }

    @Override
    protected TableModel postProcess(String query, DataRow parameters, TableModel tableModel) {
        if (tableModel == null) {
            logger.debug((Object)"No data, therefore no sorting.");
            return null;
        }
        if (tableModel.getRowCount() == 1 || tableModel.getColumnCount() == 0) {
            logger.debug((Object)"Empty data, therefore no sorting.");
            return tableModel;
        }
        Object o = parameters.get("::org.pentaho.reporting::query-sort");
        if (!(o instanceof List)) {
            logger.debug((Object)"Sort constraints are not in list format.");
            return tableModel;
        }
        List<SortConstraint> sort = this.validate((List)o);
        List<SortConstraint> resolvedConstraints = this.resolveColumnAliases(tableModel, sort);
        if (resolvedConstraints.isEmpty()) {
            logger.debug((Object)"Resolved sort constraints are empty.");
            return tableModel;
        }
        return this.sort(tableModel, resolvedConstraints);
    }

    private List<SortConstraint> resolveColumnAliases(TableModel tableModel, List<SortConstraint> sort) {
        ArrayList<SortConstraint> result = new ArrayList<SortConstraint>(sort.size());
        for (SortConstraint constraint : sort) {
            String field = constraint.getField();
            if (StringUtils.isEmpty((String)field)) {
                DebugLog.log((Object)"Sort field is empty");
                continue;
            }
            if (field.startsWith("::column::")) {
                String idx = field.substring("::column::".length());
                try {
                    int idxParsed = Integer.parseInt(idx);
                    if (idxParsed >= 0 && idxParsed < tableModel.getColumnCount()) {
                        String columnName = tableModel.getColumnName(idxParsed);
                        if (!StringUtils.isEmpty((String)columnName)) {
                            result.add(new SortConstraint(columnName, constraint.isAscending()));
                            continue;
                        }
                        DebugLog.log((Object)("Resolved column name for column at index " + idxParsed + " is empty."));
                        continue;
                    }
                    logger.debug((Object)("Invalid index on indexed column '" + field + "'"));
                }
                catch (NumberFormatException iae) {
                    logger.debug((Object)("Unable to parse non-decimal index on indexed column '" + field + "'"), (Throwable)iae);
                }
                continue;
            }
            result.add(constraint);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableModel sort(TableModel tableModel, List<SortConstraint> sortConstraints) {
        logger.debug((Object)("Sorting by " + sortConstraints));
        stopWatch.start();
        try (PerformanceLoggingStopWatch stopWatch = this.performanceMonitorContext.createStopWatch("pentaho.report.processing.query.sort");){
            SortingTableModel sortingTableModel = new SortingTableModel(new MetaNormalizedTableModel(tableModel), sortConstraints);
            return sortingTableModel;
        }
    }

    private List<SortConstraint> validate(List<?> o) {
        ArrayList<SortConstraint> c = new ArrayList<SortConstraint>(o.size());
        for (Object raw : o) {
            if (!(raw instanceof SortConstraint)) continue;
            c.add((SortConstraint)raw);
        }
        return c;
    }
}

