/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Arrays;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabSpecification;
import org.pentaho.reporting.engine.classic.core.states.datarow.FastGlobalView;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeEvent;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRowChangeHandler;
import org.pentaho.reporting.engine.classic.core.states.datarow.PaddingController;
import org.pentaho.reporting.engine.classic.core.states.datarow.ReportDataRow;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DataProcessor
implements Cloneable {
    private static final Log logger = LogFactory.getLog(DataProcessor.class);
    private PaddingController paddingDataRow;
    private ReportDataRow reportDataRow;
    private int paddingCount;
    private int cursor = 0;
    private boolean prepadding;

    public ReportDataRow getReportDataRow() {
        return this.reportDataRow;
    }

    public void clearReportDataRow(MasterDataRowChangeHandler changeHandler) {
        if (this.reportDataRow == null) {
            throw new IllegalStateException();
        }
        MasterDataRowChangeEvent event = changeHandler.getReusableEvent();
        event.reuse(2, "", "");
        int dataColCount = this.reportDataRow.getColumnCount();
        for (int i = dataColCount - 1; i >= 0; --i) {
            String columnName = this.reportDataRow.getColumnName(i);
            if (columnName == null) continue;
            event.setColumnName(columnName);
            changeHandler.dataRowChanged(event);
        }
        this.reportDataRow = null;
    }

    public void setReportDataRow(ReportDataRow reportDataRow, MasterDataRowChangeHandler changeHandler) {
        if (reportDataRow == null) {
            throw new NullPointerException();
        }
        if (this.reportDataRow != null) {
            throw new IllegalStateException();
        }
        this.reportDataRow = reportDataRow;
        MasterDataRowChangeEvent event = changeHandler.getReusableEvent();
        event.reuse(1, "", null);
        boolean readable = reportDataRow.isReadable();
        int dataColCount = reportDataRow.getColumnCount();
        for (int i = 0; i < dataColCount; ++i) {
            String columnName = reportDataRow.getColumnName(i);
            if (columnName == null) continue;
            event.setColumnName(columnName);
            if (readable) {
                event.setColumnValue(reportDataRow.get(i));
            } else {
                event.setColumnValue(null);
            }
            changeHandler.dataRowChanged(event);
        }
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getRawDataCursor() {
        return this.reportDataRow.getCursor();
    }

    public TableModel getRawData() {
        return this.reportDataRow.getReportData();
    }

    public DataProcessor advance(boolean deepTraversingOnly, FastGlobalView globalView) {
        if (deepTraversingOnly) {
            return this;
        }
        DataProcessor dataRow = this.derive();
        ++dataRow.cursor;
        if (this.paddingDataRow != null) {
            dataRow.paddingDataRow = this.paddingDataRow.advance();
            if (this.paddingCount > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Padding = " + dataRow.paddingCount + "; Cursor = " + dataRow.cursor));
                }
                --dataRow.paddingCount;
                dataRow.paddingDataRow.activate(globalView);
                dataRow.paddingDataRow.refreshPaddedRow(globalView, dataRow.reportDataRow);
            } else if (dataRow.prepadding) {
                dataRow.paddingDataRow.activate(globalView);
                dataRow.paddingDataRow.refreshRow(globalView, this.reportDataRow);
                DataProcessor.refreshData(globalView, this.reportDataRow);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Pre-Padding finished; Using dataset at cursor = " + dataRow.cursor + "; padding = " + dataRow.paddingCount));
                }
                dataRow.prepadding = false;
            } else {
                ReportDataRow tempReportDataRow = this.reportDataRow.advance();
                FastGlobalView tempGlobalView = globalView.derive();
                DataProcessor.refreshData(tempGlobalView, tempReportDataRow);
                Object[] tempRowKey = dataRow.paddingDataRow.createRowKey(tempGlobalView);
                Object[] oldRowKey = this.paddingDataRow.createRowKey(globalView);
                if (!ObjectUtilities.equalArray((Object[])tempRowKey, (Object[])oldRowKey)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("TempRowKey=" + Arrays.asList(tempRowKey) + "; RowKey=" + Arrays.asList(oldRowKey) + " Cursor=" + dataRow.cursor));
                    }
                    if (dataRow.paddingDataRow.getCurrentCursorPosition() < dataRow.paddingDataRow.getCrosstabColumnCount()) {
                        dataRow.paddingCount = dataRow.paddingDataRow.getCrosstabColumnCount() - dataRow.paddingDataRow.getCurrentCursorPosition() - 1;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("RowKey Changed - Need post-padding; Cursor = " + dataRow.cursor + "; padding = " + dataRow.paddingCount));
                        }
                        dataRow.paddingDataRow.activate(globalView);
                        dataRow.paddingDataRow.refreshPaddedRow(globalView, dataRow.reportDataRow);
                    } else {
                        dataRow.paddingDataRow = dataRow.paddingDataRow.resetRowCursor();
                        dataRow.paddingCount = dataRow.paddingDataRow.getPrePaddingRows(tempGlobalView);
                        dataRow.reportDataRow = tempReportDataRow;
                        if (dataRow.paddingCount > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RowKey Changed, but detected need for Pre-Padding = " + dataRow.paddingCount + "; Cursor = " + dataRow.cursor));
                            }
                            --dataRow.paddingCount;
                            dataRow.paddingDataRow.activate(globalView);
                            dataRow.paddingDataRow.refreshPaddedRow(globalView, dataRow.reportDataRow);
                            dataRow.prepadding = true;
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RowKey Changed; Advance; Cursor = " + dataRow.cursor + "; padding = " + dataRow.paddingCount));
                            }
                            dataRow.paddingDataRow.activate(globalView);
                            dataRow.paddingDataRow.refreshRow(globalView, tempReportDataRow);
                        }
                    }
                } else {
                    Object[] oldColKey;
                    Object[] tempColKey = dataRow.paddingDataRow.createColumnKey(tempGlobalView);
                    if (ObjectUtilities.equalArray((Object[])tempColKey, (Object[])(oldColKey = dataRow.paddingDataRow.createColumnKey(globalView)))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Row- and Column-Key still the same, staying in current crosstab-position = " + dataRow.paddingCount + "; Cursor = " + dataRow.cursor));
                        }
                        dataRow.paddingDataRow = this.paddingDataRow;
                        dataRow.reportDataRow = tempReportDataRow;
                        dataRow.paddingDataRow.activate(globalView);
                        dataRow.paddingDataRow.refreshRow(globalView, tempReportDataRow);
                    } else {
                        dataRow.paddingCount = dataRow.paddingDataRow.getPrePaddingRows(tempGlobalView);
                        if (dataRow.paddingCount > 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RowKey same, but detected need for Padding = " + dataRow.paddingCount + "; Cursor = " + dataRow.cursor));
                            }
                            --dataRow.paddingCount;
                            dataRow.paddingDataRow.activate(globalView);
                            dataRow.paddingDataRow.refreshPaddedRow(globalView, dataRow.reportDataRow);
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("RowKey Same; Advance; Cursor = " + dataRow.cursor + "; padding = " + dataRow.paddingCount));
                            }
                            dataRow.reportDataRow = tempReportDataRow;
                            dataRow.paddingDataRow.activate(globalView);
                            dataRow.paddingDataRow.refreshRow(globalView, tempReportDataRow);
                        }
                    }
                }
            }
        } else if (this.reportDataRow != null) {
            dataRow.reportDataRow = this.reportDataRow.advance();
            DataProcessor.refreshData(globalView, dataRow.reportDataRow);
        }
        return dataRow;
    }

    public boolean isAdvanceable(DataRow globalView) {
        if (this.paddingDataRow != null) {
            if (this.paddingCount > 0) {
                return true;
            }
            if (this.paddingDataRow.getPrePaddingRows(globalView) > 0) {
                return true;
            }
        }
        if (this.reportDataRow != null) {
            int colsToGo;
            if (this.reportDataRow.isAdvanceable()) {
                return true;
            }
            if (this.paddingDataRow != null && (colsToGo = this.paddingDataRow.getCrosstabColumnCount() - this.paddingDataRow.getCurrentCursorPosition() - 1) > 0) {
                return true;
            }
        }
        return false;
    }

    private static void refreshData(MasterDataRowChangeHandler changeHandler, ReportDataRow reportDataRow) {
        if (reportDataRow == null) {
            return;
        }
        logger.debug((Object)"Refreshing data");
        MasterDataRowChangeEvent event = changeHandler.getReusableEvent();
        event.reuse(3, "", null);
        int dataColCount = reportDataRow.getColumnCount();
        boolean readable = reportDataRow.isReadable();
        for (int i = 0; i < dataColCount; ++i) {
            String columnName = reportDataRow.getColumnName(i);
            if (columnName == null) continue;
            event.setColumnName(columnName);
            if (readable) {
                event.setColumnValue(reportDataRow.get(i));
            } else {
                event.setColumnValue(null);
            }
            changeHandler.dataRowChanged(event);
        }
    }

    public DataProcessor startCrosstabMode(CrosstabSpecification crosstabSpecification, FastGlobalView globalView) {
        logger.debug((Object)"Starting crosstab mode");
        DataProcessor dataRow = this.derive();
        dataRow.paddingDataRow = new PaddingController(crosstabSpecification);
        int prePaddingRows = dataRow.paddingDataRow.getPrePaddingRows(globalView);
        if (prePaddingRows > 0) {
            dataRow.paddingCount = prePaddingRows - 1;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Starting crosstab mode: cursor=" + dataRow.cursor + " pre-padding=" + dataRow.paddingCount));
            }
            dataRow.paddingDataRow.activate(globalView);
            dataRow.paddingDataRow.refreshPaddedRow(globalView, dataRow.reportDataRow);
            dataRow.prepadding = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting crosstab mode: cursor=" + dataRow.cursor + " pre-padding=" + dataRow.paddingCount));
        }
        return dataRow;
    }

    public void refresh(FastGlobalView globalView) {
        if (this.paddingDataRow != null && this.reportDataRow != null) {
            this.paddingDataRow.activate(globalView);
            if (this.paddingCount > 0) {
                this.paddingDataRow.refreshPaddedRow(globalView, this.reportDataRow);
            } else {
                this.paddingDataRow.refreshRow(globalView, this.reportDataRow);
            }
        } else if (this.reportDataRow != null) {
            DataProcessor.refreshData(globalView, this.reportDataRow);
        }
    }

    public DataProcessor endCrosstabMode() {
        logger.debug((Object)"Ending crosstab mode");
        DataProcessor retval = this.derive();
        retval.paddingDataRow = null;
        return retval;
    }

    public DataProcessor resetRowCursor() {
        if (this.paddingDataRow != null) {
            DataProcessor dataRow = this.derive();
            dataRow.paddingDataRow = dataRow.paddingDataRow.resetRowCursor();
            return dataRow;
        }
        return this;
    }

    public DataProcessor derive() {
        return this.clone();
    }

    public DataProcessor clone() {
        try {
            DataProcessor clone = (DataProcessor)super.clone();
            if (this.paddingDataRow != null) {
                clone.paddingDataRow = this.paddingDataRow.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public CrosstabSpecification getCrosstabSpecification() {
        if (this.paddingDataRow == null) {
            return null;
        }
        return this.paddingDataRow.getCrosstabSpecification();
    }

    public boolean isCrosstabActive() {
        return this.paddingDataRow != null;
    }

    public boolean isSameState(DataProcessor processor) {
        if (processor.prepadding != this.prepadding) {
            return false;
        }
        if (processor.cursor != this.cursor) {
            return false;
        }
        return processor.paddingCount == this.paddingCount;
    }
}

