/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.states.StateUtilities;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaDefinition;

class SubReportProcessPreprocessor {
    private final DefaultFlowController startFlowController;
    private DefaultFlowController flowController;
    private ReportPreProcessor[] processors;
    private boolean designtime;

    public SubReportProcessPreprocessor(DefaultFlowController startFlowController) {
        this.startFlowController = startFlowController;
        OutputProcessorMetaData md = startFlowController.getReportContext().getOutputProcessorMetaData();
        this.designtime = md.isFeatureSupported(OutputProcessorFeature.DESIGNTIME);
    }

    public DefaultFlowController getFlowController() {
        return this.flowController;
    }

    public SubReport invokePreDataProcessing(SubReport report) throws ReportProcessingException {
        this.flowController = this.startFlowController;
        this.processors = StateUtilities.getAllPreProcessors(report, this.designtime);
        DataSchemaDefinition fullDefinition = report.getDataSchemaDefinition();
        SubReport fullReport = report;
        for (int i = 0; i < this.processors.length; ++i) {
            ReportPreProcessor processor = this.processors[i];
            if ((fullReport = processor.performPreDataProcessing(fullReport, this.flowController)).getDataSchemaDefinition() == fullDefinition) continue;
            fullDefinition = fullReport.getDataSchemaDefinition();
            this.flowController = this.flowController.updateDataSchema(fullDefinition);
        }
        return fullReport;
    }

    public SubReport invokePreProcessing(SubReport report) throws ReportProcessingException {
        this.flowController = this.startFlowController;
        this.processors = StateUtilities.getAllPreProcessors(report, this.designtime);
        DataSchemaDefinition fullDefinition = report.getDataSchemaDefinition();
        SubReport fullReport = report;
        for (int i = 0; i < this.processors.length; ++i) {
            ReportPreProcessor processor = this.processors[i];
            if ((fullReport = processor.performPreProcessing(fullReport, this.flowController)).getDataSchemaDefinition() == fullDefinition) continue;
            fullDefinition = fullReport.getDataSchemaDefinition();
            this.flowController = this.flowController.updateDataSchema(fullDefinition);
        }
        return fullReport;
    }
}

