/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util.beans;

import java.awt.BasicStroke;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class BasicStrokeValueConverter
implements ValueConverter {
    @Override
    public String toAttributeValue(Object o) throws BeanException {
        if (!(o instanceof BasicStroke)) {
            throw new BeanException();
        }
        BasicStroke s = (BasicStroke)o;
        float lineWidth = s.getLineWidth();
        int lineJoin = s.getLineJoin();
        float dashPhase = s.getDashPhase();
        int endCap = s.getEndCap();
        float mitterLimit = s.getMiterLimit();
        float[] dashArray = s.getDashArray();
        StringBuilder b = new StringBuilder();
        if (dashArray != null) {
            for (int i = 0; i < dashArray.length; ++i) {
                if (i != 0) {
                    b.append(",");
                }
                b.append(dashArray[i]);
            }
        }
        return String.format(Locale.US, "BasicStroke:%f:%d:%f:%d:%f:%s", Float.valueOf(lineWidth), lineJoin, Float.valueOf(dashPhase), endCap, Float.valueOf(mitterLimit), b.toString());
    }

    @Override
    public Object toPropertyValue(String s) throws BeanException {
        String[] parsedResult = StringUtils.split((String)s, (String)":");
        if (parsedResult.length < 6) {
            throw new BeanException("ParsedResult length: " + parsedResult.length);
        }
        if (!"BasicStroke".equals(parsedResult[0])) {
            throw new BeanException();
        }
        try {
            float[] dashArray;
            float lineWidth = Float.parseFloat(parsedResult[1]);
            int lineJoin = Integer.parseInt(parsedResult[2]);
            float dashPhase = Float.parseFloat(parsedResult[3]);
            int endCap = Integer.parseInt(parsedResult[4]);
            float mitterLimit = Float.parseFloat(parsedResult[5]);
            if (parsedResult.length == 7) {
                String[] dashArrayText = StringUtils.split((String)parsedResult[6], (String)",");
                dashArray = new float[dashArrayText.length];
                for (int i = 0; i < dashArrayText.length; ++i) {
                    dashArray[i] = Float.parseFloat(dashArrayText[i]);
                }
            } else {
                dashArray = null;
            }
            return new BasicStroke(lineWidth, endCap, lineJoin, mitterLimit, dashArray, dashPhase);
        }
        catch (Exception e) {
            throw new BeanException("Failed to parse basic-stroke: " + s, e);
        }
    }
}

