/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.wizard;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.wizard.ConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReference;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeReferences;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class DefaultDataAttributes
implements DataAttributes {
    private AttributeMap<Entry> backend = new AttributeMap();

    public void setMetaAttribute(String domain, String name, ConceptQueryMapper conceptMapper, Object value) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (domain == null) {
            throw new NullPointerException();
        }
        this.backend.setAttribute(domain, name, (Object)new Entry(conceptMapper, value));
    }

    @Override
    public String[] getMetaAttributeDomains() {
        return this.backend.getNameSpaces();
    }

    @Override
    public String[] getMetaAttributeNames(String domainName) {
        if (domainName == null) {
            throw new NullPointerException();
        }
        return this.backend.getNames(domainName);
    }

    @Override
    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        return this.getMetaAttribute(domain, name, type, context, null);
    }

    @Override
    public Object getMetaAttribute(String domain, String name, Class type, DataAttributeContext context, Object defaultValue) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Entry attribute = (Entry)this.backend.getAttribute(domain, name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.value == null) {
            return defaultValue;
        }
        ConceptQueryMapper mapper = attribute.mapper;
        return mapper.getValue(attribute.value, type, context);
    }

    @Override
    public ConceptQueryMapper getMetaAttributeMapper(String domain, String name) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (name == null) {
            throw new NullPointerException();
        }
        Entry attribute = (Entry)this.backend.getAttribute(domain, name);
        if (attribute == null) {
            return DefaultConceptQueryMapper.INSTANCE;
        }
        return attribute.mapper;
    }

    public void merge(DataAttributes attributes, DataAttributeContext context) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String[] domains = attributes.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = attributes.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Object value = attributes.getMetaAttribute(domain, name, null, context);
                if (value == null) continue;
                ConceptQueryMapper mapper = attributes.getMetaAttributeMapper(domain, name);
                this.backend.setAttribute(domain, name, (Object)new Entry(mapper, value));
            }
        }
    }

    public void mergeReferences(DataAttributeReferences references, DataAttributeContext context) {
        if (references == null) {
            throw new NullPointerException();
        }
        if (context == null) {
            throw new NullPointerException();
        }
        String[] domains = references.getMetaAttributeDomains();
        for (int i = 0; i < domains.length; ++i) {
            String domain = domains[i];
            String[] names = references.getMetaAttributeNames(domain);
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                DataAttributeReference ref = references.getReference(domain, name);
                Object value = ref.resolve(this, context);
                if (value == null) continue;
                ConceptQueryMapper conceptQueryMapper = ref.resolveMapper(this);
                this.backend.setAttribute(domain, name, (Object)new Entry(conceptQueryMapper, value));
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultDataAttributes o = (DefaultDataAttributes)super.clone();
        o.backend = this.backend.clone();
        return o;
    }

    public boolean isEmpty() {
        return this.backend.getNameSpaces().length == 0;
    }

    private static class Entry
    implements Serializable {
        public final ConceptQueryMapper mapper;
        public final Object value;

        private Entry(ConceptQueryMapper mapper, Object value) {
            this.mapper = mapper;
            this.value = value;
        }
    }
}

