/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.orc.output;

import org.pentaho.big.data.kettle.plugins.formats.BaseFormatOutputField;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.hadoop.shim.api.format.IOrcOutputField;
import org.pentaho.hadoop.shim.api.format.OrcSpec;

public class OrcOutputField
extends BaseFormatOutputField
implements IOrcOutputField {
    public OrcSpec.DataType getOrcType() {
        return OrcSpec.DataType.values()[this.formatType];
    }

    public void setFormatType(OrcSpec.DataType orcType) {
        this.formatType = orcType.getId();
    }

    @Override
    public void setFormatType(int formatType) {
        for (OrcSpec.DataType orcType : OrcSpec.DataType.values()) {
            if (orcType.getId() != formatType) continue;
            this.formatType = formatType;
        }
    }

    @Injection(name="FIELD_TYPE", group="FIELDS")
    public void setFormatType(String typeName) {
        try {
            this.setFormatType(Integer.parseInt(typeName));
        }
        catch (NumberFormatException nfe) {
            for (OrcSpec.DataType orcType : OrcSpec.DataType.values()) {
                if (!orcType.getName().equals(typeName)) continue;
                this.formatType = orcType.ordinal();
            }
        }
    }

    public boolean isDecimalType() {
        return this.getOrcType().equals((Object)OrcSpec.DataType.DECIMAL);
    }

    @Override
    public void setPrecision(String precision) {
        if (precision == null || precision.trim().length() == 0) {
            this.precision = this.isDecimalType() ? 20 : 0;
        } else {
            this.precision = Integer.valueOf(precision);
            if (this.precision <= 0 && this.isDecimalType()) {
                this.precision = 20;
            }
        }
    }

    @Override
    public void setScale(String scale) {
        if (scale == null || scale.trim().length() == 0) {
            this.scale = this.isDecimalType() ? 10 : 0;
        } else {
            this.scale = Integer.valueOf(scale);
            if (this.scale < 0) {
                this.scale = this.isDecimalType() ? 10 : 0;
            }
        }
    }
}

