/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle;

import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransFromFileProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.ui.datasources.kettle.KettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;

public class FileKettleQueryEntry
extends KettleQueryEntry {
    private String file;
    private String selectedStepName;
    private List<StepMeta> cachedSteps;

    public FileKettleQueryEntry(String aName) {
        super(aName);
    }

    public FileKettleQueryEntry(String aName, KettleTransformationProducer producer) {
        super(aName);
        this.file = producer.getTransformationFile();
        this.selectedStepName = producer.getStepName();
        if (producer instanceof AbstractKettleTransformationProducer) {
            AbstractKettleTransformationProducer p = (AbstractKettleTransformationProducer)producer;
            this.setArguments(p.getArguments());
            this.setParameters(p.getParameter());
            this.setStopOnErrors(p.isStopOnError());
        }
    }

    @Override
    public boolean validate() {
        return super.validate() && !StringUtils.isEmpty((String)this.selectedStepName) && !StringUtils.isEmpty((String)this.file);
    }

    public void setFile(String file) {
        this.file = file;
        this.clearCachedEntries();
        this.setValidated(this.validate());
    }

    @Override
    protected void clearCachedEntries() {
        super.clearCachedEntries();
        this.cachedSteps = null;
    }

    public String getFile() {
        return this.file;
    }

    public String getSelectedStep() {
        return this.selectedStepName;
    }

    public void setSelectedStep(String selectedStep) {
        this.selectedStepName = selectedStep;
        this.setValidated(this.validate());
    }

    @Override
    public KettleParameterInfo[] getDeclaredParameters(DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        if (StringUtils.isEmpty((String)this.file)) {
            return new KettleParameterInfo[0];
        }
        return super.getDeclaredParameters(context);
    }

    @Override
    protected AbstractKettleTransformationProducer loadTransformation(DataFactoryContext context) {
        return new InternalKettleTransFromFileProducer(this.file);
    }

    public List<StepMeta> getSteps(DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        if (StringUtils.isEmpty((String)this.file)) {
            return Collections.emptyList();
        }
        if (this.cachedSteps == null) {
            AbstractKettleTransformationProducer trans = this.loadTransformation(context);
            TransMeta transMeta = trans.loadTransformation(context);
            this.cachedSteps = Collections.unmodifiableList(transMeta.getSteps());
        }
        return this.cachedSteps;
    }

    @Override
    public KettleTransformationProducer createProducer() {
        FormulaArgument[] argumentFields = this.getArguments();
        FormulaParameter[] varNames = this.getParameters();
        String file = this.getFile();
        String selectedStep = this.getSelectedStep();
        KettleTransFromFileProducer kettleTransFromFileProducer = new KettleTransFromFileProducer(file, selectedStep, argumentFields, varNames);
        kettleTransFromFileProducer.setStopOnError(this.isStopOnErrors());
        return kettleTransFromFileProducer;
    }

    private static class InternalKettleTransFromFileProducer
    extends KettleTransFromFileProducer {
        public InternalKettleTransFromFileProducer(String transformationFile) {
            super(transformationFile, null, new FormulaArgument[0], new FormulaParameter[0]);
        }

        public TransMeta loadTransformation(Repository repository, ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException, KettleException {
            return super.loadTransformation(repository, resourceManager, contextKey);
        }
    }
}

