/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;
import org.pentaho.reporting.ui.datasources.kettle.embedded.TransformationParameterHelper;

public abstract class KettleQueryEntry {
    private String name;
    private FormulaArgument[] arguments;
    private FormulaParameter[] parameters;
    private TransformationParameterHelper parameterHelper;
    private boolean validated;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean stopOnErrors;

    public KettleQueryEntry(String aName) {
        this.name = aName;
        this.arguments = new FormulaArgument[0];
        this.parameters = new FormulaParameter[0];
        this.stopOnErrors = true;
    }

    public void setStopOnErrors(boolean stopOnErrors) {
        this.stopOnErrors = stopOnErrors;
    }

    public boolean isStopOnErrors() {
        return this.stopOnErrors;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void setValidated(boolean validated) {
        boolean oldValid = this.validated;
        this.validated = validated;
        this.propertyChangeSupport.firePropertyChange("validated", oldValid, validated);
    }

    protected boolean validate() {
        return !StringUtils.isEmpty((String)this.name);
    }

    protected void clearCachedEntries() {
        this.parameterHelper = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setValidated(this.validate());
    }

    public FormulaArgument[] getArguments() {
        return (FormulaArgument[])this.arguments.clone();
    }

    public void setArguments(FormulaArgument[] arguments) {
        this.arguments = (FormulaArgument[])arguments.clone();
    }

    public FormulaParameter[] getParameters() {
        return (FormulaParameter[])this.parameters.clone();
    }

    public void setParameters(FormulaParameter[] parameters) {
        this.parameters = (FormulaParameter[])parameters.clone();
    }

    public String toString() {
        return this.name;
    }

    public KettleParameterInfo[] getDeclaredParameters(DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        if (this.parameterHelper == null) {
            this.parameterHelper = new TransformationParameterHelper(this.loadTransformation(context), context);
        }
        return this.parameterHelper.getDeclaredParameter();
    }

    protected abstract AbstractKettleTransformationProducer loadTransformation(DataFactoryContext var1) throws KettleException;

    public abstract KettleTransformationProducer createProducer() throws KettleException;
}

