/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.data.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.fortuna.mstor.data.xml.XmlBinding;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DocumentBinding
extends XmlBinding {
    private File file;
    private Document document;
    private String rootElementName;

    public DocumentBinding(File file, String rootElementName) {
        this.file = file;
        this.rootElementName = rootElementName;
    }

    public DocumentBinding(File file, Namespace namespace, String rootElementName) {
        super(namespace);
        this.file = file;
        this.rootElementName = rootElementName;
    }

    public final Document getDocument() {
        if (this.document == null) {
            try {
                SAXBuilder builder = new SAXBuilder();
                this.document = builder.build(this.file);
            }
            catch (Exception e) {
                this.document = new Document(new Element(this.rootElementName, this.namespace));
            }
        }
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() throws IOException {
        XMLOutputter xmlOut = new XMLOutputter(Format.getPrettyFormat());
        xmlOut.getFormat().setIndent("  ");
        FileOutputStream fout = new FileOutputStream(this.file);
        try {
            xmlOut.output(this.getDocument(), (OutputStream)fout);
        }
        finally {
            fout.close();
        }
    }
}

