/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.wizard.model.ElementFormatDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.FieldDefinition;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class WizardOverrideFormattingFunction
extends AbstractElementFormatFunction
implements StructureFunction {
    public int getProcessingPriority() {
        return 6000;
    }

    protected boolean evaluateElement(ReportElement e) {
        Object maybeFieldData;
        if (e == null) {
            throw new NullPointerException();
        }
        boolean retval = false;
        Object maybeFormatData = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData");
        if (maybeFormatData instanceof ElementFormatDefinition) {
            ElementFormatDefinition formatDefinition = (ElementFormatDefinition)maybeFormatData;
            if (formatDefinition.getBackgroundColor() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, (Object)formatDefinition.getBackgroundColor());
                retval = true;
            }
            if (formatDefinition.getFontColor() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.PAINT, (Object)formatDefinition.getFontColor());
                retval = true;
            }
            if (formatDefinition.getFontBold() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)formatDefinition.getFontBold());
                retval = true;
            }
            if (formatDefinition.getFontItalic() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.ITALIC, (Object)formatDefinition.getFontItalic());
                retval = true;
            }
            if (formatDefinition.getFontName() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.FONT, (Object)formatDefinition.getFontName());
                retval = true;
            }
            if (formatDefinition.getFontUnderline() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.UNDERLINED, (Object)formatDefinition.getFontUnderline());
                retval = true;
            }
            if (formatDefinition.getFontItalic() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.ITALIC, (Object)formatDefinition.getFontItalic());
                retval = true;
            }
            if (formatDefinition.getFontSize() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.FONTSIZE, (Object)formatDefinition.getFontSize());
                retval = true;
            }
            if (formatDefinition.getFontStrikethrough() != null) {
                e.getStyle().setStyleProperty(TextStyleKeys.STRIKETHROUGH, (Object)formatDefinition.getFontStrikethrough());
                retval = true;
            }
            if (formatDefinition.getHorizontalAlignment() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.ALIGNMENT, (Object)formatDefinition.getHorizontalAlignment());
                retval = true;
            }
            if (formatDefinition.getVerticalAlignment() != null) {
                e.getStyle().setStyleProperty(ElementStyleKeys.VALIGNMENT, (Object)formatDefinition.getVerticalAlignment());
                retval = true;
            }
        }
        if ((maybeFieldData = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData")) instanceof FieldDefinition) {
            FieldDefinition fieldDefinition = (FieldDefinition)maybeFieldData;
            if (fieldDefinition.getDataFormat() != null) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "format-string", (Object)fieldDefinition.getDataFormat());
                retval = true;
            }
            if (fieldDefinition.getNullString() != null) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", (Object)fieldDefinition.getNullString());
                retval = true;
            }
            if ("label".equals(e.getElementType().getMetaData().getName()) && !StringUtils.isEmpty((String)fieldDefinition.getDisplayName())) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)fieldDefinition.getDisplayName());
            }
        }
        return retval;
    }
}

