/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRTaskContext;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStoreImpl;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class MapReducePOStoreImpl
extends POStoreImpl {
    private TaskAttemptContext context;
    private PigStatusReporter reporter;
    private RecordWriter<?, ?> writer;

    public MapReducePOStoreImpl(TaskInputOutputContext<?, ?, ?, ?> context) {
        Configuration outputConf = new Configuration(context.getConfiguration());
        this.reporter = PigStatusReporter.getInstance();
        this.reporter.setContext(new MRTaskContext(context));
        this.context = HadoopShims.createTaskAttemptContext(outputConf, context.getTaskAttemptID());
    }

    @Override
    public StoreFuncInterface createStoreFunc(POStore store) throws IOException {
        StoreFuncInterface storeFunc = store.getStoreFunc();
        PigOutputFormat.setLocation((JobContext)this.context, store);
        OutputFormat outputFormat = storeFunc.getOutputFormat();
        try {
            this.writer = outputFormat.getRecordWriter(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        storeFunc.prepareToWrite(this.writer);
        return storeFunc;
    }

    @Override
    public void tearDown() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = null;
        }
    }

    @Override
    public void cleanUp() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = null;
        }
    }

    public void incrRecordCounter(String name, long incr) {
        this.reporter.incrCounter("MultiStoreCounters", name, incr);
    }
}

