/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.cdi;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ops4j.pax.exam.cdi.spi.BeanManagerProvider;

public class BeanManagerLookup {
    private static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
    private static final String BEAN_MANAGER_JNDI_FALLBACK = "java:comp/env/BeanManager";

    private BeanManagerLookup() {
    }

    public static BeanManager getBeanManager() {
        BeanManager mgr = BeanManagerLookup.getBeanManagerFromJndi();
        if (mgr == null) {
            ServiceLoader<BeanManagerProvider> loader = ServiceLoader.load(BeanManagerProvider.class);
            Iterator<BeanManagerProvider> it = loader.iterator();
            while (mgr == null && it.hasNext()) {
                BeanManagerProvider provider = it.next();
                mgr = provider.getBeanManager();
            }
        }
        return mgr;
    }

    private static BeanManager getBeanManagerFromJndi() {
        BeanManager mgr = BeanManagerLookup.getBeanManagerFromJndi(BEAN_MANAGER_JNDI);
        if (mgr == null) {
            mgr = BeanManagerLookup.getBeanManagerFromJndi(BEAN_MANAGER_JNDI_FALLBACK);
        }
        return mgr;
    }

    private static BeanManager getBeanManagerFromJndi(String name) {
        BeanManager mgr;
        try {
            InitialContext ctx = new InitialContext();
            mgr = (BeanManager)ctx.lookup(name);
        }
        catch (NamingException e) {
            mgr = null;
        }
        return mgr;
    }
}

