/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp.tenantaware;

import java.text.MessageFormat;
import javax.sql.DataSource;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledOrJndiDatasourceService;
import org.pentaho.platform.engine.services.messages.Messages;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractTenantAwareDatasourceService
extends PooledOrJndiDatasourceService
implements InitializingBean {
    private String datasourceNameFormat = "{0}-{1}";
    private boolean requireTenantId;

    public void afterPropertiesSet() throws Exception {
        if (this.datasourceNameFormat.indexOf("{0}") < 0 || this.datasourceNameFormat.indexOf("{1}") < 0) {
            throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("TenantAwareDatasourceService.ERROR_0001_NAME_FORMAT_ILLEGAL"));
        }
    }

    @Override
    public DataSource getDataSource(String dsName) throws DBDatasourceServiceException {
        String tenantId = this.getTenantId();
        if (tenantId == null) {
            if (this.isRequireTenantId()) {
                throw new DBDatasourceServiceException(Messages.getInstance().getErrorString("TenantAwareDatasourceService.ERROR_0002_TENANT_ID_REQUIRED"));
            }
            return super.getDataSource(dsName);
        }
        return super.getDataSource(MessageFormat.format(this.getDatasourceNameFormat(), tenantId, dsName));
    }

    public abstract String getTenantId();

    public void setDatasourceNameFormat(String value) {
        this.datasourceNameFormat = value;
    }

    public String getDatasourceNameFormat() {
        return this.datasourceNameFormat;
    }

    public void setRequireTenantId(boolean value) {
        this.requireTenantId = value;
    }

    public boolean isRequireTenantId() {
        return this.requireTenantId;
    }
}

