/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.logging.Logger;

public class PasswordHelper {
    private static final String ENC = "ENC:";
    private IPasswordService passwordService;

    public PasswordHelper() {
        this(PentahoSystem.get(IPasswordService.class, null));
    }

    public PasswordHelper(IPasswordService passwordService) {
        this.passwordService = passwordService;
    }

    public String getPassword(String input) {
        if (input != null && input.startsWith(ENC)) {
            try {
                return this.passwordService.decrypt(input.substring(4));
            }
            catch (PasswordServiceException e) {
                Logger.error(this, "Exception decrypting password", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return input;
    }

    public String encrypt(String password) {
        try {
            return ENC + this.passwordService.encrypt(password);
        }
        catch (PasswordServiceException e) {
            Logger.error(this, "Exception encrypting password", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

