/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.client;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.commons.util.repository.GetCheckedoutDocsResponse;
import org.pentaho.commons.util.repository.INavigationService;
import org.pentaho.commons.util.repository.exception.ConstraintViolationException;
import org.pentaho.commons.util.repository.exception.FilterNotValidException;
import org.pentaho.commons.util.repository.exception.FolderNotValidException;
import org.pentaho.commons.util.repository.exception.InvalidArgumentException;
import org.pentaho.commons.util.repository.exception.ObjectNotFoundException;
import org.pentaho.commons.util.repository.exception.OperationNotSupportedException;
import org.pentaho.commons.util.repository.exception.PermissionDeniedException;
import org.pentaho.commons.util.repository.exception.RuntimeException;
import org.pentaho.commons.util.repository.exception.UpdateConflictException;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.commons.util.repository.type.CmisObjectImpl;
import org.pentaho.commons.util.repository.type.CmisProperties;
import org.pentaho.commons.util.repository.type.CmisProperty;
import org.pentaho.commons.util.repository.type.PropertyBoolean;
import org.pentaho.commons.util.repository.type.PropertyDateTime;
import org.pentaho.commons.util.repository.type.PropertyId;
import org.pentaho.commons.util.repository.type.PropertyString;
import org.pentaho.commons.util.repository.type.TypesOfFileableObjects;
import org.pentaho.platform.util.StringUtil;

public class BiPlatformRepositoryClientNavigationService
implements INavigationService {
    private Document doc;

    public Document getDoc() {
        return this.doc;
    }

    public void setDoc(Document doc) {
        this.doc = doc;
    }

    @Override
    public List<CmisObject> getObjectParent(String repositoryId, String objectId, String filter, boolean includeAllowableActions, boolean includeRelationships) throws InvalidArgumentException, ConstraintViolationException, FilterNotValidException, RuntimeException, UpdateConflictException, ObjectNotFoundException, OperationNotSupportedException, PermissionDeniedException, FolderNotValidException {
        if (!repositoryId.equals("PLATFORMORIG")) {
            throw new InvalidArgumentException();
        }
        ArrayList<CmisObject> objects = new ArrayList<CmisObject>();
        Element objectElement = this.getObjectElement(objectId);
        if (objectElement == null) {
            return objects;
        }
        Element parentElement = objectElement.getParent();
        if (parentElement == null) {
            return objects;
        }
        CmisObject parent = this.createCmisObjectFromElement(parentElement, 0);
        objects.add(parent);
        return objects;
    }

    private CmisObject createCmisObjectFromElement(Element element, int depth) {
        CmisObjectImpl object = new CmisObjectImpl();
        CmisProperties properties = new CmisProperties();
        List<CmisProperty> propList = properties.getProperties();
        boolean isDirectory = false;
        Attribute attr = element.attribute("isDirectory");
        if (attr != null) {
            isDirectory = "true".equalsIgnoreCase(attr.getText());
        }
        String objectId = this.getObjectId(element);
        Calendar lastModifiedDate = this.getLastModifiedDate(element);
        String name = this.getName(element);
        String localizedName = this.getLocalizedName(element);
        String extension = this.getExtension(element);
        boolean visible = this.getVisible(element);
        propList.add(new PropertyId("ObjectId", objectId));
        propList.add(new PropertyDateTime("LastModificationDate", lastModifiedDate));
        if (isDirectory) {
            propList.add(new PropertyString("ObjectTypeId", "Folder"));
        } else {
            propList.add(new PropertyString("ObjectTypeId", extension));
            propList.add(new PropertyBoolean("ContentStreamAllowed", true));
        }
        propList.add(new PropertyString("Name", name));
        propList.add(new PropertyString("LocalizedName", localizedName));
        propList.add(new PropertyBoolean("Visible", visible));
        object.setProperties(properties);
        return object;
    }

    private String getObjectId(Element element) {
        ArrayList<Element> pathElements = new ArrayList<Element>();
        for (Element current = element; current != null; current = current.getParent()) {
            pathElements.add(0, current);
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        for (Element pathElement : pathElements) {
            if (idx > 1) {
                sb.append("/");
            }
            if (idx > 0) {
                sb.append(pathElement.attribute("name").getText());
            }
            ++idx;
        }
        String objectId = sb.toString();
        return objectId;
    }

    private Calendar getLastModifiedDate(Element element) {
        String lastModifiedDateStr = "";
        Attribute attr = element.attribute("lastModifiedDate");
        if (attr != null) {
            lastModifiedDateStr = attr.getText();
            long millis = new Long(lastModifiedDateStr);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
        return null;
    }

    private String getLocalizedName(Element element) {
        String name = "";
        Attribute attr = element.attribute("localized-name");
        if (attr != null) {
            name = attr.getText();
        }
        return name;
    }

    private String getName(Element element) {
        String name = "";
        Attribute attr = element.attribute("name");
        if (attr != null) {
            name = attr.getText();
        }
        return name;
    }

    private boolean getVisible(Element element) {
        boolean visible = true;
        Attribute attr = element.attribute("visible");
        if (attr != null) {
            visible = "true".equalsIgnoreCase(attr.getText());
        }
        return visible;
    }

    private String getExtension(Element element) {
        String name = "";
        Attribute attr = element.attribute("name");
        if (attr != null) {
            name = attr.getText();
        }
        int idx = name.indexOf(46);
        String extension = "";
        if (idx != -1) {
            extension = name.substring(idx + 1);
        }
        return extension;
    }

    private Element getObjectElement(String path) throws ObjectNotFoundException {
        String xPath;
        Element element;
        String folderName;
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuilder sb = new StringBuilder();
        sb.append("/repository");
        int tokenCount = tokenizer.countTokens();
        for (int idx = 0; idx < tokenCount - 1; ++idx) {
            folderName = tokenizer.nextToken();
            sb.append("/file[@isDirectory='true' and @name='").append(folderName).append("']");
        }
        if (tokenizer.hasMoreTokens()) {
            folderName = tokenizer.nextToken();
            sb.append("/file[@name='").append(folderName).append("']");
        }
        if ((element = (Element)this.doc.selectSingleNode(xPath = sb.toString())) == null) {
            throw new ObjectNotFoundException();
        }
        return element;
    }

    private Element getFolderElement(String path) throws FolderNotValidException {
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        StringBuilder sb = new StringBuilder();
        sb.append("/repository");
        while (tokenizer.hasMoreTokens()) {
            String folderName = tokenizer.nextToken();
            sb.append("/file[@isDirectory='true' and @name='").append(folderName).append("']");
        }
        String xPath = sb.toString();
        Element element = (Element)this.doc.selectSingleNode(xPath);
        if (element == null) {
            throw new FolderNotValidException();
        }
        return element;
    }

    @Override
    public List<CmisObject> getFolderParent(String repositoryId, String folderId, String filter, boolean includeAllowableActions, boolean includeRelationships, boolean returnToRoot) throws InvalidArgumentException, ConstraintViolationException, FilterNotValidException, RuntimeException, UpdateConflictException, ObjectNotFoundException, OperationNotSupportedException, PermissionDeniedException, FolderNotValidException {
        if (!repositoryId.equals("PLATFORMORIG")) {
            throw new InvalidArgumentException();
        }
        ArrayList<CmisObject> objects = new ArrayList<CmisObject>();
        Element objectElement = this.getFolderElement(folderId);
        Element parentElement = objectElement.getParent();
        if (parentElement == null) {
            return objects;
        }
        CmisObject parent = this.createCmisObjectFromElement(parentElement, 0);
        objects.add(parent);
        return objects;
    }

    @Override
    public List<CmisObject> getDescendants(String repositoryId, String folderId, TypesOfFileableObjects type, int depth, String filter, boolean includeAllowableActions, boolean includeRelationships) throws InvalidArgumentException, ConstraintViolationException, FilterNotValidException, RuntimeException, UpdateConflictException, ObjectNotFoundException, OperationNotSupportedException, PermissionDeniedException, FolderNotValidException {
        Collection filters = null;
        if (!StringUtil.isEmpty(filter)) {
            filters = this.getFilterCollection(filter);
        }
        if (!repositoryId.equals("PLATFORMORIG")) {
            throw new InvalidArgumentException();
        }
        ArrayList<CmisObject> objects = new ArrayList<CmisObject>();
        Element objectElement = this.getFolderElement(folderId);
        this.addChildren(objects, objectElement, type, filters, 0, 0, depth, 1);
        return objects;
    }

    protected void addChildren(List<CmisObject> objects, Element objectElement, TypesOfFileableObjects type, Collection filters, int maxItems, int skipCount, int depth, int level) {
        if (objectElement == null) {
            return;
        }
        int skipped = 0;
        boolean ok = false;
        for (Object element : objectElement.elements()) {
            String objectType;
            ok = false;
            CmisObject object = this.createCmisObjectFromElement((Element)element, 0);
            if (type == null || type.getValue().equals("any")) {
                ok = true;
            } else if ("folders".equals(type.getValue()) && "Folder".equals(object.findStringProperty("ObjectTypeId", null))) {
                ok = true;
            } else if ("documents".equals(type.getValue()) && !"Folder".equals(object.findStringProperty("ObjectTypeId", null))) {
                ok = true;
            }
            if (ok && filters != null && !filters.contains(objectType = object.findStringProperty("ObjectTypeId", null))) {
                ok = false;
            }
            if (ok && skipCount > 0 && skipped < skipCount) {
                ok = false;
                ++skipped;
            }
            if (ok && maxItems > 0 && objects.size() >= maxItems) break;
            if (ok) {
                objects.add(object);
            }
            if (depth <= 0 || level >= depth || !"Folder".equals(object.findStringProperty("ObjectTypeId", null))) continue;
            this.addChildren(objects, (Element)element, type, filters, maxItems, skipCount, depth, level + 1);
        }
    }

    @Override
    public List<CmisObject> getChildren(String repositoryId, String folderId, TypesOfFileableObjects type, String filter, boolean includeAllowableActions, boolean includeRelationships, int maxItems, int skipCount) throws InvalidArgumentException, ConstraintViolationException, FilterNotValidException, RuntimeException, UpdateConflictException, ObjectNotFoundException, OperationNotSupportedException, PermissionDeniedException, FolderNotValidException {
        Collection filters = null;
        if (!StringUtil.isEmpty(filter)) {
            filters = this.getFilterCollection(filter);
        }
        if (!repositoryId.equals("PLATFORMORIG")) {
            throw new InvalidArgumentException();
        }
        ArrayList<CmisObject> objects = new ArrayList<CmisObject>();
        Element objectElement = this.getFolderElement(folderId);
        this.addChildren(objects, objectElement, type, filters, maxItems, skipCount, 1, 1);
        return objects;
    }

    private Collection getFilterCollection(String filterstr) {
        StringTokenizer tokenizer = new StringTokenizer(filterstr, ",");
        HashSet<String> set = new HashSet<String>();
        int tokenCount = tokenizer.countTokens();
        for (int idx = 0; idx < tokenCount; ++idx) {
            set.add(tokenizer.nextToken());
        }
        return set;
    }

    @Override
    public GetCheckedoutDocsResponse getCheckedoutDocs(String repositoryId, String folderId, String filter, boolean includeAllowableActions, boolean includeRelationships, int maxItems, int skipCount) throws InvalidArgumentException, ConstraintViolationException, FilterNotValidException, RuntimeException, UpdateConflictException, ObjectNotFoundException, OperationNotSupportedException, PermissionDeniedException, FolderNotValidException {
        throw new OperationNotSupportedException();
    }

    @Override
    public String getRepositoryPath(CmisObject object) {
        String id = object.findIdProperty("ObjectId", null);
        String typeId = object.findStringProperty("ObjectTypeId", null);
        if ("Folder".equals(typeId)) {
            return id;
        }
        int idx = id.lastIndexOf("/");
        if (idx != -1) {
            return id.substring(0, idx);
        }
        return "";
    }

    @Override
    public String getRepositoryFilename(CmisObject object) {
        String typeId = object.findStringProperty("ObjectTypeId", null);
        if ("Folder".equals(typeId)) {
            return "";
        }
        String name = object.findStringProperty("Name", null);
        return name;
    }
}

