/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.diminput;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.diminput.PaloDimInputData;
import org.pentaho.di.trans.steps.palo.diminput.PaloDimInputMeta;

public class PaloDimInput
extends BaseStep
implements StepInterface {
    private PaloDimInputMeta meta;
    private PaloDimInputData data;
    private ListenerWithException listener;

    public PaloDimInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.logBasic("Getting Dimension Row Meta.");
        final RowMetaInterface rowMeta = this.data.helper.getDimensionRowMeta(this.meta.getDimension(), this.meta.getLevels(), this.meta.getBaseElementsOnly());
        this.logBasic("Getting Dimension Rows.");
        this.listener = new ListenerWithException(){

            public void resume() {
            }

            public void stop() {
            }

            public void cancel() {
            }

            public boolean getStop() {
                return false;
            }

            public void prepareElements(int numElements) {
            }

            public boolean getCancel() {
                return false;
            }

            public void oneMoreElement(Object element) {
                Object[] row = (Object[])element;
                try {
                    assert (rowMeta.size() != row.length);
                    PaloDimInput.this.incrementLinesInput();
                    PaloDimInput.this.putRow(rowMeta, row);
                }
                catch (Exception ex) {
                    this.throwedException = ex;
                    this.cancel();
                }
            }
        };
        this.data.helper.getDimensionRows(this.meta.getDimension(), rowMeta, this.meta.getBaseElementsOnly(), (PaloHelper.Listener)this.listener);
        if (this.listener.throwedException != null) {
            throw new KettleException("Failed to fetch some row", (Throwable)this.listener.throwedException);
        }
        this.logBasic("Process Ended.");
        this.setOutputDone();
        return false;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (PaloDimInputMeta)smi;
        this.data = (PaloDimInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.logDebug("Meta Levels: " + this.meta.getLevels().size());
                this.data.helper = new PaloHelper(this.meta.getDatabaseMeta(), this.getLogLevel());
                this.data.helper.connect();
                return true;
            }
            catch (Exception e) {
                this.logError("An error occurred, processing will be stopped: " + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.helper.disconnect();
        super.dispose(smi, sdi);
    }

    private abstract class ListenerWithException
    implements PaloHelper.Listener {
        protected Exception throwedException = null;

        private ListenerWithException() {
        }
    }
}

