/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.wadl;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ClassDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.MethodDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ResourceDocType;
import com.sun.jersey.wadl.resourcedoc.DocProcessorWrapper;
import com.sun.jersey.wadl.resourcedoc.ResourceDoclet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;

public class PentahoResourceDoclet
extends ResourceDoclet {
    private static final String OUTPUT_FILE_NAME = "wadlExtension.xml";
    private static final String OUTPUT_PATH_PARAM = "-output";
    private static final String SUPPORTED_TAG = "<supported>{0}</supported>";
    private static final String DEPRECATED_TAG = "<deprecated>{0}</deprecated>";
    private static final String DOCUMENTATION_TAG = "<documentation>{0}</documentation>";
    private static final String PATH_ANNOTATION = "@javax.ws.rs.Path";
    private static final String DEPRECATED_ANNOTATION = "@java.lang.Deprecated";
    private static final String FACET_ANNOTATION = "@org.codehaus.enunciate.Facet";
    private static final String UNSUPPORTED = "Unsupported";

    private static boolean isDeprecated(AnnotationDesc[] annotationDescs) {
        for (AnnotationDesc annotationDesc : annotationDescs) {
            if (!annotationDesc.toString().equals(DEPRECATED_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupported(AnnotationDesc[] annotationDescs) {
        for (AnnotationDesc annotationDesc : annotationDescs) {
            if (!annotationDesc.toString().contains(FACET_ANNOTATION) || !annotationDesc.elementValues()[0].value().value().equals(UNSUPPORTED)) continue;
            return false;
        }
        return true;
    }

    private static String generateComment(MethodDoc methodDoc) {
        String documentation = methodDoc.getRawCommentText();
        StringBuilder comment = new StringBuilder();
        comment.append(MessageFormat.format(SUPPORTED_TAG, PentahoResourceDoclet.isSupported(methodDoc.annotations()))).append(MessageFormat.format(DEPRECATED_TAG, PentahoResourceDoclet.isDeprecated(methodDoc.annotations()))).append(MessageFormat.format(DOCUMENTATION_TAG, documentation));
        return comment.toString();
    }

    public static boolean start(RootDoc root) {
        ClassDoc[] classes;
        String outputPath = PentahoResourceDoclet.getOutputPath(root.options());
        DocProcessorWrapper docProcessor = new DocProcessorWrapper();
        ResourceDocType result = new ResourceDocType();
        for (ClassDoc classDoc : classes = root.classes()) {
            ClassDocType classDocType = new ClassDocType();
            AnnotationDesc[] annotationDescs = classDoc.annotations();
            boolean toBeProcessed = false;
            if (annotationDescs != null) {
                for (AnnotationDesc annotationDesc : annotationDescs) {
                    if (!annotationDesc.toString().contains(PATH_ANNOTATION)) continue;
                    toBeProcessed = true;
                }
                if (!toBeProcessed) continue;
                classDocType.setClassName(classDoc.qualifiedTypeName());
                classDocType.setCommentText(classDoc.commentText());
                docProcessor.processClassDoc(classDoc, classDocType);
                for (AnnotationDesc annotationDesc : classDoc.methods()) {
                    MethodDocType methodDocType = new MethodDocType();
                    annotationDescs = annotationDesc.annotations();
                    toBeProcessed = false;
                    if (annotationDescs == null) continue;
                    for (AnnotationDesc annotation : annotationDescs) {
                        if (!annotation.toString().contains(PATH_ANNOTATION)) continue;
                        toBeProcessed = true;
                    }
                    if (!toBeProcessed) continue;
                    methodDocType.setMethodName(annotationDesc.name());
                    methodDocType.setCommentText(PentahoResourceDoclet.generateComment((MethodDoc)annotationDesc));
                    docProcessor.processMethodDoc((MethodDoc)annotationDesc, methodDocType);
                    classDocType.getMethodDocs().add(methodDocType);
                }
            }
            result.getDocs().add(classDocType);
        }
        try {
            Class[] clazzes = new Class[]{result.getClass()};
            JAXBContext c = JAXBContext.newInstance((Class[])clazzes);
            Marshaller m = c.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputPath));
            XMLSerializer serializer = PentahoResourceDoclet.getXMLSerializer(out);
            m.marshal((Object)result, (ContentHandler)serializer);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static XMLSerializer getXMLSerializer(OutputStream os) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"ns1^commentText", "ns2^commentText", "^commentText"});
        XMLSerializer serializer = new XMLSerializer(of);
        serializer.setOutputByteStream(os);
        return serializer;
    }

    private static String getOutputPath(String[][] optionsMap) {
        if (optionsMap != null) {
            for (int i = 0; i < optionsMap.length; ++i) {
                String[] option = optionsMap[i];
                if (!option[0].equals(OUTPUT_PATH_PARAM)) continue;
                return option[1];
            }
        }
        return OUTPUT_FILE_NAME;
    }
}

