/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultimap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.RegionStateListener;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.TableStateManager;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.RegionMergeCoordination;
import org.apache.hadoop.hbase.coordination.SplitTransactionCoordination;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkRegionMergeCoordination;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.ipc.FailedServerException;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.master.AssignCallable;
import org.apache.hadoop.hbase.master.AssignmentListener;
import org.apache.hadoop.hbase.master.GeneralBulkAssigner;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStateStore;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.master.UnAssignCallable;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeAssignmentHelper;
import org.apache.hadoop.hbase.master.balancer.FavoredNodeLoadBalancer;
import org.apache.hadoop.hbase.master.handler.ClosedRegionHandler;
import org.apache.hadoop.hbase.master.handler.DisableTableHandler;
import org.apache.hadoop.hbase.master.handler.EnableTableHandler;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.RegionServerAbortedException;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class AssignmentManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(AssignmentManager.class);
    public static final ServerName HBCK_CODE_SERVERNAME = ServerName.valueOf((String)"HBCKServerName", (int)0, (long)-1L);
    static final String ALREADY_IN_TRANSITION_WAITTIME = "hbase.assignment.already.intransition.waittime";
    static final int DEFAULT_ALREADY_IN_TRANSITION_WAITTIME = 60000;
    protected final MasterServices server;
    private ServerManager serverManager;
    private boolean shouldAssignRegionsWithFavoredNodes;
    private LoadBalancer balancer;
    private final MetricsAssignmentManager metricsAssignmentManager;
    private final TableLockManager tableLockManager;
    private AtomicInteger numRegionsOpened = new AtomicInteger(0);
    private final KeyLocker<String> locker = new KeyLocker();
    Set<HRegionInfo> replicasToClose = Collections.synchronizedSet(new HashSet());
    private final Map<String, HRegionInfo> regionsToReopen;
    private final int maximumAttempts;
    private final Map<String, PairOfSameType<HRegionInfo>> mergingRegions = new HashMap<String, PairOfSameType<HRegionInfo>>();
    private final Map<HRegionInfo, PairOfSameType<HRegionInfo>> splitRegions = new HashMap<HRegionInfo, PairOfSameType<HRegionInfo>>();
    private final long sleepTimeBeforeRetryingMetaAssignment;
    final NavigableMap<String, RegionPlan> regionPlans = new TreeMap<String, RegionPlan>();
    private final TableStateManager tableStateManager;
    private final org.apache.hadoop.hbase.executor.ExecutorService executorService;
    private Map<HRegionInfo, AtomicBoolean> closedRegionHandlerCalled = null;
    private Map<HRegionInfo, AtomicBoolean> openedRegionHandlerCalled = null;
    private ExecutorService threadPoolExecutorService;
    private final ExecutorService zkEventWorkers;
    private List<EventType> ignoreStatesRSOffline = Arrays.asList(EventType.RS_ZK_REGION_FAILED_OPEN, EventType.RS_ZK_REGION_CLOSED);
    private final RegionStates regionStates;
    private final int bulkAssignThresholdRegions;
    private final int bulkAssignThresholdServers;
    private final int bulkPerRegionOpenTimeGuesstimate;
    private final boolean bulkAssignWaitTillAllAssigned;
    protected final AtomicBoolean failoverCleanupDone = new AtomicBoolean(false);
    private final ConcurrentHashMap<String, AtomicInteger> failedOpenTracker = new ConcurrentHashMap();
    private final boolean useZKForAssignment;
    private final RegionStateStore regionStateStore;
    @SuppressWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean TEST_SKIP_SPLIT_HANDLING = false;
    private List<AssignmentListener> listeners = new CopyOnWriteArrayList<AssignmentListener>();
    private RegionStateListener regionStateListener;
    private final Set<String> regionsInProgress = new HashSet<String>();
    private final LinkedHashMultimap<String, RegionRunnable> zkEventWorkerWaitingList = LinkedHashMultimap.create();

    public AssignmentManager(MasterServices server, ServerManager serverManager, LoadBalancer balancer, org.apache.hadoop.hbase.executor.ExecutorService service, MetricsMaster metricsMaster, TableLockManager tableLockManager) throws KeeperException, IOException, CoordinatedStateException {
        super(server.getZooKeeper());
        this.server = server;
        this.serverManager = serverManager;
        this.executorService = service;
        this.regionStateStore = new RegionStateStore(server);
        this.regionsToReopen = Collections.synchronizedMap(new HashMap());
        Configuration conf = server.getConfiguration();
        this.shouldAssignRegionsWithFavoredNodes = conf.getClass("hbase.master.loadbalancer.class", Object.class).equals(FavoredNodeLoadBalancer.class);
        try {
            this.tableStateManager = server.getCoordinatedStateManager() != null ? server.getCoordinatedStateManager().getTableStateManager() : null;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        this.maximumAttempts = Math.max(1, this.server.getConfiguration().getInt("hbase.assignment.maximum.attempts", 10));
        this.sleepTimeBeforeRetryingMetaAssignment = this.server.getConfiguration().getLong("hbase.meta.assignment.retry.sleeptime", 1000L);
        this.balancer = balancer;
        int maxThreads = conf.getInt("hbase.assignment.threads.max", 30);
        this.threadPoolExecutorService = Threads.getBoundedCachedThreadPool((int)maxThreads, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)Threads.newDaemonThreadFactory((String)"AM."));
        this.regionStates = new RegionStates(server, this.tableStateManager, serverManager, this.regionStateStore);
        this.bulkAssignWaitTillAllAssigned = conf.getBoolean("hbase.bulk.assignment.waittillallassigned", false);
        this.bulkAssignThresholdRegions = conf.getInt("hbase.bulk.assignment.threshold.regions", 7);
        this.bulkAssignThresholdServers = conf.getInt("hbase.bulk.assignment.threshold.servers", 3);
        this.bulkPerRegionOpenTimeGuesstimate = conf.getInt("hbase.bulk.assignment.perregion.open.time", 10000);
        int workers = conf.getInt("hbase.assignment.zkevent.workers", 20);
        ThreadFactory threadFactory = Threads.newDaemonThreadFactory((String)"AM.ZK.Worker");
        this.zkEventWorkers = Threads.getBoundedCachedThreadPool((int)workers, (long)60L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)threadFactory);
        this.tableLockManager = tableLockManager;
        this.metricsAssignmentManager = new MetricsAssignmentManager();
        this.useZKForAssignment = ConfigUtil.useZKForAssignment(conf);
    }

    MetricsAssignmentManager getAssignmentManagerMetrics() {
        return this.metricsAssignmentManager;
    }

    public void registerListener(AssignmentListener listener) {
        this.listeners.add(listener);
    }

    public boolean unregisterListener(AssignmentListener listener) {
        return this.listeners.remove(listener);
    }

    public TableStateManager getTableStateManager() {
        return this.tableStateManager;
    }

    public RegionStates getRegionStates() {
        return this.regionStates;
    }

    @VisibleForTesting
    RegionStateStore getRegionStateStore() {
        return this.regionStateStore;
    }

    public RegionPlan getRegionReopenPlan(HRegionInfo hri) {
        return new RegionPlan(hri, null, this.regionStates.getRegionServerOfRegion(hri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlan(String encodedName, RegionPlan plan) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.put(encodedName, plan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlans(Map<String, RegionPlan> plans) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.putAll(plans);
        }
    }

    public void setRegionsToReopen(List<HRegionInfo> regions) {
        for (HRegionInfo hri : regions) {
            this.regionsToReopen.put(hri.getEncodedName(), hri);
        }
    }

    public Pair<Integer, Integer> getReopenStatus(TableName tableName) throws IOException {
        List hris = TableName.META_TABLE_NAME.equals((Object)tableName) ? new MetaTableLocator().getMetaRegions(this.server.getZooKeeper()) : MetaTableAccessor.getTableRegions((ZooKeeperWatcher)this.server.getZooKeeper(), (Connection)this.server.getConnection(), (TableName)tableName, (boolean)true);
        Integer pending = 0;
        for (HRegionInfo hri : hris) {
            String name = hri.getEncodedName();
            if (!this.regionsToReopen.containsKey(name) && !this.regionStates.isRegionInTransition(name)) continue;
            Integer n = pending;
            Integer n2 = pending = Integer.valueOf(pending + 1);
        }
        return new Pair((Object)pending, (Object)hris.size());
    }

    public boolean isFailoverCleanupDone() {
        return this.failoverCleanupDone.get();
    }

    public Lock acquireRegionLock(String encodedName) {
        return this.locker.acquireLock((Object)encodedName);
    }

    void failoverCleanupDone() {
        this.failoverCleanupDone.set(true);
        this.serverManager.processQueuedDeadServers();
    }

    void joinCluster() throws IOException, KeeperException, InterruptedException, CoordinatedStateException {
        long startTime = System.currentTimeMillis();
        Set<ServerName> deadServers = this.rebuildUserRegions();
        boolean failover = this.processDeadServersAndRegionsInTransition(deadServers);
        if (!this.useZKForAssignment) {
            ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
        }
        this.recoverTableInDisablingState();
        this.recoverTableInEnablingState();
        LOG.info((Object)("Joined the cluster in " + (System.currentTimeMillis() - startTime) + "ms, failover=" + failover));
    }

    boolean processDeadServersAndRegionsInTransition(Set<ServerName> deadServers) throws KeeperException, IOException, InterruptedException, CoordinatedStateException {
        Set<ServerName> queuedDeadServers;
        Map<String, RegionState> regionsInTransition;
        boolean failover;
        block15: {
            List nodes;
            block14: {
                nodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
                if (this.useZKForAssignment && nodes == null) {
                    String errorMessage = "Failed to get the children from ZK";
                    this.server.abort(errorMessage, new IOException(errorMessage));
                    return true;
                }
                boolean bl = failover = !this.serverManager.getDeadServers().isEmpty();
                if (!failover) break block14;
                if (!LOG.isDebugEnabled()) break block15;
                LOG.debug((Object)("Found dead servers out on cluster " + this.serverManager.getDeadServers()));
                break block15;
            }
            Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
            for (Map.Entry<HRegionInfo, ServerName> en : this.regionStates.getRegionAssignments().entrySet()) {
                HRegionInfo hri = en.getKey();
                if (hri.isMetaTable() || !onlineServers.contains(en.getValue())) continue;
                LOG.debug((Object)("Found " + hri + " out on cluster"));
                failover = true;
                break;
            }
            if (!failover && nodes != null) {
                for (String encodedName : nodes) {
                    RegionState regionState = this.regionStates.getRegionState(encodedName);
                    if (regionState == null || regionState.getRegion().isMetaRegion()) continue;
                    LOG.debug((Object)("Found " + regionState + " in RITs"));
                    failover = true;
                    break;
                }
            }
        }
        if (!(failover || this.useZKForAssignment || (regionsInTransition = this.regionStates.getRegionsInTransition()).isEmpty())) {
            Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
            for (RegionState regionState : regionsInTransition.values()) {
                ServerName serverName = regionState.getServerName();
                if (regionState.getRegion().isMetaRegion() || serverName == null || !onlineServers.contains(serverName)) continue;
                LOG.debug((Object)("Found " + regionState + " in RITs"));
                failover = true;
                break;
            }
        }
        if (!failover && !(queuedDeadServers = this.serverManager.getRequeuedDeadServers().keySet()).isEmpty()) {
            Configuration conf = this.server.getConfiguration();
            Path walRootDir = FSUtils.getWALRootDir(conf);
            FileSystem walFs = FSUtils.getWALFileSystem(conf);
            for (ServerName serverName : queuedDeadServers) {
                Path walDir = new Path(walRootDir, DefaultWALProvider.getWALDirectoryName(serverName.toString()));
                Path splitDir = walDir.suffix("-splitting");
                if (!walFs.exists(walDir) && !walFs.exists(splitDir)) continue;
                LOG.debug((Object)("Found queued dead server " + serverName));
                failover = true;
                break;
            }
            if (!failover) {
                LOG.info((Object)("AM figured that it's not a failover and cleaned up " + queuedDeadServers.size() + " queued dead servers"));
                this.serverManager.removeRequeuedDeadServers();
            }
        }
        Set<TableName> disabledOrDisablingOrEnabling = null;
        Map<HRegionInfo, ServerName> allRegions = null;
        if (!failover) {
            disabledOrDisablingOrEnabling = this.tableStateManager.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING, ZooKeeperProtos.Table.State.ENABLING);
            allRegions = this.regionStates.closeAllUserRegions(disabledOrDisablingOrEnabling);
        }
        this.regionStateStore.start();
        if (failover) {
            LOG.info((Object)"Found regions out on cluster or in RIT; presuming failover");
            this.processDeadServersAndRecoverLostRegions(deadServers);
        }
        if (!failover && this.useZKForAssignment) {
            ZKAssign.deleteAllNodes((ZooKeeperWatcher)this.watcher);
            ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
        }
        this.failoverCleanupDone();
        if (!failover) {
            LOG.info((Object)"Clean cluster startup. Assigning user regions");
            this.assignAllUserRegions(allRegions);
        }
        for (HRegionInfo h : this.replicasToClose) {
            this.unassign(h);
        }
        this.replicasToClose.clear();
        return failover;
    }

    boolean processRegionInTransitionAndBlockUntilAssigned(HRegionInfo hri) throws InterruptedException, KeeperException, IOException {
        RegionState state;
        String encodedRegionName = hri.getEncodedName();
        if (!this.processRegionInTransition(encodedRegionName, hri)) {
            return false;
        }
        LOG.debug((Object)("Waiting on " + HRegionInfo.prettyPrint((String)encodedRegionName)));
        while (!this.server.isStopped() && this.regionStates.isRegionInTransition(encodedRegionName) && (state = this.regionStates.getRegionTransitionState(encodedRegionName)) != null && this.serverManager.isServerOnline(state.getServerName())) {
            this.regionStates.waitForUpdate(100L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRegionInTransition(String encodedRegionName, HRegionInfo regionInfo) throws KeeperException, IOException {
        ReentrantLock lock = this.locker.acquireLock((Object)encodedRegionName);
        try {
            RegionTransition rt;
            Stat stat = new Stat();
            byte[] data = ZKAssign.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)encodedRegionName, (Stat)stat);
            if (data == null) {
                boolean bl = false;
                return bl;
            }
            try {
                rt = RegionTransition.parseFrom((byte[])data);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)"Failed parse znode data", (Throwable)e);
                boolean bl = false;
                lock.unlock();
                return bl;
            }
            HRegionInfo hri = regionInfo;
            if (hri == null) {
                hri = this.regionStates.getRegionInfo(rt.getRegionName());
                EventType et = rt.getEventType();
                if (hri == null && et != EventType.RS_ZK_REGION_MERGING && et != EventType.RS_ZK_REQUEST_REGION_MERGE) {
                    LOG.warn((Object)("Couldn't find the region in recovering " + rt));
                    boolean bl = false;
                    return bl;
                }
            }
            BaseCoordinatedStateManager cp = (BaseCoordinatedStateManager)this.server.getCoordinatedStateManager();
            OpenRegionCoordination openRegionCoordination = cp.getOpenRegionCoordination();
            ZkOpenRegionCoordination.ZkOpenRegionDetails zkOrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
            zkOrd.setVersion(stat.getVersion());
            zkOrd.setServerName(cp.getServer().getServerName());
            boolean bl = this.processRegionsInTransition(rt, hri, openRegionCoordination, zkOrd);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    boolean processRegionsInTransition(RegionTransition rt, final HRegionInfo regionInfo, OpenRegionCoordination coordination, final OpenRegionCoordination.OpenRegionDetails ord) throws KeeperException {
        EventType et = rt.getEventType();
        final ServerName sn = rt.getServerName();
        byte[] regionName = rt.getRegionName();
        final String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        String prettyPrintedRegionName = HRegionInfo.prettyPrint((String)encodedName);
        LOG.info((Object)("Processing " + prettyPrintedRegionName + " in state: " + et));
        if (this.regionStates.isRegionInTransition(encodedName) && (regionInfo.isMetaRegion() || !this.useZKForAssignment)) {
            LOG.info((Object)("Processed region " + prettyPrintedRegionName + " in state: " + et + ", does nothing since the region is already in transition " + this.regionStates.getRegionTransitionState(encodedName)));
            return true;
        }
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.debug((Object)("RIT " + encodedName + " in state=" + rt.getEventType() + " was on deadserver; forcing offline"));
            if (this.regionStates.isRegionOnline(regionInfo)) {
                this.regionStates.regionOffline(regionInfo);
                this.sendRegionClosedNotification(regionInfo);
            }
            this.regionStates.updateRegionState(regionInfo, RegionState.State.OFFLINE, sn);
            if (regionInfo.isMetaRegion()) {
                MetaTableLocator.setMetaLocation((ZooKeeperWatcher)this.watcher, (ServerName)sn, (RegionState.State)RegionState.State.OPEN);
            } else {
                this.regionStates.setLastRegionServerOfRegion(sn, encodedName);
                if (!this.serverManager.isServerDead(sn)) {
                    this.serverManager.expireServer(sn);
                }
            }
            return false;
        }
        switch (et) {
            case M_ZK_REGION_CLOSING: {
                final RegionState rsClosing = this.regionStates.updateRegionState(rt, RegionState.State.CLOSING);
                this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process() throws IOException {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Object)regionInfo.getEncodedName());
                        try {
                            int expectedVersion = ((ZkOpenRegionCoordination.ZkOpenRegionDetails)ord).getVersion();
                            AssignmentManager.this.unassign(regionInfo, rsClosing, expectedVersion, null, AssignmentManager.this.useZKForAssignment, null);
                            if (AssignmentManager.this.regionStates.isRegionOffline(regionInfo)) {
                                AssignmentManager.this.assign(regionInfo, true);
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                break;
            }
            case RS_ZK_REGION_CLOSED: 
            case RS_ZK_REGION_FAILED_OPEN: {
                this.regionStates.setRegionStateTOCLOSED(regionInfo, sn);
                if (!this.replicasToClose.contains(regionInfo)) {
                    this.invokeAssign(regionInfo);
                    break;
                }
                this.offlineDisabledRegion(regionInfo);
                break;
            }
            case M_ZK_REGION_OFFLINE: {
                this.regionStates.updateRegionState(rt, RegionState.State.PENDING_OPEN);
                final RegionState rsOffline = this.regionStates.getRegionState(regionInfo);
                this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void process() throws IOException {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Object)regionInfo.getEncodedName());
                        try {
                            RegionPlan plan = new RegionPlan(regionInfo, null, sn);
                            AssignmentManager.this.addPlan(encodedName, plan);
                            AssignmentManager.this.assign(rsOffline, false, false);
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                });
                break;
            }
            case RS_ZK_REGION_OPENING: {
                this.regionStates.updateRegionState(rt, RegionState.State.OPENING);
                break;
            }
            case RS_ZK_REGION_OPENED: {
                this.regionStates.updateRegionState(rt, RegionState.State.OPEN);
                new OpenedRegionHandler(this.server, this, regionInfo, coordination, ord).process();
                break;
            }
            case RS_ZK_REQUEST_REGION_SPLIT: 
            case RS_ZK_REGION_SPLITTING: 
            case RS_ZK_REGION_SPLIT: {
                this.regionStates.regionOnline(regionInfo, sn);
                this.regionStates.updateRegionState(rt, RegionState.State.SPLITTING);
                if (this.handleRegionSplitting(rt, encodedName, prettyPrintedRegionName, sn)) break;
                this.deleteSplittingNode(encodedName, sn);
                break;
            }
            case RS_ZK_REQUEST_REGION_MERGE: 
            case RS_ZK_REGION_MERGING: 
            case RS_ZK_REGION_MERGED: {
                if (this.handleRegionMerging(rt, encodedName, prettyPrintedRegionName, sn)) break;
                this.deleteMergingNode(encodedName, sn);
                break;
            }
            default: {
                throw new IllegalStateException("Received region in state:" + et + " is not valid.");
            }
        }
        LOG.info((Object)("Processed region " + prettyPrintedRegionName + " in state " + et + ", on " + (this.serverManager.isServerOnline(sn) ? "" : "dead ") + "server: " + sn));
        return true;
    }

    public void removeClosedRegion(HRegionInfo hri) {
        if (this.regionsToReopen.remove(hri.getEncodedName()) != null) {
            LOG.debug((Object)"Removed region from reopening regions because it was closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Needs work; says access to ConcurrentHashMaps not ATOMIC!!!")
    void handleRegion(RegionTransition rt, OpenRegionCoordination coordination, OpenRegionCoordination.OpenRegionDetails ord) {
        if (rt == null) {
            LOG.warn((Object)"Unexpected NULL input for RegionTransition rt");
            return;
        }
        ServerName sn = rt.getServerName();
        if (sn.equals((Object)HBCK_CODE_SERVERNAME)) {
            this.handleHBCK(rt);
            return;
        }
        long createTime = rt.getCreateTime();
        byte[] regionName = rt.getRegionName();
        String encodedName = HRegionInfo.encodeRegionName((byte[])regionName);
        String prettyPrintedRegionName = HRegionInfo.prettyPrint((String)encodedName);
        if (!this.serverManager.isServerOnline(sn) && !this.ignoreStatesRSOffline.contains(rt.getEventType())) {
            LOG.warn((Object)("Attempted to handle region transition for server but it is not online: " + prettyPrintedRegionName + ", " + rt));
            return;
        }
        RegionState regionState = this.regionStates.getRegionState(encodedName);
        long startTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            boolean lateEvent = createTime < startTime - 15000L;
            LOG.debug((Object)("Handling " + rt.getEventType() + ", server=" + sn + ", region=" + (prettyPrintedRegionName == null ? "null" : prettyPrintedRegionName) + (lateEvent ? ", which is more than 15 seconds late" : "") + ", current_state=" + regionState));
        }
        if (rt.getEventType() == EventType.M_ZK_REGION_OFFLINE) {
            return;
        }
        ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
        try {
            long waitedTime;
            RegionState latestState = this.regionStates.getRegionState(encodedName);
            if (regionState == null && latestState != null || regionState != null && latestState == null || regionState != null && latestState != null && latestState.getState() != regionState.getState()) {
                LOG.warn((Object)("Region state changed from " + regionState + " to " + latestState + ", while acquiring lock"));
            }
            if ((waitedTime = System.currentTimeMillis() - startTime) > 5000L) {
                LOG.warn((Object)("Took " + waitedTime + "ms to acquire the lock"));
            }
            regionState = latestState;
            switch (rt.getEventType()) {
                case RS_ZK_REQUEST_REGION_SPLIT: 
                case RS_ZK_REGION_SPLITTING: 
                case RS_ZK_REGION_SPLIT: {
                    if (this.handleRegionSplitting(rt, encodedName, prettyPrintedRegionName, sn)) return;
                    this.deleteSplittingNode(encodedName, sn);
                    return;
                }
                case RS_ZK_REQUEST_REGION_MERGE: 
                case RS_ZK_REGION_MERGING: 
                case RS_ZK_REGION_MERGED: {
                    if (this.handleRegionMerging(rt, encodedName, prettyPrintedRegionName, sn)) return;
                    this.deleteMergingNode(encodedName, sn);
                    return;
                }
                case M_ZK_REGION_CLOSING: {
                    if (regionState == null || !regionState.isPendingCloseOrClosingOnServer(sn)) {
                        LOG.warn((Object)("Received CLOSING for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_CLOSE/CLOSING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    this.regionStates.updateRegionState(rt, RegionState.State.CLOSING);
                    return;
                }
                case RS_ZK_REGION_CLOSED: {
                    if (regionState == null || !regionState.isPendingCloseOrClosingOnServer(sn)) {
                        LOG.warn((Object)("Received CLOSED for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_CLOSE/CLOSING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    new ClosedRegionHandler(this.server, this, regionState.getRegion()).process();
                    this.updateClosedRegionHandlerTracker(regionState.getRegion());
                    return;
                }
                case RS_ZK_REGION_FAILED_OPEN: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received FAILED_OPEN for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    AtomicInteger failedOpenCount = this.failedOpenTracker.get(encodedName);
                    if (failedOpenCount == null) {
                        failedOpenCount = new AtomicInteger();
                        this.failedOpenTracker.put(encodedName, failedOpenCount);
                    }
                    if (failedOpenCount.incrementAndGet() >= this.maximumAttempts) {
                        this.regionStates.updateRegionState(rt, RegionState.State.FAILED_OPEN);
                        this.failedOpenTracker.remove(encodedName);
                        return;
                    } else {
                        regionState = this.regionStates.setRegionStateTOCLOSED(rt.getRegionName(), sn);
                        if (regionState == null) return;
                        try {
                            this.getRegionPlan(regionState.getRegion(), sn, true);
                            new ClosedRegionHandler(this.server, this, regionState.getRegion()).process();
                            return;
                        }
                        catch (HBaseIOException e) {
                            LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                            return;
                        }
                    }
                }
                case RS_ZK_REGION_OPENING: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received OPENING for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        return;
                    }
                    this.regionStates.updateRegionState(rt, RegionState.State.OPENING);
                    return;
                }
                case RS_ZK_REGION_OPENED: {
                    if (regionState == null || !regionState.isPendingOpenOrOpeningOnServer(sn)) {
                        LOG.warn((Object)("Received OPENED for " + prettyPrintedRegionName + " from " + sn + " but the region isn't PENDING_OPEN/OPENING here: " + this.regionStates.getRegionState(encodedName)));
                        if (regionState == null) return;
                        if (regionState.isOpened() && regionState.getServerName().equals((Object)sn)) {
                            this.failedOpenTracker.remove(encodedName);
                            new OpenedRegionHandler(this.server, this, regionState.getRegion(), coordination, ord).process();
                            this.updateOpenedRegionHandlerTracker(regionState.getRegion());
                            return;
                        } else {
                            this.unassign(regionState.getRegion(), null, -1, null, false, sn);
                        }
                        return;
                    }
                    if ((regionState = this.regionStates.transitionOpenFromPendingOpenOrOpeningOnServer(rt, regionState, sn)) == null) return;
                    this.failedOpenTracker.remove(encodedName);
                    new OpenedRegionHandler(this.server, this, regionState.getRegion(), coordination, ord).process();
                    this.updateOpenedRegionHandlerTracker(regionState.getRegion());
                    return;
                }
                default: {
                    throw new IllegalStateException("Received event is not valid.");
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    boolean wasClosedHandlerCalled(HRegionInfo hri) {
        AtomicBoolean b = this.closedRegionHandlerCalled.get(hri);
        return b == null ? false : b.compareAndSet(true, false);
    }

    boolean wasOpenedHandlerCalled(HRegionInfo hri) {
        AtomicBoolean b = this.openedRegionHandlerCalled.get(hri);
        return b == null ? false : b.compareAndSet(true, false);
    }

    void initializeHandlerTrackers() {
        this.closedRegionHandlerCalled = new HashMap<HRegionInfo, AtomicBoolean>();
        this.openedRegionHandlerCalled = new HashMap<HRegionInfo, AtomicBoolean>();
    }

    void updateClosedRegionHandlerTracker(HRegionInfo hri) {
        if (this.closedRegionHandlerCalled != null) {
            this.closedRegionHandlerCalled.put(hri, new AtomicBoolean(true));
        }
    }

    void updateOpenedRegionHandlerTracker(HRegionInfo hri) {
        if (this.openedRegionHandlerCalled != null) {
            this.openedRegionHandlerCalled.put(hri, new AtomicBoolean(true));
        }
    }

    void processFavoredNodes(List<HRegionInfo> regions) throws IOException {
        if (!this.shouldAssignRegionsWithFavoredNodes) {
            return;
        }
        HashMap<HRegionInfo, List<ServerName>> regionToFavoredNodes = new HashMap<HRegionInfo, List<ServerName>>();
        for (HRegionInfo region : regions) {
            regionToFavoredNodes.put(region, ((FavoredNodeLoadBalancer)this.balancer).getFavoredNodes(region));
        }
        FavoredNodeAssignmentHelper.updateMetaWithFavoredNodesInfo(regionToFavoredNodes, (Connection)this.server.getConnection());
    }

    private void handleHBCK(RegionTransition rt) {
        String encodedName = HRegionInfo.encodeRegionName((byte[])rt.getRegionName());
        LOG.info((Object)("Handling HBCK triggered transition=" + rt.getEventType() + ", server=" + rt.getServerName() + ", region=" + HRegionInfo.prettyPrint((String)encodedName)));
        RegionState regionState = this.regionStates.getRegionTransitionState(encodedName);
        switch (rt.getEventType()) {
            case M_ZK_REGION_OFFLINE: {
                HRegionInfo regionInfo;
                if (regionState != null) {
                    regionInfo = regionState.getRegion();
                } else {
                    try {
                        byte[] name = rt.getRegionName();
                        Pair p = MetaTableAccessor.getRegion((Connection)this.server.getConnection(), (byte[])name);
                        regionInfo = (HRegionInfo)p.getFirst();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"Exception reading hbase:meta doing HBCK repair operation", (Throwable)e);
                        return;
                    }
                }
                LOG.info((Object)("HBCK repair is triggering assignment of region=" + regionInfo.getRegionNameAsString()));
                this.assign(regionInfo, false);
                break;
            }
            default: {
                LOG.warn((Object)("Received unexpected region state from HBCK: " + rt.toString()));
            }
        }
    }

    public void nodeCreated(String path) {
        this.handleAssignmentEvent(path);
    }

    public void nodeDataChanged(String path) {
        this.handleAssignmentEvent(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zkEventWorkersSubmit(final RegionRunnable regRunnable) {
        Set<String> set = this.regionsInProgress;
        synchronized (set) {
            if (this.regionsInProgress.contains(regRunnable.getRegionName())) {
                LinkedHashMultimap<String, RegionRunnable> linkedHashMultimap = this.zkEventWorkerWaitingList;
                synchronized (linkedHashMultimap) {
                    this.zkEventWorkerWaitingList.put((Object)regRunnable.getRegionName(), (Object)regRunnable);
                }
                return;
            }
            this.regionsInProgress.add(regRunnable.getRegionName());
            this.zkEventWorkers.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        regRunnable.run();
                    }
                    finally {
                        Set set = AssignmentManager.this.regionsInProgress;
                        synchronized (set) {
                            AssignmentManager.this.regionsInProgress.remove(regRunnable.getRegionName());
                            LinkedHashMultimap linkedHashMultimap = AssignmentManager.this.zkEventWorkerWaitingList;
                            synchronized (linkedHashMultimap) {
                                Set waiting = AssignmentManager.this.zkEventWorkerWaitingList.get((Object)regRunnable.getRegionName());
                                if (!waiting.isEmpty()) {
                                    RegionRunnable toSubmit = (RegionRunnable)waiting.iterator().next();
                                    AssignmentManager.this.zkEventWorkerWaitingList.remove((Object)toSubmit.getRegionName(), (Object)toSubmit);
                                    AssignmentManager.this.zkEventWorkersSubmit(toSubmit);
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public void nodeDeleted(String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            final String regionName = ZKAssign.getRegionName((ZooKeeperWatcher)this.watcher, (String)path);
            this.zkEventWorkersSubmit(new RegionRunnable(){

                @Override
                public String getRegionName() {
                    return regionName;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block17: {
                        ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Object)regionName);
                        try {
                            RegionState rs = AssignmentManager.this.regionStates.getRegionTransitionState(regionName);
                            if (!(rs != null || (rs = AssignmentManager.this.regionStates.getRegionState(regionName)) != null && rs.isMergingNew())) {
                                return;
                            }
                            HRegionInfo regionInfo = rs.getRegion();
                            String regionNameStr = regionInfo.getRegionNameAsString();
                            LOG.debug((Object)("Znode " + regionNameStr + " deleted, state: " + rs));
                            boolean disabled = AssignmentManager.this.getTableStateManager().isTableState(regionInfo.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING);
                            ServerName serverName = rs.getServerName();
                            if (!AssignmentManager.this.serverManager.isServerOnline(serverName)) break block17;
                            if (rs.isOnServer(serverName) && (rs.isOpened() || rs.isSplitting())) {
                                RegionStates regionStates = AssignmentManager.this.regionStates;
                                synchronized (regionStates) {
                                    AssignmentManager.this.regionOnline(regionInfo, serverName);
                                    if (rs.isSplitting() && AssignmentManager.this.splitRegions.containsKey(regionInfo)) {
                                        HRegionInfo hri_a = (HRegionInfo)((PairOfSameType)AssignmentManager.this.splitRegions.get(regionInfo)).getFirst();
                                        HRegionInfo hri_b = (HRegionInfo)((PairOfSameType)AssignmentManager.this.splitRegions.get(regionInfo)).getSecond();
                                        if (!AssignmentManager.this.regionStates.isRegionInTransition(hri_a.getEncodedName())) {
                                            LOG.warn((Object)("Split daughter region not in transition " + hri_a));
                                        }
                                        if (!AssignmentManager.this.regionStates.isRegionInTransition(hri_b.getEncodedName())) {
                                            LOG.warn((Object)("Split daughter region not in transition" + hri_b));
                                        }
                                        AssignmentManager.this.regionOffline(hri_a);
                                        AssignmentManager.this.regionOffline(hri_b);
                                        AssignmentManager.this.splitRegions.remove(regionInfo);
                                    }
                                    if (disabled) {
                                        LOG.info((Object)("Opened " + regionNameStr + "but this table is disabled, triggering close of region"));
                                        AssignmentManager.this.unassign(regionInfo);
                                    }
                                    break block17;
                                }
                            }
                            if (!rs.isMergingNew()) break block17;
                            RegionStates regionStates = AssignmentManager.this.regionStates;
                            synchronized (regionStates) {
                                String p = regionInfo.getEncodedName();
                                PairOfSameType regions = (PairOfSameType)AssignmentManager.this.mergingRegions.get(p);
                                if (regions != null) {
                                    this.onlineMergingRegion(disabled, (HRegionInfo)regions.getFirst(), serverName);
                                    this.onlineMergingRegion(disabled, (HRegionInfo)regions.getSecond(), serverName);
                                }
                            }
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }

                private void onlineMergingRegion(boolean disabled, HRegionInfo hri, ServerName serverName) {
                    RegionState regionState = AssignmentManager.this.regionStates.getRegionState(hri);
                    if (regionState != null && regionState.isMerging() && regionState.isOnServer(serverName)) {
                        AssignmentManager.this.regionOnline(regionState.getRegion(), serverName);
                        if (disabled) {
                            AssignmentManager.this.unassign(hri);
                        }
                    }
                }
            });
        }
    }

    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.assignmentZNode)) {
            this.zkEventWorkers.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        List children = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)((AssignmentManager)AssignmentManager.this).watcher.assignmentZNode);
                        if (children != null) {
                            Stat stat = new Stat();
                            for (String child : children) {
                                if (AssignmentManager.this.regionStates.isRegionInTransition(child)) continue;
                                ZKAssign.getDataAndWatch((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)child, (Stat)stat);
                            }
                        }
                    }
                    catch (KeeperException e) {
                        AssignmentManager.this.server.abort("Unexpected ZK exception reading unassigned children", e);
                    }
                }
            });
        }
    }

    void regionOnline(HRegionInfo regionInfo, ServerName sn) {
        this.regionOnline(regionInfo, sn, -1L);
    }

    void regionOnline(HRegionInfo regionInfo, ServerName sn, long openSeqNum) {
        this.numRegionsOpened.incrementAndGet();
        this.regionStates.regionOnline(regionInfo, sn, openSeqNum);
        this.clearRegionPlan(regionInfo);
        this.balancer.regionOnline(regionInfo, sn);
        this.sendRegionOpenedNotification(regionInfo, sn);
    }

    private void handleAssignmentEvent(final String path) {
        if (path.startsWith(this.watcher.assignmentZNode)) {
            final String regionName = ZKAssign.getRegionName((ZooKeeperWatcher)this.watcher, (String)path);
            this.zkEventWorkersSubmit(new RegionRunnable(){

                @Override
                public String getRegionName() {
                    return regionName;
                }

                @Override
                public void run() {
                    try {
                        Stat stat = new Stat();
                        byte[] data = ZKAssign.getDataAndWatch((ZooKeeperWatcher)AssignmentManager.this.watcher, (String)path, (Stat)stat);
                        if (data == null) {
                            return;
                        }
                        RegionTransition rt = RegionTransition.parseFrom((byte[])data);
                        BaseCoordinatedStateManager csm = (BaseCoordinatedStateManager)AssignmentManager.this.server.getCoordinatedStateManager();
                        OpenRegionCoordination openRegionCoordination = csm.getOpenRegionCoordination();
                        ZkOpenRegionCoordination.ZkOpenRegionDetails zkOrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
                        zkOrd.setVersion(stat.getVersion());
                        zkOrd.setServerName(csm.getServer().getServerName());
                        AssignmentManager.this.handleRegion(rt, openRegionCoordination, zkOrd);
                    }
                    catch (KeeperException e) {
                        AssignmentManager.this.server.abort("Unexpected ZK exception reading unassigned node data", e);
                    }
                    catch (DeserializationException e) {
                        AssignmentManager.this.server.abort("Unexpected exception deserializing node data", e);
                    }
                }
            });
        }
    }

    public void regionOffline(HRegionInfo regionInfo) {
        this.regionOffline(regionInfo, null);
    }

    public void offlineDisabledRegion(HRegionInfo regionInfo) {
        if (this.useZKForAssignment) {
            LOG.debug((Object)("Table being disabled so deleting ZK node and removing from regions in transition, skipping assignment of region " + regionInfo.getRegionNameAsString()));
            String encodedName = regionInfo.getEncodedName();
            this.deleteNodeInStates(encodedName, "closed", null, EventType.RS_ZK_REGION_CLOSED, EventType.M_ZK_REGION_OFFLINE);
        }
        this.replicasToClose.remove(regionInfo);
        this.regionOffline(regionInfo);
    }

    public void assign(HRegionInfo region, boolean setOfflineInZK) {
        this.assign(region, setOfflineInZK, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(HRegionInfo region, boolean setOfflineInZK, boolean forceNewPlan) {
        if (this.isDisabledorDisablingRegionInRIT(region)) {
            return;
        }
        String encodedName = region.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
        try {
            RegionState state = this.forceRegionStateToOffline(region, forceNewPlan);
            if (state != null) {
                if (this.regionStates.wasRegionOnDeadServer(encodedName)) {
                    LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", it's host " + this.regionStates.getLastRegionServerOfRegion(encodedName) + " is dead but not processed yet"));
                    return;
                }
                this.assign(state, setOfflineInZK && this.useZKForAssignment, forceNewPlan);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    boolean assign(ServerName destination, List<HRegionInfo> regions) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK], 4[TRYBLOCK]], but top level block is 24[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void unassign(HRegionInfo region, RegionState state, int versionOfClosingNode, ServerName dest, boolean transitionInZK, ServerName src) {
        ServerName server = src;
        if (state != null) {
            server = state.getServerName();
        }
        long maxWaitTime = -1L;
        for (int i = 1; i <= this.maximumAttempts; ++i) {
            if (this.server.isStopped() || this.server.isAborted()) {
                LOG.debug((Object)("Server stopped/aborted; skipping unassign of " + region));
                return;
            }
            if (!this.serverManager.isServerOnline(server)) {
                LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", no need to unassign since it's on a dead server: " + server));
                if (transitionInZK) {
                    this.deleteClosingOrClosedNode(region, server);
                }
                if (state != null) {
                    this.regionOffline(region);
                }
                return;
            }
            try {
                if (this.serverManager.sendRegionClose(server, region, versionOfClosingNode, dest, transitionInZK)) {
                    LOG.debug((Object)("Sent CLOSE to " + server + " for region " + region.getRegionNameAsString()));
                    if (this.useZKForAssignment && !transitionInZK && state != null) {
                        this.unassign(region, state, versionOfClosingNode, dest, transitionInZK, src);
                    }
                    return;
                }
                LOG.warn((Object)("Server " + server + " region CLOSE RPC returned false for " + region.getRegionNameAsString()));
                continue;
            }
            catch (Throwable t2) {
                IOException t2;
                long sleepTime = 0L;
                Configuration conf = this.server.getConfiguration();
                if (t2 instanceof RemoteException) {
                    t2 = ((RemoteException)t2).unwrapRemoteException();
                }
                boolean logRetries = true;
                if (t2 instanceof RegionServerAbortedException || t2 instanceof RegionServerStoppedException || t2 instanceof ServerNotRunningYetException) {
                    sleepTime = 1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
                } else {
                    if (t2 instanceof NotServingRegionException) {
                        LOG.debug((Object)("Offline " + region.getRegionNameAsString() + ", it's not any more on " + server), (Throwable)t2);
                        if (transitionInZK) {
                            this.deleteClosingOrClosedNode(region, server);
                        }
                        if (state != null) {
                            this.regionOffline(region);
                        }
                        return;
                    }
                    if (t2 instanceof FailedServerException || state != null && t2 instanceof RegionAlreadyInTransitionException) {
                        if (t2 instanceof FailedServerException) {
                            sleepTime = 1 + conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
                        } else {
                            long now;
                            LOG.debug((Object)("update " + state + " the timestamp."));
                            state.updateTimestampToNow();
                            if (maxWaitTime < 0L) {
                                maxWaitTime = EnvironmentEdgeManager.currentTime() + conf.getLong(ALREADY_IN_TRANSITION_WAITTIME, 60000L);
                            }
                            if ((now = EnvironmentEdgeManager.currentTime()) < maxWaitTime) {
                                LOG.debug((Object)("Region is already in transition; waiting up to " + (maxWaitTime - now) + "ms"), (Throwable)t2);
                                sleepTime = 100L;
                                --i;
                                logRetries = false;
                            }
                        }
                    }
                }
                try {
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("Failed to unassign " + region.getRegionNameAsString() + " since interrupted"), (Throwable)ie);
                    Thread.currentThread().interrupt();
                    if (state != null) {
                        this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
                    }
                    return;
                }
                if (!logRetries) continue;
                LOG.info((Object)("Server " + server + " returned " + t2 + " for " + region.getRegionNameAsString() + ", try=" + i + " of " + this.maximumAttempts), (Throwable)t2);
            }
        }
        if (state != null) {
            this.regionStates.updateRegionState(region, RegionState.State.FAILED_CLOSE);
        }
    }

    private RegionState forceRegionStateToOffline(HRegionInfo region, boolean forceNewPlan) {
        RegionState state = this.regionStates.getRegionState(region);
        if (state == null) {
            LOG.warn((Object)("Assigning but not in region states: " + region));
            state = this.regionStates.createRegionState(region);
        }
        ServerName sn = state.getServerName();
        if (forceNewPlan && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Force region state offline " + state));
        }
        switch (state.getState()) {
            case OPEN: 
            case OPENING: 
            case PENDING_OPEN: 
            case CLOSING: 
            case PENDING_CLOSE: {
                if (!forceNewPlan) {
                    LOG.debug((Object)("Skip assigning " + region + ", it is already " + state));
                    return null;
                }
            }
            case FAILED_CLOSE: 
            case FAILED_OPEN: {
                this.unassign(region, state, -1, null, false, null);
                state = this.regionStates.getRegionState(region);
                if (state.isFailedClose()) {
                    LOG.info((Object)("Skip assigning " + region + ", we couldn't close it: " + state));
                    return null;
                }
            }
            case OFFLINE: {
                if (this.useZKForAssignment && this.regionStates.isServerDeadAndNotProcessed(sn) && this.wasRegionOnDeadServerByMeta(region, sn)) {
                    if (!this.regionStates.isRegionInTransition(region)) {
                        LOG.info((Object)("Updating the state to " + RegionState.State.OFFLINE + " to allow to be reassigned by SSH"));
                        this.regionStates.updateRegionState(region, RegionState.State.OFFLINE);
                    }
                    LOG.info((Object)("Skip assigning " + region.getRegionNameAsString() + ", it is on a dead but not processed yet server: " + sn));
                    return null;
                }
            }
            case CLOSED: {
                break;
            }
            default: {
                LOG.error((Object)("Trying to assign region " + region + ", which is " + state));
                return null;
            }
        }
        return state;
    }

    protected boolean wasRegionOnDeadServerByMeta(HRegionInfo region, ServerName sn) {
        try {
            if (region.isMetaRegion()) {
                ServerName server = this.server.getMetaTableLocator().getMetaRegionLocation(this.server.getZooKeeper());
                return this.regionStates.isServerDeadAndNotProcessed(server);
            }
            while (!this.server.isStopped()) {
                try {
                    this.server.getMetaTableLocator().waitMetaRegionLocation(this.server.getZooKeeper());
                    Result r = MetaTableAccessor.getRegionResult((Connection)this.server.getConnection(), (byte[])region.getRegionName());
                    if (r == null || r.isEmpty()) {
                        return false;
                    }
                    ServerName server = HRegionInfo.getServerName((Result)r);
                    return this.regionStates.isServerDeadAndNotProcessed(server);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Received exception accessing hbase:meta during force assign " + region.getRegionNameAsString() + ", retrying"), (Throwable)ioe);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info((Object)"Interrupted accessing hbase:meta", (Throwable)e);
        }
        return this.regionStates.isServerDeadAndNotProcessed(sn);
    }

    /*
     * Exception decompiling
     */
    private void assign(RegionState state, boolean setOfflineInZK, boolean forceNewPlan) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processAlreadyOpenedRegion(HRegionInfo region, ServerName sn) {
        LOG.debug((Object)("ALREADY_OPENED " + region.getRegionNameAsString() + " to " + sn));
        String encodedName = region.getEncodedName();
        if (this.useZKForAssignment) {
            String node = ZKAssign.getNodeName((ZooKeeperWatcher)this.watcher, (String)encodedName);
            Stat stat = new Stat();
            try {
                RegionTransition rt;
                EventType et;
                byte[] existingBytes = ZKUtil.getDataNoWatch((ZooKeeperWatcher)this.watcher, (String)node, (Stat)stat);
                if (existingBytes != null && (et = (rt = RegionTransition.parseFrom((byte[])existingBytes)).getEventType()).equals((Object)EventType.RS_ZK_REGION_OPENED)) {
                    LOG.debug((Object)("ALREADY_OPENED " + region.getRegionNameAsString() + " and node in " + et + " state"));
                    return;
                }
            }
            catch (KeeperException ke) {
                LOG.warn((Object)("Unexpected ZK exception getData " + node + " node for the region " + encodedName), (Throwable)ke);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)"Get RegionTransition from zk deserialization failed! ", (Throwable)e);
            }
            this.deleteNodeInStates(encodedName, "offline", sn, EventType.M_ZK_REGION_OFFLINE);
        }
        this.regionStates.regionOnline(region, sn);
    }

    private boolean isDisabledorDisablingRegionInRIT(HRegionInfo region) {
        if (this.tableStateManager.isTableState(region.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING) || this.replicasToClose.contains(region)) {
            LOG.info((Object)("Table " + region.getTable() + " is disabled or disabling;" + " skipping assign of " + region.getRegionNameAsString()));
            this.offlineDisabledRegion(region);
            return true;
        }
        return false;
    }

    private int setOfflineInZooKeeper(RegionState state, ServerName destination) {
        int versionOfOfflineNode;
        if (!state.isClosed() && !state.isOffline()) {
            String msg = "Unexpected state : " + state + " .. Cannot transit it to OFFLINE.";
            this.server.abort(msg, new IllegalStateException(msg));
            return -1;
        }
        this.regionStates.updateRegionState(state.getRegion(), RegionState.State.OFFLINE);
        try {
            versionOfOfflineNode = ZKAssign.createOrForceNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)state.getRegion(), (ServerName)destination);
            if (versionOfOfflineNode == -1) {
                LOG.warn((Object)("Attempted to create/force node into OFFLINE state before completing assignment but failed to do so for " + state));
                return -1;
            }
        }
        catch (KeeperException e) {
            this.server.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            return -1;
        }
        return versionOfOfflineNode;
    }

    private RegionPlan getRegionPlan(HRegionInfo region, boolean forceNewPlan) throws HBaseIOException {
        return this.getRegionPlan(region, null, forceNewPlan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionPlan getRegionPlan(HRegionInfo region, ServerName serverToExclude, boolean forceNewPlan) throws HBaseIOException {
        RegionPlan existingPlan;
        String encodedName = region.getEncodedName();
        List<ServerName> destServers = this.serverManager.createDestinationServersList(serverToExclude);
        if (destServers.isEmpty()) {
            LOG.warn((Object)("Can't move " + encodedName + ", there is no destination server available."));
            return null;
        }
        RegionPlan randomPlan = null;
        boolean newPlan = false;
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            existingPlan = (RegionPlan)this.regionPlans.get(encodedName);
            if (existingPlan != null && existingPlan.getDestination() != null) {
                LOG.debug((Object)("Found an existing plan for " + region.getRegionNameAsString() + " destination server is " + existingPlan.getDestination() + " accepted as a dest server = " + destServers.contains(existingPlan.getDestination())));
            }
            if (forceNewPlan || existingPlan == null || existingPlan.getDestination() == null || !destServers.contains(existingPlan.getDestination())) {
                newPlan = true;
            }
        }
        if (newPlan) {
            ServerName destination = this.balancer.randomAssignment(region, destServers);
            if (destination == null) {
                LOG.warn((Object)("Can't find a destination for " + encodedName));
                return null;
            }
            NavigableMap<String, RegionPlan> navigableMap2 = this.regionPlans;
            synchronized (navigableMap2) {
                randomPlan = new RegionPlan(region, null, destination);
                if (!region.isMetaTable() && this.shouldAssignRegionsWithFavoredNodes) {
                    ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(1);
                    regions.add(region);
                    try {
                        this.processFavoredNodes(regions);
                    }
                    catch (IOException ie) {
                        LOG.warn((Object)("Ignoring exception in processFavoredNodes " + ie));
                    }
                }
                this.regionPlans.put(encodedName, randomPlan);
            }
            LOG.debug((Object)("No previous transition plan found (or ignoring an existing plan) for " + region.getRegionNameAsString() + "; generated random plan=" + randomPlan + "; " + destServers.size() + " (online=" + this.serverManager.getOnlineServers().size() + ") available servers, forceNewPlan=" + forceNewPlan));
            return randomPlan;
        }
        LOG.debug((Object)("Using pre-existing plan for " + region.getRegionNameAsString() + "; plan=" + existingPlan));
        return existingPlan;
    }

    private void waitForRetryingMetaAssignment() {
        try {
            Thread.sleep(this.sleepTimeBeforeRetryingMetaAssignment);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Got exception while waiting for hbase:meta assignment");
            Thread.currentThread().interrupt();
        }
    }

    public void unassign(HRegionInfo region) {
        this.unassign(region, false);
    }

    /*
     * Exception decompiling
     */
    public void unassign(HRegionInfo region, boolean force, ServerName dest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void unassign(HRegionInfo region, boolean force) {
        this.unassign(region, force, null);
    }

    public void deleteClosingOrClosedNode(HRegionInfo region, ServerName sn) {
        String encodedName = region.getEncodedName();
        this.deleteNodeInStates(encodedName, "closing", sn, EventType.M_ZK_REGION_CLOSING, EventType.RS_ZK_REGION_CLOSED);
    }

    private boolean isSplitOrSplittingOrMergedOrMerging(String path) throws KeeperException, DeserializationException {
        boolean result = false;
        byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)path);
        if (data == null) {
            LOG.info((Object)("Node " + path + " is gone"));
            return false;
        }
        RegionTransition rt = RegionTransition.parseFrom((byte[])data);
        switch (rt.getEventType()) {
            case RS_ZK_REQUEST_REGION_SPLIT: 
            case RS_ZK_REGION_SPLITTING: 
            case RS_ZK_REGION_SPLIT: 
            case RS_ZK_REQUEST_REGION_MERGE: 
            case RS_ZK_REGION_MERGING: 
            case RS_ZK_REGION_MERGED: {
                result = true;
                break;
            }
            default: {
                LOG.info((Object)("Node " + path + " is in " + rt.getEventType()));
            }
        }
        return result;
    }

    public int getNumRegionsOpened() {
        return this.numRegionsOpened.get();
    }

    public boolean waitForAssignment(HRegionInfo regionInfo) throws InterruptedException {
        ArrayList<HRegionInfo> regionSet = new ArrayList<HRegionInfo>(1);
        regionSet.add(regionInfo);
        return this.waitForAssignment(regionSet, true, Long.MAX_VALUE);
    }

    protected boolean waitForAssignment(Collection<HRegionInfo> regionSet, boolean waitTillAllAssigned, int reassigningRegions, long minEndTime) throws InterruptedException {
        long deadline = minEndTime + (long)(this.bulkPerRegionOpenTimeGuesstimate * (reassigningRegions + 1));
        return this.waitForAssignment(regionSet, waitTillAllAssigned, deadline);
    }

    protected boolean waitForAssignment(Collection<HRegionInfo> regionSet, boolean waitTillAllAssigned, long deadline) throws InterruptedException {
        while (!regionSet.isEmpty() && !this.server.isStopped() && deadline > System.currentTimeMillis()) {
            int failedOpenCount = 0;
            Iterator<HRegionInfo> regionInfoIterator = regionSet.iterator();
            while (regionInfoIterator.hasNext()) {
                HRegionInfo hri = regionInfoIterator.next();
                if (this.regionStates.isRegionOnline(hri) || this.regionStates.isRegionInState(hri, RegionState.State.SPLITTING, RegionState.State.SPLIT, RegionState.State.MERGING, RegionState.State.MERGED)) {
                    regionInfoIterator.remove();
                    continue;
                }
                if (!this.regionStates.isRegionInState(hri, RegionState.State.FAILED_OPEN)) continue;
                ++failedOpenCount;
            }
            if (!waitTillAllAssigned) break;
            if (regionSet.isEmpty()) continue;
            if (failedOpenCount == regionSet.size()) break;
            this.regionStates.waitForUpdate(100L);
        }
        return regionSet.isEmpty();
    }

    public void assignMeta(HRegionInfo hri) throws KeeperException {
        this.server.getMetaTableLocator().deleteMetaLocation(this.watcher, hri.getReplicaId());
        this.assign(hri, true);
    }

    public void assign(Map<HRegionInfo, ServerName> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.retainAssignment(regions, servers);
        if (bulkPlan == null) {
            throw new IOException("Unable to determine a plan to assign region(s)");
        }
        this.processBogusAssignments(bulkPlan);
        this.assign(regions.size(), servers.size(), "retainAssignment=true", bulkPlan);
    }

    public void assign(List<HRegionInfo> regions) throws IOException, InterruptedException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        List<ServerName> servers = this.serverManager.createDestinationServersList();
        if (servers == null || servers.isEmpty()) {
            throw new IOException("Found no destination server to assign region(s)");
        }
        Map<ServerName, List<HRegionInfo>> bulkPlan = this.balancer.roundRobinAssignment(regions, servers);
        if (bulkPlan == null) {
            throw new IOException("Unable to determine a plan to assign region(s)");
        }
        this.processBogusAssignments(bulkPlan);
        this.processFavoredNodes(regions);
        this.assign(regions.size(), servers.size(), "round-robin=true", bulkPlan);
    }

    private void assign(int regions, int totalServers, String message, Map<ServerName, List<HRegionInfo>> bulkPlan) throws InterruptedException, IOException {
        int servers = bulkPlan.size();
        if (servers == 1 || regions < this.bulkAssignThresholdRegions && servers < this.bulkAssignThresholdServers) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Not using bulk assignment since we are assigning only " + regions + " region(s) to " + servers + " server(s)"));
            }
            ArrayList<HRegionInfo> userRegionSet = new ArrayList<HRegionInfo>(regions);
            for (Map.Entry<ServerName, List<HRegionInfo>> plan : bulkPlan.entrySet()) {
                if (this.assign(plan.getKey(), plan.getValue())) continue;
                for (HRegionInfo region : plan.getValue()) {
                    if (this.regionStates.isRegionOnline(region)) continue;
                    this.invokeAssign(region);
                    if (region.getTable().isSystemTable()) continue;
                    userRegionSet.add(region);
                }
            }
            if (!this.waitForAssignment(userRegionSet, true, userRegionSet.size(), System.currentTimeMillis())) {
                LOG.debug((Object)("some user regions are still in transition: " + userRegionSet));
            }
        } else {
            LOG.info((Object)("Bulk assigning " + regions + " region(s) across " + totalServers + " server(s), " + message));
            GeneralBulkAssigner ba = new GeneralBulkAssigner(this.server, bulkPlan, this, this.bulkAssignWaitTillAllAssigned);
            ba.bulkAssign();
            LOG.info((Object)"Bulk assigning done");
        }
    }

    private void assignAllUserRegions(Map<HRegionInfo, ServerName> allRegions) throws IOException, InterruptedException {
        if (allRegions == null || allRegions.isEmpty()) {
            return;
        }
        boolean retainAssignment = this.server.getConfiguration().getBoolean("hbase.master.startup.retainassign", true);
        Set<HRegionInfo> regionsFromMetaScan = allRegions.keySet();
        if (retainAssignment) {
            this.assign(allRegions);
        } else {
            ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(regionsFromMetaScan);
            this.assign(regions);
        }
        for (HRegionInfo hri : regionsFromMetaScan) {
            TableName tableName = hri.getTable();
            if (this.tableStateManager.isTableState(tableName, ZooKeeperProtos.Table.State.ENABLED)) continue;
            this.setEnabledTable(tableName);
        }
        this.assign(AssignmentManager.replicaRegionsNotRecordedInMeta(regionsFromMetaScan, this.server));
    }

    public static List<HRegionInfo> replicaRegionsNotRecordedInMeta(Set<HRegionInfo> regionsRecordedInMeta, MasterServices master) throws IOException {
        ArrayList<HRegionInfo> regionsNotRecordedInMeta = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regionsRecordedInMeta) {
            TableName table = hri.getTable();
            HTableDescriptor htd = master.getTableDescriptors().get(table);
            int desiredRegionReplication = htd.getRegionReplication();
            for (int i = 0; i < desiredRegionReplication; ++i) {
                HRegionInfo replica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)hri, (int)i);
                if (regionsRecordedInMeta.contains(replica)) continue;
                regionsNotRecordedInMeta.add(replica);
            }
        }
        return regionsNotRecordedInMeta;
    }

    boolean waitUntilNoRegionsInTransition(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        while (!this.server.isStopped() && this.regionStates.isRegionsInTransition() && endTime > System.currentTimeMillis()) {
            this.regionStates.waitForUpdate(100L);
        }
        return !this.regionStates.isRegionsInTransition();
    }

    Set<ServerName> rebuildUserRegions() throws IOException, KeeperException, CoordinatedStateException {
        Set<TableName> disabledOrEnablingTables = this.tableStateManager.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.ENABLING);
        Set<TableName> disabledOrDisablingOrEnabling = this.tableStateManager.getTablesInStates(ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING, ZooKeeperProtos.Table.State.ENABLING);
        List results = MetaTableAccessor.fullScanOfMeta((Connection)this.server.getConnection());
        Set<ServerName> onlineServers = this.serverManager.getOnlineServers().keySet();
        HashSet<ServerName> offlineServers = new HashSet<ServerName>();
        for (Result result : results) {
            HRegionLocation[] locations;
            RegionLocations rl;
            if (result == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)"null result from meta - ignoring but this is strange.");
                continue;
            }
            PairOfSameType p = MetaTableAccessor.getMergeRegions((Result)result);
            if (p.getFirst() != null && p.getSecond() != null) {
                int numReplicas = this.server.getTableDescriptors().get(((HRegionInfo)p.getFirst()).getTable()).getRegionReplication();
                for (HRegionInfo merge : p) {
                    for (int i = 1; i < numReplicas; ++i) {
                        this.replicasToClose.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)merge, (int)i));
                    }
                }
            }
            if ((rl = MetaTableAccessor.getRegionLocations((Result)result)) == null || (locations = rl.getRegionLocations()) == null) continue;
            for (HRegionLocation hrl : locations) {
                HRegionInfo regionInfo;
                if (hrl == null || (regionInfo = hrl.getRegionInfo()) == null) continue;
                int replicaId = regionInfo.getReplicaId();
                RegionState.State state = RegionStateStore.getRegionState(result, replicaId);
                if (replicaId == 0 && state.equals((Object)RegionState.State.SPLIT)) {
                    for (HRegionLocation h : locations) {
                        this.replicasToClose.add(h.getRegionInfo());
                    }
                }
                ServerName lastHost = hrl.getServerName();
                ServerName regionLocation = RegionStateStore.getRegionServer(result, replicaId);
                if (this.tableStateManager.isTableState(regionInfo.getTable(), ZooKeeperProtos.Table.State.DISABLED)) {
                    lastHost = null;
                    regionLocation = null;
                }
                this.regionStates.createRegionState(regionInfo, state, regionLocation, lastHost);
                if (!this.regionStates.isRegionInState(regionInfo, RegionState.State.OPEN)) continue;
                TableName tableName = regionInfo.getTable();
                if (!onlineServers.contains(regionLocation)) {
                    offlineServers.add(regionLocation);
                    if (this.useZKForAssignment) {
                        this.regionStates.regionOffline(regionInfo);
                    }
                } else if (!disabledOrEnablingTables.contains(tableName)) {
                    this.regionStates.regionOnline(regionInfo, regionLocation);
                    this.balancer.regionOnline(regionInfo, regionLocation);
                } else if (this.useZKForAssignment) {
                    this.regionStates.regionOffline(regionInfo);
                }
                if (disabledOrDisablingOrEnabling.contains(tableName) || this.getTableStateManager().isTableState(tableName, ZooKeeperProtos.Table.State.ENABLED)) continue;
                this.setEnabledTable(tableName);
            }
        }
        return offlineServers;
    }

    private void recoverTableInDisablingState() throws KeeperException, IOException, CoordinatedStateException {
        Set<TableName> disablingTables = this.tableStateManager.getTablesInStates(ZooKeeperProtos.Table.State.DISABLING);
        if (disablingTables.size() != 0) {
            for (TableName tableName : disablingTables) {
                LOG.info((Object)("The table " + tableName + " is in DISABLING state.  Hence recovering by moving the table" + " to DISABLED state."));
                new DisableTableHandler(this.server, tableName, this, this.tableLockManager, true).prepare().process();
            }
        }
    }

    private void recoverTableInEnablingState() throws KeeperException, IOException, CoordinatedStateException {
        Set<TableName> enablingTables = this.tableStateManager.getTablesInStates(ZooKeeperProtos.Table.State.ENABLING);
        if (enablingTables.size() != 0) {
            for (TableName tableName : enablingTables) {
                LOG.info((Object)("The table " + tableName + " is in ENABLING state.  Hence recovering by moving the table" + " to ENABLED state."));
                EnableTableHandler eth = new EnableTableHandler(this.server, tableName, this, this.tableLockManager, true);
                try {
                    eth.prepare();
                }
                catch (TableNotFoundException e) {
                    LOG.warn((Object)("Table " + tableName + " not found in hbase:meta to recover."));
                    continue;
                }
                eth.process();
            }
        }
    }

    private void processDeadServersAndRecoverLostRegions(Set<ServerName> deadServers) throws IOException, KeeperException {
        List nodes;
        if (deadServers != null && !deadServers.isEmpty()) {
            for (ServerName serverName : deadServers) {
                if (this.serverManager.isServerDead(serverName)) continue;
                this.serverManager.expireServer(serverName);
            }
        }
        List list = nodes = this.useZKForAssignment ? ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode) : ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.watcher, (String)this.watcher.assignmentZNode);
        if (nodes != null && !nodes.isEmpty()) {
            for (String encodedRegionName : nodes) {
                this.processRegionInTransition(encodedRegionName, null);
            }
        } else if (!this.useZKForAssignment) {
            this.processRegionInTransitionZkLess();
        }
    }

    void processRegionInTransitionZkLess() {
        Map<String, RegionState> rits = this.regionStates.getRegionsInTransition();
        for (RegionState regionState : rits.values()) {
            LOG.info((Object)("Processing " + regionState));
            ServerName serverName = regionState.getServerName();
            if (serverName != null && !this.serverManager.getOnlineServers().containsKey(serverName)) {
                LOG.info((Object)("Server " + serverName + " isn't online. SSH will handle this"));
                continue;
            }
            HRegionInfo regionInfo = regionState.getRegion();
            RegionState.State state = regionState.getState();
            switch (state) {
                case CLOSED: {
                    this.invokeAssign(regionInfo);
                    break;
                }
                case PENDING_OPEN: {
                    this.retrySendRegionOpen(regionState);
                    break;
                }
                case PENDING_CLOSE: {
                    this.retrySendRegionClose(regionState);
                    break;
                }
                case FAILED_CLOSE: 
                case FAILED_OPEN: {
                    this.invokeUnAssign(regionInfo);
                    break;
                }
            }
        }
    }

    private void retrySendRegionOpen(final RegionState regionState) {
        this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            @Override
            public void process() throws IOException {
                HRegionInfo hri = regionState.getRegion();
                ServerName serverName = regionState.getServerName();
                ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Object)hri.getEncodedName());
                try {
                    RegionOpeningState regionOpenState;
                    int i = 1;
                    if (i > AssignmentManager.this.maximumAttempts) return;
                    if (!AssignmentManager.this.serverManager.isServerOnline(serverName) || this.server.isStopped() || this.server.isAborted()) {
                        lock.unlock();
                        return;
                    }
                    if (!regionState.equals((Object)AssignmentManager.this.regionStates.getRegionState(hri))) {
                        lock.unlock();
                        return;
                    }
                    List<ServerName> favoredNodes = ServerName.EMPTY_SERVER_LIST;
                    if (AssignmentManager.this.shouldAssignRegionsWithFavoredNodes) {
                        favoredNodes = ((FavoredNodeLoadBalancer)AssignmentManager.this.balancer).getFavoredNodes(hri);
                    }
                    if ((regionOpenState = AssignmentManager.this.serverManager.sendRegionOpen(serverName, hri, -1, favoredNodes)) == RegionOpeningState.FAILED_OPENING) {
                        LOG.debug((Object)("Got failed_opening in retry sendRegionOpen for " + regionState + ", re-assign it"));
                        AssignmentManager.this.invokeAssign(hri, true);
                    }
                    lock.unlock();
                    return;
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    private void retrySendRegionClose(final RegionState regionState) {
        this.executorService.submit(new EventHandler(this.server, EventType.M_MASTER_RECOVERY){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Lifted jumps to return sites
             */
            @Override
            public void process() throws IOException {
                HRegionInfo hri = regionState.getRegion();
                ServerName serverName = regionState.getServerName();
                ReentrantLock lock = AssignmentManager.this.locker.acquireLock((Object)hri.getEncodedName());
                try {
                    int i = 1;
                    if (i > AssignmentManager.this.maximumAttempts) return;
                    if (!AssignmentManager.this.serverManager.isServerOnline(serverName) || this.server.isStopped() || this.server.isAborted()) {
                        lock.unlock();
                        return;
                    }
                    if (!regionState.equals((Object)AssignmentManager.this.regionStates.getRegionState(hri))) {
                        lock.unlock();
                        return;
                    }
                    if (!AssignmentManager.this.serverManager.sendRegionClose(serverName, hri, -1, null, false)) {
                        LOG.debug((Object)("Got false in retry sendRegionClose for " + regionState + ", re-close it"));
                        AssignmentManager.this.invokeUnAssign(hri);
                    }
                    lock.unlock();
                    return;
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    public void updateRegionsInTransitionMetrics() {
        long currentTime = System.currentTimeMillis();
        int totalRITs = 0;
        int totalRITsOverThreshold = 0;
        long oldestRITTime = 0L;
        int ritThreshold = this.server.getConfiguration().getInt("hbase.metrics.rit.stuck.warning.threshold", 60000);
        for (RegionState state : this.regionStates.getRegionsInTransition().values()) {
            ++totalRITs;
            long ritTime = currentTime - state.getStamp();
            if (ritTime > (long)ritThreshold) {
                ++totalRITsOverThreshold;
            }
            if (oldestRITTime >= ritTime) continue;
            oldestRITTime = ritTime;
        }
        if (this.metricsAssignmentManager != null) {
            this.metricsAssignmentManager.updateRITOldestAge(oldestRITTime);
            this.metricsAssignmentManager.updateRITCount(totalRITs);
            this.metricsAssignmentManager.updateRITCountOverThreshold(totalRITsOverThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRegionPlan(HRegionInfo region) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            this.regionPlans.remove(region.getEncodedName());
        }
    }

    public void waitOnRegionToClearRegionsInTransition(HRegionInfo hri) throws IOException, InterruptedException {
        this.waitOnRegionToClearRegionsInTransition(hri, -1L);
    }

    public boolean waitOnRegionToClearRegionsInTransition(HRegionInfo hri, long timeOut) throws InterruptedException {
        if (!this.regionStates.isRegionInTransition(hri)) {
            return true;
        }
        long end = timeOut <= 0L ? Long.MAX_VALUE : EnvironmentEdgeManager.currentTime() + timeOut;
        LOG.info((Object)("Waiting for " + hri.getEncodedName() + " to leave regions-in-transition, timeOut=" + timeOut + " ms."));
        while (!this.server.isStopped() && this.regionStates.isRegionInTransition(hri)) {
            this.regionStates.waitForUpdate(100L);
            if (EnvironmentEdgeManager.currentTime() <= end) continue;
            LOG.info((Object)("Timed out on waiting for " + hri.getEncodedName() + " to be assigned."));
            return false;
        }
        if (this.server.isStopped()) {
            LOG.info((Object)"Giving up wait on regions in transition because stoppable.isStopped is set");
            return false;
        }
        return true;
    }

    void invokeAssign(HRegionInfo regionInfo) {
        this.invokeAssign(regionInfo, true);
    }

    void invokeAssign(HRegionInfo regionInfo, boolean newPlan) {
        this.threadPoolExecutorService.submit(new AssignCallable(this, regionInfo, newPlan));
    }

    void invokeUnAssign(HRegionInfo regionInfo) {
        this.threadPoolExecutorService.submit(new UnAssignCallable(this, regionInfo));
    }

    public ServerHostRegion isCarryingMeta(ServerName serverName) {
        return this.isCarryingRegion(serverName, HRegionInfo.FIRST_META_REGIONINFO);
    }

    public ServerHostRegion isCarryingMetaReplica(ServerName serverName, int replicaId) {
        return this.isCarryingRegion(serverName, RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (int)replicaId));
    }

    public ServerHostRegion isCarryingMetaReplica(ServerName serverName, HRegionInfo metaHri) {
        return this.isCarryingRegion(serverName, metaHri);
    }

    private ServerHostRegion isCarryingRegion(ServerName serverName, HRegionInfo hri) {
        ServerName addressFromZK;
        RegionTransition rt = null;
        try {
            byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)hri.getEncodedName());
            rt = data == null ? null : RegionTransition.parseFrom((byte[])data);
        }
        catch (KeeperException e) {
            this.server.abort("Exception reading unassigned node for region=" + hri.getEncodedName(), e);
        }
        catch (DeserializationException e) {
            this.server.abort("Exception parsing unassigned node for region=" + hri.getEncodedName(), e);
        }
        ServerName serverName2 = addressFromZK = rt != null ? rt.getServerName() : null;
        if (addressFromZK != null) {
            boolean matchZK = addressFromZK.equals((Object)serverName);
            LOG.debug((Object)("Checking region=" + hri.getRegionNameAsString() + ", zk server=" + addressFromZK + " current=" + serverName + ", matches=" + matchZK));
            return matchZK ? ServerHostRegion.HOSTING_REGION : ServerHostRegion.NOT_HOSTING_REGION;
        }
        ServerName addressFromAM = this.regionStates.getRegionServerOfRegion(hri);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("based on AM, current region=" + hri.getRegionNameAsString() + " is on server=" + (addressFromAM != null ? addressFromAM : "null") + " server being checked: " + serverName));
        }
        if (addressFromAM != null) {
            return addressFromAM.equals((Object)serverName) ? ServerHostRegion.HOSTING_REGION : ServerHostRegion.NOT_HOSTING_REGION;
        }
        if (hri.isMetaRegion() && RegionReplicaUtil.isDefaultReplica((HRegionInfo)hri)) {
            ServerName serverNameInZK = this.server.getMetaTableLocator().getMetaRegionLocation(this.server.getZooKeeper());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Based on MetaTableLocator, the META region is on server=" + (serverNameInZK == null ? "null" : serverNameInZK) + " server being checked: " + serverName));
            }
            if (serverNameInZK != null) {
                return serverNameInZK.equals((Object)serverName) ? ServerHostRegion.HOSTING_REGION : ServerHostRegion.NOT_HOSTING_REGION;
            }
        }
        return ServerHostRegion.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HRegionInfo> cleanOutCrashedServerReferences(ServerName sn) {
        NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
        synchronized (navigableMap) {
            Iterator i = this.regionPlans.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                ServerName otherSn = ((RegionPlan)e.getValue()).getDestination();
                if (otherSn == null || !otherSn.equals((Object)sn)) continue;
                i.remove();
            }
        }
        List<HRegionInfo> regions = this.regionStates.serverOffline(this.watcher, sn);
        Iterator<HRegionInfo> it = regions.iterator();
        while (it.hasNext()) {
            HRegionInfo hri = it.next();
            String encodedName = hri.getEncodedName();
            ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
            try {
                RegionState regionState = this.regionStates.getRegionTransitionState(encodedName);
                if (regionState == null || regionState.getServerName() != null && !regionState.isOnServer(sn) || !regionState.isFailedClose() && !regionState.isOffline() && !regionState.isPendingOpenOrOpening()) {
                    LOG.info((Object)("Skip " + regionState + " since it is not opening/failed_close" + " on the dead server any more: " + sn));
                    it.remove();
                    continue;
                }
                try {
                    ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri);
                }
                catch (KeeperException ke) {
                    this.server.abort("Unexpected ZK exception deleting node " + hri, ke);
                }
                if (this.tableStateManager.isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                    this.regionStates.regionOffline(hri);
                    it.remove();
                    continue;
                }
                this.regionStates.updateRegionState(hri, RegionState.State.OFFLINE);
            }
            finally {
                lock.unlock();
            }
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void balance(RegionPlan plan) {
        HRegionInfo hri = plan.getRegionInfo();
        TableName tableName = hri.getTable();
        if (this.tableStateManager.isTableState(tableName, ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
            LOG.info((Object)("Ignored moving region of disabling/disabled table " + tableName));
            return;
        }
        String encodedName = hri.getEncodedName();
        ReentrantLock lock = this.locker.acquireLock((Object)encodedName);
        try {
            if (!this.regionStates.isRegionOnline(hri)) {
                RegionState state = this.regionStates.getRegionState(encodedName);
                LOG.info((Object)("Ignored moving region not assigned: " + hri + ", " + (state == null ? "not in region states" : state)));
                return;
            }
            NavigableMap<String, RegionPlan> navigableMap = this.regionPlans;
            synchronized (navigableMap) {
                this.regionPlans.put(plan.getRegionName(), plan);
            }
            this.unassign(hri, false, plan.getDestination());
        }
        finally {
            lock.unlock();
        }
    }

    public void stop() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedHashMultimap<String, RegionRunnable> linkedHashMultimap = this.zkEventWorkerWaitingList;
        synchronized (linkedHashMultimap) {
            this.zkEventWorkerWaitingList.clear();
        }
        this.threadPoolExecutorService.shutdownNow();
        this.zkEventWorkers.shutdownNow();
        this.regionStateStore.stop();
    }

    protected void setEnabledTable(TableName tableName) {
        try {
            this.tableStateManager.setTableState(tableName, ZooKeeperProtos.Table.State.ENABLED);
        }
        catch (CoordinatedStateException e) {
            String errorMsg = "Unable to ensure that the table " + tableName + " will be" + " enabled because of a ZooKeeper issue";
            LOG.error((Object)errorMsg);
            this.server.abort(errorMsg, e);
        }
    }

    private boolean asyncSetOfflineInZooKeeper(RegionState state, AsyncCallback.StringCallback cb, ServerName destination) {
        if (!state.isClosed() && !state.isOffline()) {
            this.server.abort("Unexpected state trying to OFFLINE; " + state, new IllegalStateException());
            return false;
        }
        this.regionStates.updateRegionState(state.getRegion(), RegionState.State.OFFLINE);
        try {
            ZKAssign.asyncCreateNodeOffline((ZooKeeperWatcher)this.watcher, (HRegionInfo)state.getRegion(), (ServerName)destination, (AsyncCallback.StringCallback)cb, (Object)state);
        }
        catch (KeeperException e) {
            if (e instanceof KeeperException.NodeExistsException) {
                LOG.warn((Object)("Node for " + state.getRegion() + " already exists"));
            } else {
                this.server.abort("Unexpected ZK exception creating/setting node OFFLINE", e);
            }
            return false;
        }
        return true;
    }

    private boolean deleteNodeInStates(String encodedName, String desc, ServerName sn, EventType ... types) {
        try {
            for (EventType et : types) {
                if (!ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)et, (ServerName)sn)) continue;
                return true;
            }
            LOG.info((Object)("Failed to delete the " + desc + " node for " + encodedName + ". The node type may not match"));
        }
        catch (KeeperException.NoNodeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The " + desc + " node for " + encodedName + " already deleted"));
            }
        }
        catch (KeeperException ke) {
            this.server.abort("Unexpected ZK exception deleting " + desc + " node for the region " + encodedName, ke);
        }
        return false;
    }

    private void deleteMergingNode(String encodedName, ServerName sn) {
        this.deleteNodeInStates(encodedName, "merging", sn, EventType.RS_ZK_REGION_MERGING, EventType.RS_ZK_REQUEST_REGION_MERGE, EventType.RS_ZK_REGION_MERGED);
    }

    private void deleteSplittingNode(String encodedName, ServerName sn) {
        this.deleteNodeInStates(encodedName, "splitting", sn, EventType.RS_ZK_REGION_SPLITTING, EventType.RS_ZK_REQUEST_REGION_SPLIT, EventType.RS_ZK_REGION_SPLIT);
    }

    @SuppressWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"}, justification="Modification of Maps not ATOMIC!!!! FIX!!!")
    private void onRegionFailedOpen(HRegionInfo hri, ServerName sn) {
        String encodedName = hri.getEncodedName();
        AtomicInteger failedOpenCount = this.failedOpenTracker.get(encodedName);
        if (failedOpenCount == null) {
            failedOpenCount = new AtomicInteger();
            this.failedOpenTracker.put(encodedName, failedOpenCount);
        }
        if (failedOpenCount.incrementAndGet() >= this.maximumAttempts && !hri.isMetaRegion()) {
            this.regionStates.updateRegionState(hri, RegionState.State.FAILED_OPEN);
            this.failedOpenTracker.remove(encodedName);
        } else {
            RegionState regionState;
            if (hri.isMetaRegion() && failedOpenCount.get() >= this.maximumAttempts) {
                LOG.warn((Object)("Failed to open the hbase:meta region " + hri.getRegionNameAsString() + " after" + failedOpenCount.get() + " retries. Continue retrying."));
            }
            if ((regionState = this.regionStates.updateRegionState(hri, RegionState.State.CLOSED)) != null) {
                if (this.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING) || this.replicasToClose.contains(hri)) {
                    this.offlineDisabledRegion(hri);
                    return;
                }
                this.regionStates.updateRegionState(hri, RegionState.State.CLOSED);
                this.removeClosedRegion(hri);
                try {
                    this.getRegionPlan(hri, sn, true);
                }
                catch (HBaseIOException e) {
                    LOG.warn((Object)"Failed to get region plan", (Throwable)e);
                }
                this.invokeAssign(hri, false);
            }
        }
    }

    private void onRegionOpen(HRegionInfo hri, ServerName sn, long openSeqNum) {
        this.regionOnline(hri, sn, openSeqNum);
        if (this.useZKForAssignment) {
            try {
                ZKAssign.deleteNodeFailSilent((ZooKeeperWatcher)this.watcher, (HRegionInfo)hri);
            }
            catch (KeeperException ke) {
                this.server.abort("Unexpected ZK exception deleting node " + hri, ke);
            }
        }
        this.failedOpenTracker.remove(hri.getEncodedName());
        if (this.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
            this.invokeUnAssign(hri);
        }
    }

    private void onRegionClosed(HRegionInfo hri) {
        if (this.getTableStateManager().isTableState(hri.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING) || this.replicasToClose.contains(hri)) {
            this.offlineDisabledRegion(hri);
            return;
        }
        this.regionStates.updateRegionState(hri, RegionState.State.CLOSED);
        this.sendRegionClosedNotification(hri);
        this.removeClosedRegion(hri);
        this.invokeAssign(hri, false);
    }

    private String checkInStateForSplit(ServerName sn, HRegionInfo p, HRegionInfo a, HRegionInfo b) {
        RegionState rs_p = this.regionStates.getRegionState(p);
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (!rs_p.isOpenOrSplittingOnServer(sn) || rs_a != null && !rs_a.isOpenOrSplittingNewOnServer(sn) || rs_b != null && !rs_b.isOpenOrSplittingNewOnServer(sn)) {
            return "Not in state good for split";
        }
        return "";
    }

    private String onRegionSplitReverted(ServerName sn, HRegionInfo p, HRegionInfo a, HRegionInfo b) {
        String s = this.checkInStateForSplit(sn, p, a, b);
        if (!StringUtils.isEmpty((String)s)) {
            return s;
        }
        this.regionOnline(p, sn);
        RegionState regionStateA = this.regionStates.getRegionState(a);
        RegionState regionStateB = this.regionStates.getRegionState(b);
        if (regionStateA != null) {
            this.regionOffline(a);
        }
        if (regionStateB != null) {
            this.regionOffline(b);
        }
        if (this.getTableStateManager().isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
            this.invokeUnAssign(p);
        }
        return null;
    }

    private String onRegionSplit(ServerName sn, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, final HRegionInfo p, final HRegionInfo a, final HRegionInfo b) {
        String s = this.checkInStateForSplit(sn, p, a, b);
        if (!StringUtils.isEmpty((String)s)) {
            return s;
        }
        this.regionStates.updateRegionState(a, RegionState.State.SPLITTING_NEW, sn);
        this.regionStates.updateRegionState(b, RegionState.State.SPLITTING_NEW, sn);
        this.regionStates.updateRegionState(p, RegionState.State.SPLITTING);
        if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT) {
            if (TEST_SKIP_SPLIT_HANDLING) {
                return "Skipping split message, TEST_SKIP_SPLIT_HANDLING is set";
            }
            this.regionOffline(p, RegionState.State.SPLIT);
            this.regionOnline(a, sn, 1L);
            this.regionOnline(b, sn, 1L);
            if (this.getTableStateManager().isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                this.invokeUnAssign(a);
                this.invokeUnAssign(b);
            } else {
                Callable<Object> splitReplicasCallable = new Callable<Object>(){

                    @Override
                    public Object call() {
                        AssignmentManager.this.doSplittingOfReplicas(p, a, b);
                        return null;
                    }
                };
                this.threadPoolExecutorService.submit(splitReplicasCallable);
            }
        } else if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.SPLIT_PONR) {
            try {
                this.regionStates.splitRegion(p, a, b, sn);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to record split region " + p.getShortNameToLog()));
                return "Failed to record the splitting in meta";
            }
        }
        return null;
    }

    private String onRegionMerge(ServerName sn, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, final HRegionInfo p, final HRegionInfo a, final HRegionInfo b) {
        RegionState rs_p = this.regionStates.getRegionState(p);
        RegionState rs_a = this.regionStates.getRegionState(a);
        RegionState rs_b = this.regionStates.getRegionState(b);
        if (!rs_a.isOpenOrMergingOnServer(sn) || !rs_b.isOpenOrMergingOnServer(sn) || rs_p != null && !rs_p.isOpenOrMergingNewOnServer(sn)) {
            return "Not in state good for merge";
        }
        this.regionStates.updateRegionState(a, RegionState.State.MERGING);
        this.regionStates.updateRegionState(b, RegionState.State.MERGING);
        this.regionStates.updateRegionState(p, RegionState.State.MERGING_NEW, sn);
        String encodedName = p.getEncodedName();
        if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE) {
            this.mergingRegions.put(encodedName, (PairOfSameType<HRegionInfo>)new PairOfSameType((Object)a, (Object)b));
        } else if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGED) {
            this.mergingRegions.remove(encodedName);
            this.regionOffline(a, RegionState.State.MERGED);
            this.regionOffline(b, RegionState.State.MERGED);
            this.regionOnline(p, sn, 1L);
            if (this.getTableStateManager().isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                this.invokeUnAssign(p);
            } else {
                Callable<Object> mergeReplicasCallable = new Callable<Object>(){

                    @Override
                    public Object call() {
                        AssignmentManager.this.doMergingOfReplicas(p, a, b);
                        return null;
                    }
                };
                this.threadPoolExecutorService.submit(mergeReplicasCallable);
            }
        } else if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGE_PONR) {
            try {
                this.regionStates.mergeRegions(p, a, b, sn);
            }
            catch (IOException ioe) {
                LOG.info((Object)("Failed to record merged region " + p.getShortNameToLog()));
                return "Failed to record the merging in meta";
            }
        }
        return null;
    }

    private String onRegionMergeReverted(ServerName sn, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo p, HRegionInfo a, HRegionInfo b) {
        RegionState rs_p = this.regionStates.getRegionState(p);
        String encodedName = p.getEncodedName();
        this.mergingRegions.remove(encodedName);
        this.regionOnline(a, sn);
        this.regionOnline(b, sn);
        if (rs_p != null) {
            this.regionOffline(p);
        }
        if (this.getTableStateManager().isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
            this.invokeUnAssign(a);
            this.invokeUnAssign(b);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRegionMerging(RegionTransition rt, String encodedName, String prettyPrintedRegionName, ServerName sn) {
        List mergingRegions;
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.warn((Object)("Dropped merging! ServerName=" + sn + " unknown."));
            return false;
        }
        byte[] payloadOfMerging = rt.getPayload();
        try {
            mergingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfMerging, (int)0, (int)payloadOfMerging.length);
        }
        catch (IOException e) {
            LOG.error((Object)("Dropped merging! Failed reading " + rt.getEventType() + " payload for " + prettyPrintedRegionName));
            return false;
        }
        assert (mergingRegions.size() == 3);
        HRegionInfo p = (HRegionInfo)mergingRegions.get(0);
        HRegionInfo hri_a = (HRegionInfo)mergingRegions.get(1);
        HRegionInfo hri_b = (HRegionInfo)mergingRegions.get(2);
        RegionState rs_p = this.regionStates.getRegionState(p);
        RegionState rs_a = this.regionStates.getRegionState(hri_a);
        RegionState rs_b = this.regionStates.getRegionState(hri_b);
        if (rs_a != null && !rs_a.isOpenOrMergingOnServer(sn) || rs_b != null && !rs_b.isOpenOrMergingOnServer(sn) || rs_p != null && !rs_p.isOpenOrMergingNewOnServer(sn)) {
            LOG.warn((Object)("Dropped merging! Not in state good for MERGING; rs_p=" + rs_p + ", rs_a=" + rs_a + ", rs_b=" + rs_b));
            return false;
        }
        EventType et = rt.getEventType();
        if (et == EventType.RS_ZK_REQUEST_REGION_MERGE) {
            try {
                RegionMergeCoordination.RegionMergeDetails std = ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getRegionMergeCoordination().getDefaultDetails();
                ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getRegionMergeCoordination().processRegionMergeRequest(p, hri_a, hri_b, sn, std);
                if (((ZkRegionMergeCoordination.ZkRegionMergeDetails)std).getZnodeVersion() == -1) {
                    byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)encodedName);
                    EventType currentType = null;
                    if (data != null) {
                        RegionTransition newRt = RegionTransition.parseFrom((byte[])data);
                        currentType = newRt.getEventType();
                    }
                    if (currentType == null || currentType != EventType.RS_ZK_REGION_MERGED && currentType != EventType.RS_ZK_REGION_MERGING) {
                        LOG.warn((Object)("Failed to transition pending_merge node " + encodedName + " to merging, it's now " + currentType));
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to transition pending_merge node " + encodedName + " to merging"), (Throwable)e);
                return false;
            }
        }
        RegionStates e = this.regionStates;
        synchronized (e) {
            this.regionStates.updateRegionState(hri_a, RegionState.State.MERGING);
            this.regionStates.updateRegionState(hri_b, RegionState.State.MERGING);
            this.regionStates.updateRegionState(p, RegionState.State.MERGING_NEW, sn);
            if (et != EventType.RS_ZK_REGION_MERGED) {
                this.mergingRegions.put(encodedName, (PairOfSameType<HRegionInfo>)new PairOfSameType((Object)hri_a, (Object)hri_b));
            } else {
                this.mergingRegions.remove(encodedName);
                this.regionOffline(hri_a, RegionState.State.MERGED);
                this.regionOffline(hri_b, RegionState.State.MERGED);
                this.regionOnline(p, sn);
            }
        }
        if (et == EventType.RS_ZK_REGION_MERGED) {
            this.doMergingOfReplicas(p, hri_a, hri_b);
            LOG.debug((Object)("Handling MERGED event for " + encodedName + "; deleting node"));
            try {
                boolean successful = false;
                while (!successful) {
                    successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)EventType.RS_ZK_REGION_MERGED, (ServerName)sn);
                }
            }
            catch (KeeperException e2) {
                if (e2 instanceof KeeperException.NoNodeException) {
                    String znodePath = ZKUtil.joinZNode((String)this.watcher.splitLogZNode, (String)encodedName);
                    LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
                }
                this.server.abort("Error deleting MERGED node " + encodedName, e2);
            }
            LOG.info((Object)("Handled MERGED event; merged=" + p.getRegionNameAsString() + ", region_a=" + hri_a.getRegionNameAsString() + ", region_b=" + hri_b.getRegionNameAsString() + ", on " + sn));
            if (this.tableStateManager.isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                this.unassign(p);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRegionSplitting(RegionTransition rt, String encodedName, String prettyPrintedRegionName, ServerName sn) {
        List splittingRegions;
        if (!this.serverManager.isServerOnline(sn)) {
            LOG.warn((Object)("Dropped splitting! ServerName=" + sn + " unknown."));
            return false;
        }
        byte[] payloadOfSplitting = rt.getPayload();
        try {
            splittingRegions = HRegionInfo.parseDelimitedFrom((byte[])payloadOfSplitting, (int)0, (int)payloadOfSplitting.length);
        }
        catch (IOException e) {
            LOG.error((Object)("Dropped splitting! Failed reading " + rt.getEventType() + " payload for " + prettyPrintedRegionName));
            return false;
        }
        assert (splittingRegions.size() == 2);
        HRegionInfo hri_a = (HRegionInfo)splittingRegions.get(0);
        HRegionInfo hri_b = (HRegionInfo)splittingRegions.get(1);
        RegionState rs_p = this.regionStates.getRegionState(encodedName);
        RegionState rs_a = this.regionStates.getRegionState(hri_a);
        RegionState rs_b = this.regionStates.getRegionState(hri_b);
        if (rs_p != null && !rs_p.isOpenOrSplittingOnServer(sn) || rs_a != null && !rs_a.isOpenOrSplittingNewOnServer(sn) || rs_b != null && !rs_b.isOpenOrSplittingNewOnServer(sn)) {
            LOG.warn((Object)("Dropped splitting! Not in state good for SPLITTING; rs_p=" + rs_p + ", rs_a=" + rs_a + ", rs_b=" + rs_b));
            return false;
        }
        if (rs_p == null) {
            rs_p = this.regionStates.updateRegionState(rt, RegionState.State.OPEN);
            if (rs_p == null) {
                LOG.warn((Object)("Received splitting for region " + prettyPrintedRegionName + " from server " + sn + " but it doesn't exist anymore," + " probably already processed its split"));
                return false;
            }
            this.regionStates.regionOnline(rs_p.getRegion(), sn);
        }
        HRegionInfo p = rs_p.getRegion();
        EventType et = rt.getEventType();
        if (et == EventType.RS_ZK_REQUEST_REGION_SPLIT) {
            try {
                SplitTransactionCoordination.SplitTransactionDetails std = ((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitTransactionCoordination().getDefaultDetails();
                if (((BaseCoordinatedStateManager)this.server.getCoordinatedStateManager()).getSplitTransactionCoordination().processTransition(p, hri_a, hri_b, sn, std) == -1) {
                    byte[] data = ZKAssign.getData((ZooKeeperWatcher)this.watcher, (String)encodedName);
                    EventType currentType = null;
                    if (data != null) {
                        RegionTransition newRt = RegionTransition.parseFrom((byte[])data);
                        currentType = newRt.getEventType();
                    }
                    if (currentType == null || currentType != EventType.RS_ZK_REGION_SPLIT && currentType != EventType.RS_ZK_REGION_SPLITTING) {
                        LOG.warn((Object)("Failed to transition pending_split node " + encodedName + " to splitting, it's now " + currentType));
                        return false;
                    }
                }
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed to transition pending_split node " + encodedName + " to splitting"), (Throwable)e);
                return false;
            }
        }
        RegionStates e = this.regionStates;
        synchronized (e) {
            this.splitRegions.put(p, (PairOfSameType<HRegionInfo>)new PairOfSameType((Object)hri_a, (Object)hri_b));
            this.regionStates.updateRegionState(hri_a, RegionState.State.SPLITTING_NEW, sn);
            this.regionStates.updateRegionState(hri_b, RegionState.State.SPLITTING_NEW, sn);
            this.regionStates.updateRegionState(rt, RegionState.State.SPLITTING);
            if (TEST_SKIP_SPLIT_HANDLING) {
                LOG.warn((Object)"Skipping split message, TEST_SKIP_SPLIT_HANDLING is set");
                return true;
            }
            if (et == EventType.RS_ZK_REGION_SPLIT) {
                this.regionOffline(p, RegionState.State.SPLIT);
                this.regionOnline(hri_a, sn);
                this.regionOnline(hri_b, sn);
                this.splitRegions.remove(p);
            }
        }
        if (et == EventType.RS_ZK_REGION_SPLIT) {
            this.doSplittingOfReplicas(rs_p.getRegion(), hri_a, hri_b);
            LOG.debug((Object)("Handling SPLIT event for " + encodedName + "; deleting node"));
            try {
                boolean successful = false;
                while (!successful) {
                    successful = ZKAssign.deleteNode((ZooKeeperWatcher)this.watcher, (String)encodedName, (EventType)EventType.RS_ZK_REGION_SPLIT, (ServerName)sn);
                }
            }
            catch (KeeperException e2) {
                if (e2 instanceof KeeperException.NoNodeException) {
                    String znodePath = ZKUtil.joinZNode((String)this.watcher.splitLogZNode, (String)encodedName);
                    LOG.debug((Object)("The znode " + znodePath + " does not exist.  May be deleted already."));
                }
                this.server.abort("Error deleting SPLIT node " + encodedName, e2);
            }
            LOG.info((Object)("Handled SPLIT event; parent=" + p.getRegionNameAsString() + ", daughter a=" + hri_a.getRegionNameAsString() + ", daughter b=" + hri_b.getRegionNameAsString() + ", on " + sn));
            if (this.tableStateManager.isTableState(p.getTable(), ZooKeeperProtos.Table.State.DISABLED, ZooKeeperProtos.Table.State.DISABLING)) {
                this.unassign(hri_a);
                this.unassign(hri_b);
            }
        }
        return true;
    }

    private void doMergingOfReplicas(HRegionInfo mergedHri, HRegionInfo hri_a, HRegionInfo hri_b) {
        ArrayList<HRegionInfo> unmergedRegions = new ArrayList<HRegionInfo>();
        unmergedRegions.add(hri_a);
        unmergedRegions.add(hri_b);
        Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(unmergedRegions);
        Collection<List<HRegionInfo>> c = map.values();
        for (List<HRegionInfo> l : c) {
            for (HRegionInfo h : l) {
                if (RegionReplicaUtil.isDefaultReplica((HRegionInfo)h)) continue;
                LOG.debug((Object)("Unassigning un-merged replica " + h));
                this.unassign(h);
            }
        }
        int numReplicas = 1;
        try {
            numReplicas = this.server.getTableDescriptors().get(mergedHri.getTable()).getRegionReplication();
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't get the replication attribute of the table " + mergedHri.getTable() + " due to " + e.getMessage() + ". The assignment of replicas for the merged region " + "will not be done"));
        }
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (int i = 1; i < numReplicas; ++i) {
            regions.add(RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)mergedHri, (int)i));
        }
        try {
            this.assign(regions);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("Couldn't assign all replica(s) of region " + mergedHri + " because of " + ioe.getMessage()));
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Couldn't assign all replica(s) of region " + mergedHri + " because of " + ie.getMessage()));
        }
    }

    private void doSplittingOfReplicas(HRegionInfo parentHri, HRegionInfo hri_a, HRegionInfo hri_b) {
        int numReplicas = 1;
        try {
            numReplicas = this.server.getTableDescriptors().get(parentHri.getTable()).getRegionReplication();
        }
        catch (IOException e) {
            LOG.warn((Object)("Couldn't get the replication attribute of the table " + parentHri.getTable() + " due to " + e.getMessage() + ". The assignment of daughter replicas " + "replicas will not be done"));
        }
        ArrayList<HRegionInfo> parentRegion = new ArrayList<HRegionInfo>();
        parentRegion.add(parentHri);
        Map<ServerName, List<HRegionInfo>> currentAssign = this.regionStates.getRegionAssignments(parentRegion);
        Collection<List<HRegionInfo>> c = currentAssign.values();
        for (List<HRegionInfo> l : c) {
            for (HRegionInfo h : l) {
                if (RegionReplicaUtil.isDefaultReplica((HRegionInfo)h)) continue;
                LOG.debug((Object)("Unassigning parent's replica " + h));
                this.unassign(h);
            }
        }
        HashMap<HRegionInfo, ServerName> map = new HashMap<HRegionInfo, ServerName>();
        for (int i = 1; i < numReplicas; ++i) {
            this.prepareDaughterReplicaForAssignment(hri_a, parentHri, i, map);
            this.prepareDaughterReplicaForAssignment(hri_b, parentHri, i, map);
        }
        try {
            this.assign(map);
        }
        catch (IOException e) {
            LOG.warn((Object)("Caught exception " + e + " while trying to assign replica(s) of daughter(s)"));
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("Caught exception " + e + " while trying to assign replica(s) of daughter(s)"));
        }
    }

    private void prepareDaughterReplicaForAssignment(HRegionInfo daughterHri, HRegionInfo parentHri, int replicaId, Map<HRegionInfo, ServerName> map) {
        HRegionInfo parentReplica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)parentHri, (int)replicaId);
        HRegionInfo daughterReplica = RegionReplicaUtil.getRegionInfoForReplica((HRegionInfo)daughterHri, (int)replicaId);
        LOG.debug((Object)("Created replica region for daughter " + daughterReplica));
        ServerName sn = this.regionStates.getRegionServerOfRegion(parentReplica);
        if (sn != null) {
            map.put(daughterReplica, sn);
        } else {
            List<ServerName> servers = this.serverManager.getOnlineServersList();
            sn = servers.get(new Random(System.currentTimeMillis()).nextInt(servers.size()));
            map.put(daughterReplica, sn);
        }
    }

    public Set<HRegionInfo> getReplicasToClose() {
        return this.replicasToClose;
    }

    private void regionOffline(HRegionInfo regionInfo, RegionState.State state) {
        block3: {
            block2: {
                this.regionStates.regionOffline(regionInfo, state);
                this.removeClosedRegion(regionInfo);
                this.clearRegionPlan(regionInfo);
                this.balancer.regionOffline(regionInfo);
                this.sendRegionClosedNotification(regionInfo);
                if (state == null || !state.equals((Object)RegionState.State.SPLIT)) break block2;
                ArrayList<HRegionInfo> c = new ArrayList<HRegionInfo>(1);
                c.add(regionInfo);
                Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(c);
                Collection<List<HRegionInfo>> allReplicas = map.values();
                for (List<HRegionInfo> list : allReplicas) {
                    this.replicasToClose.addAll(list);
                }
                break block3;
            }
            if (state == null || !state.equals((Object)RegionState.State.MERGED)) break block3;
            ArrayList<HRegionInfo> c = new ArrayList<HRegionInfo>(1);
            c.add(regionInfo);
            Map<ServerName, List<HRegionInfo>> map = this.regionStates.getRegionAssignments(c);
            Collection<List<HRegionInfo>> allReplicas = map.values();
            for (List<HRegionInfo> list : allReplicas) {
                this.replicasToClose.addAll(list);
            }
        }
    }

    private void sendRegionOpenedNotification(HRegionInfo regionInfo, ServerName serverName) {
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionOpened(regionInfo, serverName);
            }
        }
    }

    private void sendRegionClosedNotification(HRegionInfo regionInfo) {
        if (!this.listeners.isEmpty()) {
            for (AssignmentListener listener : this.listeners) {
                listener.regionClosed(regionInfo);
            }
        }
    }

    protected String onRegionTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition transition) {
        RegionServerStatusProtos.RegionStateTransition.TransitionCode code = transition.getTransitionCode();
        HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(0));
        RegionState current = this.regionStates.getRegionState(hri);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got transition " + code + " for " + (current != null ? current.toString() : hri.getShortNameToLog()) + " from " + serverName));
        }
        String errorMsg = null;
        switch (code) {
            case OPENED: {
                if (current != null && current.isOpened() && current.isOnServer(serverName)) {
                    LOG.info((Object)("Region " + hri.getShortNameToLog() + " is already " + current.getState() + " on " + serverName));
                    break;
                }
            }
            case FAILED_OPEN: {
                if (current == null || !current.isPendingOpenOrOpeningOnServer(serverName)) {
                    errorMsg = hri.getShortNameToLog() + " is not pending open on " + serverName;
                    break;
                }
                if (code == RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN) {
                    this.onRegionFailedOpen(hri, serverName);
                    break;
                }
                long openSeqNum = -1L;
                if (transition.hasOpenSeqNum()) {
                    openSeqNum = transition.getOpenSeqNum();
                }
                if (openSeqNum < 0L) {
                    errorMsg = "Newly opened region has invalid open seq num " + openSeqNum;
                    break;
                }
                this.onRegionOpen(hri, serverName, openSeqNum);
                break;
            }
            case CLOSED: {
                if (current == null || !current.isPendingCloseOrClosingOnServer(serverName)) {
                    errorMsg = hri.getShortNameToLog() + " is not pending close on " + serverName;
                    break;
                }
                this.onRegionClosed(hri);
                break;
            }
            case READY_TO_SPLIT: {
                try {
                    this.regionStateListener.onRegionSplit(hri);
                }
                catch (IOException exp) {
                    errorMsg = org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp);
                }
                break;
            }
            case SPLIT_PONR: 
            case SPLIT: {
                errorMsg = this.onRegionSplit(serverName, code, hri, HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1)), HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2)));
                break;
            }
            case SPLIT_REVERTED: {
                errorMsg = this.onRegionSplitReverted(serverName, hri, HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1)), HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2)));
                if (!StringUtils.isEmpty((String)errorMsg)) break;
                try {
                    this.regionStateListener.onRegionSplitReverted(hri);
                }
                catch (IOException exp) {
                    LOG.warn((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp));
                }
                break;
            }
            case READY_TO_MERGE: 
            case MERGE_PONR: 
            case MERGED: {
                errorMsg = this.onRegionMerge(serverName, code, hri, HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1)), HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2)));
                if (code != RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGED || !StringUtils.isEmpty((String)errorMsg)) break;
                try {
                    this.regionStateListener.onRegionMerged(hri);
                }
                catch (IOException exp) {
                    errorMsg = org.apache.hadoop.util.StringUtils.stringifyException((Throwable)exp);
                }
                break;
            }
            case MERGE_REVERTED: {
                errorMsg = this.onRegionMergeReverted(serverName, code, hri, HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(1)), HRegionInfo.convert((HBaseProtos.RegionInfo)transition.getRegionInfo(2)));
                break;
            }
            default: {
                errorMsg = "Unexpected transition code " + code;
            }
        }
        if (errorMsg != null) {
            LOG.error((Object)("Failed to transtion region from " + current + " to " + code + " by " + serverName + ": " + errorMsg));
        }
        return errorMsg;
    }

    private void processBogusAssignments(Map<ServerName, List<HRegionInfo>> bulkPlan) {
        if (bulkPlan.containsKey(LoadBalancer.BOGUS_SERVER_NAME)) {
            for (HRegionInfo hri : bulkPlan.get(LoadBalancer.BOGUS_SERVER_NAME)) {
                this.regionStates.updateRegionState(hri, RegionState.State.FAILED_OPEN);
            }
            bulkPlan.remove(LoadBalancer.BOGUS_SERVER_NAME);
        }
    }

    public LoadBalancer getBalancer() {
        return this.balancer;
    }

    public Map<ServerName, List<HRegionInfo>> getSnapShotOfAssignment(Collection<HRegionInfo> infos) {
        return this.getRegionStates().getRegionAssignments(infos);
    }

    void setRegionStateListener(RegionStateListener listener) {
        this.regionStateListener = listener;
    }

    private static interface RegionRunnable
    extends Runnable {
        public String getRegionName();
    }

    public static enum ServerHostRegion {
        NOT_HOSTING_REGION,
        HOSTING_REGION,
        UNKNOWN;

    }
}

