/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.compression;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.compression.CompressionCodec;
import org.apache.oozie.compression.GzipCompressionCodec;
import org.apache.oozie.util.XLog;

public class CodecFactory {
    private static final Map<String, CompressionCodec> REGISTERED = new HashMap<String, CompressionCodec>();
    public static final String COMPRESSION_CODECS = "oozie.compression.codecs";
    public static final String COMPRESSION_OUTPUT_CODEC = "oozie.output.compression.codec";
    private static CompressionCodec outputCompressionCodec;
    public static final String COMPRESSION_MAGIC_DATA = "OBJ";
    public static final String COMPRESSION_KEY_HEADER = "codec";
    public static final String UTF_8_ENCODING = "UTF-8";
    private static boolean isEnabled;
    private static XLog LOG;
    private static byte[] headerBytes;

    public static void initialize(Configuration conf) throws Exception {
        String[] outputCompressionCodecs;
        String outputCompressionStr = conf.get(COMPRESSION_OUTPUT_CODEC);
        if (outputCompressionStr == null || outputCompressionStr.trim().equalsIgnoreCase("NONE") || outputCompressionStr.trim().equalsIgnoreCase("")) {
            isEnabled = false;
        } else {
            outputCompressionStr = outputCompressionStr.trim();
            isEnabled = true;
        }
        for (String comp : outputCompressionCodecs = conf.getStrings(COMPRESSION_CODECS)) {
            CodecFactory.parseCompressionConfig(comp);
        }
        if (isEnabled) {
            if (REGISTERED.get("gz") == null) {
                REGISTERED.put("gz", new GzipCompressionCodec());
            }
            if ((outputCompressionCodec = REGISTERED.get(outputCompressionStr)) == null) {
                throw new RuntimeException("No codec class found for codec " + outputCompressionStr);
            }
        }
        LOG.info("Using " + outputCompressionStr + " as output compression codec");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream daos = new DataOutputStream(baos);
        daos.write(COMPRESSION_MAGIC_DATA.getBytes(UTF_8_ENCODING));
        daos.writeInt(1);
        daos.writeInt(1);
        daos.writeUTF(COMPRESSION_KEY_HEADER);
        daos.writeUTF(outputCompressionStr);
        daos.close();
        headerBytes = baos.toByteArray();
    }

    private static void parseCompressionConfig(String comp) throws Exception {
        String[] compression = comp.split("=", 2);
        if (compression.length != 2) {
            throw new IllegalArgumentException("Property " + comp + " not in key=value format" + "; output compression cannot be enabled");
        }
        String key = compression[0];
        String value = compression[1];
        REGISTERED.put(key, (CompressionCodec)Class.forName(value).newInstance());
        LOG.info("Adding [{0}] to list of output compression codecs", key);
    }

    private static CompressionCodec getCodec(String key) {
        CompressionCodec codec = REGISTERED.get(key);
        if (codec != null) {
            return codec;
        }
        throw new RuntimeException("No compression algo found corresponding to " + key);
    }

    public static boolean isCompressionEnabled() {
        return isEnabled;
    }

    public static CompressionCodec getDeCompressionCodec(DataInputStream dais) throws IOException {
        byte[] buffer = new byte[COMPRESSION_MAGIC_DATA.length()];
        dais.read(buffer, 0, buffer.length);
        HashMap<String, String> compressionProps = new HashMap<String, String>();
        try {
            if (!new String(buffer, UTF_8_ENCODING).equals(COMPRESSION_MAGIC_DATA)) {
                dais.reset();
                return null;
            }
            dais.readInt();
            dais.readInt();
            compressionProps.put(dais.readUTF(), dais.readUTF());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return CodecFactory.getCodec((String)compressionProps.get(COMPRESSION_KEY_HEADER));
    }

    public static CompressionCodec getCompressionCodec() {
        return outputCompressionCodec;
    }

    public static byte[] getHeaderBytes() {
        return headerBytes;
    }

    static {
        LOG = XLog.getLog(CodecFactory.class);
    }
}

