/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.GroupsService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;

public class ProxyUserService
implements Service {
    private static XLog LOG = XLog.getLog(ProxyUserService.class);
    public static final String CONF_PREFIX = "oozie.service.ProxyUserService.proxyuser.";
    public static final String GROUPS = ".groups";
    public static final String HOSTS = ".hosts";
    private Services services;
    private Map<String, Set<String>> proxyUserHosts = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> proxyUserGroups = new HashMap<String, Set<String>>();

    @Override
    public Class<? extends Service> getInterface() {
        return ProxyUserService.class;
    }

    @Override
    public void init(Services services) throws ServiceException {
        this.services = services;
        for (Map.Entry entry : services.getConf()) {
            HashSet<String> values;
            String value;
            String proxyUser;
            String key = (String)entry.getKey();
            if (key.startsWith(CONF_PREFIX) && key.endsWith(GROUPS)) {
                proxyUser = key.substring(0, key.lastIndexOf(GROUPS));
                if (services.getConf().get(proxyUser + HOSTS) == null) {
                    throw new ServiceException(ErrorCode.E0551, CONF_PREFIX + proxyUser + HOSTS);
                }
                proxyUser = proxyUser.substring(CONF_PREFIX.length());
                value = ((String)entry.getValue()).trim();
                LOG.info("Loading proxyuser settings [{0}]=[{1}]", key, value);
                values = null;
                if (!value.equals("*")) {
                    values = new HashSet<String>(Arrays.asList(value.split(",")));
                }
                this.proxyUserGroups.put(proxyUser, values);
            }
            if (!key.startsWith(CONF_PREFIX) || !key.endsWith(HOSTS)) continue;
            proxyUser = key.substring(0, key.lastIndexOf(HOSTS));
            if (services.getConf().get(proxyUser + GROUPS) == null) {
                throw new ServiceException(ErrorCode.E0551, CONF_PREFIX + proxyUser + GROUPS);
            }
            proxyUser = proxyUser.substring(CONF_PREFIX.length());
            value = ((String)entry.getValue()).trim();
            LOG.info("Loading proxyuser settings [{0}]=[{1}]", key, value);
            values = null;
            if (!value.equals("*")) {
                String[] hosts = value.split(",");
                for (int i = 0; i < hosts.length; ++i) {
                    String originalName = hosts[i];
                    try {
                        hosts[i] = this.normalizeHostname(originalName);
                    }
                    catch (Exception ex) {
                        throw new ServiceException(ErrorCode.E0550, originalName, ex.getMessage(), ex);
                    }
                    LOG.info("  Hostname, original [{0}], normalized [{1}]", originalName, hosts[i]);
                }
                values = new HashSet<String>(Arrays.asList(hosts));
            }
            this.proxyUserHosts.put(proxyUser, values);
        }
    }

    public void validate(String proxyUser, String proxyHost, String doAsUser) throws IOException, AccessControlException {
        ParamChecker.notEmpty(proxyUser, "proxyUser", "If you're attempting to use user-impersonation via a proxy user, please make sure that oozie.service.ProxyUserService.proxyuser.#USER#.hosts and oozie.service.ProxyUserService.proxyuser.#USER#.groups are configured correctly");
        ParamChecker.notEmpty(proxyHost, "proxyHost", "If you're attempting to use user-impersonation via a proxy user, please make sure that oozie.service.ProxyUserService.proxyuser." + proxyUser + ".hosts and " + CONF_PREFIX + proxyUser + ".groups are configured correctly");
        ParamChecker.notEmpty(doAsUser, "doAsUser");
        LOG.debug("Authorization check proxyuser [{0}] host [{1}] doAs [{2}]", proxyUser, proxyHost, doAsUser);
        if (!this.proxyUserHosts.containsKey(proxyUser)) {
            throw new AccessControlException(MessageFormat.format("User [{0}] not defined as proxyuser", proxyUser));
        }
        proxyHost = this.normalizeHostname(proxyHost);
        this.validateRequestorHost(proxyUser, proxyHost, this.proxyUserHosts.get(proxyUser));
        this.validateGroup(proxyUser, doAsUser, this.proxyUserGroups.get(proxyUser));
    }

    private void validateRequestorHost(String proxyUser, String hostname, Set<String> validHosts) throws IOException, AccessControlException {
        if (validHosts != null && !validHosts.contains(hostname) && !validHosts.contains(this.normalizeHostname(hostname))) {
            throw new AccessControlException(MessageFormat.format("Unauthorized host [{0}] for proxyuser [{1}]", hostname, proxyUser));
        }
    }

    private void validateGroup(String proxyUser, String user, Set<String> validGroups) throws IOException, AccessControlException {
        if (validGroups != null) {
            List<String> userGroups = this.services.get(GroupsService.class).getGroups(user);
            for (String g : validGroups) {
                if (!userGroups.contains(g)) continue;
                return;
            }
            throw new AccessControlException(MessageFormat.format("Unauthorized proxyuser [{0}] for user [{1}], not in proxyuser groups", proxyUser, user));
        }
    }

    private String normalizeHostname(String name) {
        try {
            InetAddress address = InetAddress.getByName(name);
            return address.getCanonicalHostName();
        }
        catch (IOException ex) {
            throw new AccessControlException(MessageFormat.format("Could not resolve host [{0}], {1}", name, ex.getMessage()));
        }
    }

    @Override
    public void destroy() {
    }
}

