/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.PropertyConfigurator;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogUtil;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;

public class XLogService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP = "logging";
    public static final String OOZIE_LOG_DIR = "oozie.log.dir";
    public static final String LOG4J_FILE = "oozie.log4j.file";
    public static final String LOG4J_RELOAD = "oozie.log4j.reload";
    public static final String DEFAULT_LOG4J_PROPERTIES = "oozie-log4j.properties";
    public static final String DEFAULT_RELOAD_INTERVAL = "10";
    private XLog log;
    private long interval;
    private boolean fromClasspath;
    private String log4jFileName;
    private boolean logOverWS = true;
    private boolean errorLogEnabled = true;
    private boolean auditLogEnabled = true;
    private static final String STARTUP_MESSAGE = "{E} ******************************************************************************* {E}  STARTUP MSG: Oozie BUILD_VERSION [{0}] compiled by [{1}] on [{2}]{E}  STARTUP MSG:       revision [{3}]@[{4}]{E}*******************************************************************************";
    private String oozieLogPath;
    private String oozieLogName;
    private String oozieErrorLogPath;
    private String oozieErrorLogName;
    private String oozieAuditLogPath;
    private String oozieAuditLogName;
    private int oozieLogRotation = -1;
    private int oozieErrorLogRotation = -1;
    private int oozieAuditLogRotation = -1;
    public static final String USER = "USER";
    public static final String GROUP = "GROUP";

    public String getOozieLogPath() {
        return this.oozieLogPath;
    }

    public String getOozieErrorLogPath() {
        return this.oozieErrorLogPath;
    }

    public String getOozieLogName() {
        return this.oozieLogName;
    }

    public String getOozieErrorLogName() {
        return this.oozieErrorLogName;
    }

    @Override
    public void init(Services services) throws ServiceException {
        String oozieHome = Services.getOozieHome();
        String oozieLogs = System.getProperty(OOZIE_LOG_DIR, oozieHome + "/logs");
        System.setProperty(OOZIE_LOG_DIR, oozieLogs);
        try {
            URL log4jUrl;
            ClassLoader cl;
            LogManager.resetConfiguration();
            this.log4jFileName = System.getProperty(LOG4J_FILE, DEFAULT_LOG4J_PROPERTIES);
            if (this.log4jFileName.contains("/")) {
                throw new ServiceException(ErrorCode.E0011, this.log4jFileName);
            }
            if (!this.log4jFileName.endsWith(".properties")) {
                throw new ServiceException(ErrorCode.E0012, this.log4jFileName);
            }
            String configPath = ConfigurationService.getConfigurationDirectory();
            File log4jFile = new File(configPath, this.log4jFileName);
            if (log4jFile.exists()) {
                this.fromClasspath = false;
            } else {
                cl = Thread.currentThread().getContextClassLoader();
                log4jUrl = cl.getResource(this.log4jFileName);
                if (log4jUrl == null) {
                    throw new ServiceException(ErrorCode.E0013, this.log4jFileName, configPath);
                }
                this.fromClasspath = true;
            }
            if (this.fromClasspath) {
                cl = Thread.currentThread().getContextClassLoader();
                log4jUrl = cl.getResource(this.log4jFileName);
                PropertyConfigurator.configure((URL)log4jUrl);
            } else {
                this.interval = Long.parseLong(System.getProperty(LOG4J_RELOAD, DEFAULT_RELOAD_INTERVAL));
                PropertyConfigurator.configureAndWatch((String)log4jFile.toString(), (long)(this.interval * 1000L));
            }
            this.log = new XLog(LogFactory.getLog(this.getClass()));
            this.log.info(4, STARTUP_MESSAGE, BuildInfo.getBuildInfo().getProperty("build.version"), BuildInfo.getBuildInfo().getProperty("build.user"), BuildInfo.getBuildInfo().getProperty("build.time"), BuildInfo.getBuildInfo().getProperty("vc.revision"), BuildInfo.getBuildInfo().getProperty("vc.url"));
            String from = this.fromClasspath ? "CLASSPATH" : configPath;
            String reload = this.fromClasspath ? "disabled" : Long.toString(this.interval) + " sec";
            this.log.info("Log4j configuration file [{0}]", this.log4jFileName);
            this.log.info("Log4j configuration file loaded from [{0}]", from);
            this.log.info("Log4j reload interval [{0}]", reload);
            XLog.Info.reset();
            XLog.Info.defineParameter(USER);
            XLog.Info.defineParameter(GROUP);
            XLogFilter.reset();
            XLogFilter.defineParameter(USER);
            XLogFilter.defineParameter(GROUP);
            ClassLoader cl2 = Thread.currentThread().getContextClassLoader();
            InputStream is = this.fromClasspath ? cl2.getResourceAsStream(this.log4jFileName) : new FileInputStream(log4jFile);
            this.extractInfoForLogWebService(is);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0010, ex.getMessage(), ex);
        }
    }

    private void extractInfoForLogWebService(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        XConfiguration conf = new XConfiguration();
        conf.setRestrictSystemProperties(false);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        XLogUtil logUtil = new XLogUtil(conf, "oozie");
        this.logOverWS = logUtil.isLogOverEnable();
        this.oozieLogRotation = logUtil.getLogRotation() == 0 ? this.oozieLogRotation : logUtil.getLogRotation();
        this.oozieLogPath = logUtil.getLogPath() == null ? this.oozieLogPath : logUtil.getLogPath();
        this.oozieLogName = logUtil.getLogFileName() == null ? this.oozieLogName : logUtil.getLogFileName();
        logUtil = new XLogUtil(conf, "oozieError");
        this.errorLogEnabled = logUtil.isLogOverEnable();
        this.oozieErrorLogRotation = logUtil.getLogRotation() == 0 ? this.oozieErrorLogRotation : logUtil.getLogRotation();
        this.oozieErrorLogPath = logUtil.getLogPath() == null ? this.oozieErrorLogPath : logUtil.getLogPath();
        this.oozieErrorLogName = logUtil.getLogFileName() == null ? this.oozieErrorLogName : logUtil.getLogFileName();
        logUtil = new XLogUtil(conf, "oozieaudit");
        this.auditLogEnabled = logUtil.isLogOverEnable();
        this.oozieAuditLogRotation = logUtil.getLogRotation() == 0 ? this.oozieAuditLogRotation : logUtil.getLogRotation();
        this.oozieAuditLogPath = logUtil.getLogPath() == null ? this.oozieAuditLogPath : logUtil.getLogPath();
        this.oozieAuditLogName = logUtil.getLogFileName() == null ? this.oozieAuditLogName : logUtil.getLogFileName();
    }

    @Override
    public void destroy() {
        LogManager.shutdown();
        XLog.Info.reset();
        XLogFilter.reset();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return XLogService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable(INSTRUMENTATION_GROUP, "config.file", new Instrumentation.Variable<String>(){

            @Override
            public String getValue() {
                return XLogService.this.log4jFileName;
            }
        });
        instr.addVariable(INSTRUMENTATION_GROUP, "reload.interval", new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return XLogService.this.interval;
            }
        });
        instr.addVariable(INSTRUMENTATION_GROUP, "from.classpath", new Instrumentation.Variable<Boolean>(){

            @Override
            public Boolean getValue() {
                return XLogService.this.fromClasspath;
            }
        });
        instr.addVariable(INSTRUMENTATION_GROUP, "log.over.web-service", new Instrumentation.Variable<Boolean>(){

            @Override
            public Boolean getValue() {
                return XLogService.this.logOverWS;
            }
        });
    }

    boolean getLogOverWS() {
        return this.logOverWS;
    }

    boolean isErrorLogEnabled() {
        return this.errorLogEnabled;
    }

    int getOozieLogRotation() {
        return this.oozieLogRotation;
    }

    int getOozieErrorLogRotation() {
        return this.oozieErrorLogRotation;
    }

    int getOozieAuditLogRotation() {
        return this.oozieAuditLogRotation;
    }

    public String getOozieAuditLogPath() {
        return this.oozieAuditLogPath;
    }

    public String getOozieAuditLogName() {
        return this.oozieAuditLogName;
    }

    boolean isAuditLogEnabled() {
        return this.auditLogEnabled;
    }

    String getLog4jProperties() {
        return this.log4jFileName;
    }

    boolean getFromClasspath() {
        return this.fromClasspath;
    }
}

