/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionModifiedDateForRangeJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionRunningCountForRangeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordActionsInDateRange {
    public static List<String> getCoordActionIdsFromDates(String jobId, String scope) throws XException {
        String[] list;
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        LinkedHashSet<String> actionSet = new LinkedHashSet<String>();
        for (String s : list = scope.split(",")) {
            if (!(s = s.trim()).contains("::")) {
                throw new XException(ErrorCode.E0308, "'" + s + "'. Separator '::' is missing for start and end dates of range");
            }
            List<String> listOfActions = CoordActionsInDateRange.getCoordActionIdsFromDateRange(jobId, s);
            actionSet.addAll(listOfActions);
        }
        return new ArrayList<String>(actionSet);
    }

    public static List<CoordinatorActionBean> getCoordActionsFromDateRange(String jobId, String range, boolean active) throws XException {
        Date end;
        Date start;
        String[] dateRange = range.split("::");
        if (dateRange.length != 2) {
            throw new XException(ErrorCode.E0308, "'" + range + "'. Date value expected on both sides of the scope resolution operator '::' to signify start and end of range");
        }
        try {
            start = DateUtils.parseDateOozieTZ(dateRange[0].trim());
            end = DateUtils.parseDateOozieTZ(dateRange[1].trim());
        }
        catch (ParseException dx) {
            throw new XException(ErrorCode.E0308, "Error in parsing start or end date. " + dx);
        }
        if (start.after(end)) {
            throw new XException(ErrorCode.E0308, "'" + range + "'. Start date '" + start + "' is older than end date: '" + end + "'");
        }
        List<CoordinatorActionBean> listOfActions = CoordActionsInDateRange.getActionsFromDateRange(jobId, start, end, active);
        return listOfActions;
    }

    public static List<String> getCoordActionIdsFromDateRange(String jobId, String range) throws XException {
        Date end;
        Date start;
        String[] dateRange = range.split("::");
        if (dateRange.length != 2) {
            throw new XException(ErrorCode.E0308, "'" + range + "'. Date value expected on both sides of the scope resolution operator '::' to signify start and end of range");
        }
        try {
            start = DateUtils.parseDateOozieTZ(dateRange[0].trim());
            end = DateUtils.parseDateOozieTZ(dateRange[1].trim());
        }
        catch (ParseException dx) {
            throw new XException(ErrorCode.E0308, "Error in parsing start or end date. " + dx);
        }
        if (start.after(end)) {
            throw new XException(ErrorCode.E0308, "'" + range + "'. Start date '" + start + "' is older than end date: '" + end + "'");
        }
        List<CoordinatorActionBean> listOfActions = CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_TERMINATED_ACTIONS_FOR_DATES, jobId, start, end);
        ArrayList<String> idsList = new ArrayList<String>();
        for (CoordinatorActionBean bean : listOfActions) {
            idsList.add(bean.getId());
        }
        return idsList;
    }

    private static List<CoordinatorActionBean> getActionsFromDateRange(String jobId, Date start, Date end, boolean active) throws XException {
        List<CoordinatorActionBean> list = !active ? CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_TERMINATED_ACTIONS_FOR_DATES, jobId, start, end) : CoordActionQueryExecutor.getInstance().getList(CoordActionQueryExecutor.CoordActionQuery.GET_ACTIVE_ACTIONS_FOR_DATES, jobId, start, end);
        return list;
    }

    public static Date getCoordActionsLastModifiedDate(String jobId, String startAction, String endAction) throws CommandException {
        JPAService jpaService = Services.get().get(JPAService.class);
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(startAction, "startAction");
        ParamChecker.notEmpty(endAction, "endAction");
        try {
            long count = jpaService.execute(new CoordJobGetActionRunningCountForRangeJPAExecutor(jobId, startAction, endAction));
            if (count == 0L) {
                return jpaService.execute(new CoordJobGetActionModifiedDateForRangeJPAExecutor(jobId, startAction, endAction));
            }
            return new Date();
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }
}

