/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.jcr.support;

import java.util.List;
import javax.jcr.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.jcr.SessionHolderProvider;
import org.springframework.extensions.jcr.SessionHolderProviderManager;
import org.springframework.extensions.jcr.support.GenericSessionHolderProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionHolderProviderManager
implements SessionHolderProviderManager {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractSessionHolderProviderManager.class);
    protected SessionHolderProvider defaultProvider = new GenericSessionHolderProvider();

    public abstract List<SessionHolderProvider> getProviders();

    @Override
    public SessionHolderProvider getSessionProvider(Repository repository) {
        if (repository == null) {
            return this.defaultProvider;
        }
        String key = repository.getDescriptor("jcr.repository.name");
        List<SessionHolderProvider> providers = this.getProviders();
        for (int i = 0; i < providers.size(); ++i) {
            SessionHolderProvider provider = providers.get(i);
            if (!provider.acceptsRepository(key)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("specific SessionHolderProvider found for repository " + key);
            }
            return provider;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("no specific SessionHolderProvider found for repository " + key + "; using the default one");
        }
        return this.defaultProvider;
    }
}

