/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.dom;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.css.StyleSheetUtility;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.dom.OutputProcessorFeature;
import org.pentaho.reporting.libraries.css.keys.font.FontFamilyValues;
import org.pentaho.reporting.libraries.css.keys.font.FontSmooth;
import org.pentaho.reporting.libraries.css.keys.font.FontStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.page.PageSize;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringType;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontFamily;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontRecord;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public abstract class AbstractOutputMetaData
implements LayoutOutputMetaData {
    private static final Log logger = LogFactory.getLog(AbstractOutputMetaData.class);
    private FontStorage fontStorage;
    private FontRegistry fontRegistry;
    private HashMap numericFeatures;
    private HashMap fontFamilyMapping;
    private HashSet booleanFeatures;
    private Configuration configuration;
    private ReusableFontContext reusableFontContext;
    private HashMap fontMetricsCache;
    private FontMetricsKey lookupKey;

    protected AbstractOutputMetaData(Configuration configuration) {
        this(configuration, (FontStorage)new DefaultFontStorage((FontRegistry)new AWTFontRegistry()));
    }

    protected AbstractOutputMetaData(Configuration configuration, FontStorage fontStorage) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (fontStorage == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
        this.fontRegistry = fontStorage.getFontRegistry();
        this.fontStorage = fontStorage;
        this.booleanFeatures = new HashSet();
        this.numericFeatures = new HashMap();
        this.reusableFontContext = new ReusableFontContext();
        this.fontMetricsCache = new HashMap();
        this.lookupKey = new FontMetricsKey();
        ExtendedConfigurationWrapper extendedConfig = new ExtendedConfigurationWrapper(configuration);
        double defaultFontSize = extendedConfig.getIntProperty("org.pentaho.reporting.libraries.css.defaults.FontSize", 12);
        this.fontFamilyMapping = new HashMap();
        this.setNumericFeatureValue(OutputProcessorFeature.DEFAULT_FONT_SIZE, defaultFontSize);
        double fontSmoothThreshold = extendedConfig.getIntProperty("org.pentaho.reporting.libraries.css.defaults.FontSmoothThreshold", 8);
        this.setNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD, fontSmoothThreshold);
        double deviceResolution = extendedConfig.getIntProperty("org.pentaho.reporting.libraries.css.defaults.DeviceResolution", 72);
        if (deviceResolution > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        } else {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, 72.0);
        }
        this.setFamilyMapping(FontFamilyValues.SANS_SERIF, new CSSStringValue(CSSStringType.STRING, "SansSerif"));
        this.setFamilyMapping(FontFamilyValues.SERIF, new CSSStringValue(CSSStringType.STRING, "Serif"));
        this.setFamilyMapping(FontFamilyValues.NONE, FontFamilyValues.NONE);
        this.setFamilyMapping(FontFamilyValues.MONOSPACE, new CSSStringValue(CSSStringType.STRING, "Monospaced"));
        this.setFamilyMapping(FontFamilyValues.FANTASY, new CSSStringValue(CSSStringType.STRING, "Serif"));
        this.setFamilyMapping(FontFamilyValues.CURSIVE, new CSSStringValue(CSSStringType.STRING, "SansSerif"));
        this.setFamilyMapping(null, new CSSStringValue(CSSStringType.STRING, "SansSerif"));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void setFamilyMapping(CSSValue family, CSSValue name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.fontFamilyMapping.put(family, name);
    }

    protected void addFeature(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.booleanFeatures.add(feature);
    }

    protected void removeFeature(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.booleanFeatures.remove(feature);
    }

    @Override
    public boolean isFeatureSupported(OutputProcessorFeature.BooleanOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        return this.booleanFeatures.contains(feature);
    }

    protected void setNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature, double value) {
        if (feature == null) {
            throw new NullPointerException();
        }
        this.numericFeatures.put(feature, new Double(value));
    }

    @Override
    public double getNumericFeatureValue(OutputProcessorFeature.NumericOutputProcessorFeature feature) {
        if (feature == null) {
            throw new NullPointerException();
        }
        Double d = (Double)this.numericFeatures.get(feature);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public boolean isContentSupported(Object content) {
        return content != null;
    }

    protected FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    protected FontStorage getFontStorage() {
        return this.fontStorage;
    }

    public FontMetrics getFontMetrics(String fontFamily, double fontSize, boolean bold, boolean italics, String encoding, boolean embedded, boolean antiAliasing) throws IllegalArgumentException {
        if (fontFamily == null) {
            throw new NullPointerException();
        }
        this.lookupKey.setAntiAliased(antiAliasing);
        this.lookupKey.setEncoding(encoding);
        this.lookupKey.setEmbedded(embedded);
        this.lookupKey.setFontFamily(fontFamily);
        this.lookupKey.setFontSize(fontSize);
        this.lookupKey.setBold(bold);
        this.lookupKey.setItalics(italics);
        FontMetrics cached = (FontMetrics)this.fontMetricsCache.get(this.lookupKey);
        if (cached != null) {
            return cached;
        }
        FontRegistry registry = this.getFontRegistry();
        FontFamily family = registry.getFontFamily(fontFamily);
        if (family == null) {
            logger.warn((Object)("Unable to lookup the font family: " + fontFamily));
            CSSValue fallBack = this.getDefaultFontFamily();
            if (fallBack == null) {
                throw new IllegalArgumentException("No default family defined, aborting.");
            }
            if (fallBack instanceof CSSStringValue) {
                CSSStringValue svalue = (CSSStringValue)fallBack;
                family = registry.getFontFamily(svalue.getValue());
            } else {
                family = registry.getFontFamily(fallBack.getCSSText());
            }
            if (family == null) {
                throw new IllegalArgumentException("Default family is invalid. Aborting.");
            }
        }
        this.reusableFontContext.setAntiAliased(antiAliasing);
        this.reusableFontContext.setFontSize(fontSize);
        this.reusableFontContext.setEncoding(encoding);
        this.reusableFontContext.setEmbedded(embedded);
        FontRecord record = family.getFontRecord(bold, italics);
        FontMetrics fm = this.getFontStorage().getFontMetrics(record.getIdentifier(), (FontContext)this.reusableFontContext);
        if (fm == null) {
            throw new NullPointerException("FontMetrics returned from factory is null.");
        }
        this.fontMetricsCache.put(new FontMetricsKey(this.lookupKey), fm);
        return fm;
    }

    @Override
    public FontMetrics getFontMetrics(LayoutStyle styleSheet) throws IllegalArgumentException {
        String fontName;
        CSSValue fontFamily = this.getNormalizedFontFamilyName(styleSheet.getValue(FontStyleKeys.FONT_FAMILY));
        if (fontFamily == null) {
            throw new IllegalArgumentException("No valid font family specified.");
        }
        if (fontFamily instanceof CSSStringValue) {
            CSSStringValue svalue = (CSSStringValue)fontFamily;
            fontName = svalue.getValue();
        } else {
            fontName = fontFamily.getCSSText();
        }
        CSSValue value = styleSheet.getValue(FontStyleKeys.FONT_SIZE);
        int resolution = (int)this.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        double fontSize = StyleSheetUtility.convertLengthToDouble(value, resolution);
        boolean antiAliasing = FontSmooth.ALWAYS.equals(styleSheet.getValue(FontStyleKeys.FONT_SMOOTH));
        CSSValue boldVal = styleSheet.getValue(FontStyleKeys.FONT_WEIGHT);
        CSSValue italicsVal = styleSheet.getValue(FontStyleKeys.FONT_STYLE);
        return this.getFontMetrics(fontName, fontSize, this.computeBold(boldVal), this.computeItalics(italicsVal), "UTF-8", false, antiAliasing);
    }

    private boolean computeItalics(CSSValue value) {
        return !FontStyle.NORMAL.equals(value);
    }

    private boolean computeBold(CSSValue value) {
        if (!CSSNumericType.NUMBER.equals(value.getType())) {
            return false;
        }
        CSSNumericValue nvalue = (CSSNumericValue)value;
        return nvalue.getValue() >= 700.0;
    }

    public void commit() {
        this.fontStorage.commit();
    }

    @Override
    public PageSize getDefaultPageSize() {
        return PageSize.A4;
    }

    public CSSValue getNormalizedFontFamilyName(CSSValue name) {
        CSSValue retval = (CSSValue)this.fontFamilyMapping.get(name);
        if (retval != null) {
            return retval;
        }
        if (name != null) {
            return name;
        }
        return this.getDefaultFontFamily();
    }

    @Override
    public CSSValue getDefaultFontFamily() {
        CSSValue retval = (CSSValue)this.fontFamilyMapping.get(null);
        if (retval == null) {
            throw new IllegalStateException();
        }
        return retval;
    }

    protected static class ReusableFontContext
    implements FontContext {
        private boolean antiAliased;
        private double fontSize;
        private boolean embedded;
        private String encoding;

        protected ReusableFontContext() {
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void setAntiAliased(boolean antiAliased) {
            this.antiAliased = antiAliased;
        }

        public void setFontSize(double fontSize) {
            this.fontSize = fontSize;
        }

        public boolean isAntiAliased() {
            return this.antiAliased;
        }

        public boolean isFractionalMetrics() {
            return true;
        }

        public double getFontSize() {
            return this.fontSize;
        }
    }

    private static class FontMetricsKey {
        private transient Integer hashCode;
        private String fontFamily;
        private double fontSize;
        private boolean antiAliased;
        private boolean embedded;
        private String encoding;
        private boolean italics;
        private boolean bold;

        protected FontMetricsKey() {
        }

        protected FontMetricsKey(FontMetricsKey derived) {
            this.fontFamily = derived.fontFamily;
            this.fontSize = derived.fontSize;
            this.antiAliased = derived.antiAliased;
            this.embedded = derived.embedded;
            this.encoding = derived.encoding;
            this.italics = derived.italics;
            this.bold = derived.bold;
        }

        public String getFontFamily() {
            return this.fontFamily;
        }

        public void setFontFamily(String fontFamily) {
            this.fontFamily = fontFamily;
            this.hashCode = null;
        }

        public double getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(double fontSize) {
            this.fontSize = fontSize;
            this.hashCode = null;
        }

        public boolean isAntiAliased() {
            return this.antiAliased;
        }

        public void setAntiAliased(boolean antiAliased) {
            this.antiAliased = antiAliased;
            this.hashCode = null;
        }

        public boolean isEmbedded() {
            return this.embedded;
        }

        public void setEmbedded(boolean embedded) {
            this.embedded = embedded;
            this.hashCode = null;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
            this.hashCode = null;
        }

        public boolean isItalics() {
            return this.italics;
        }

        public void setItalics(boolean italics) {
            this.italics = italics;
            this.hashCode = null;
        }

        public boolean isBold() {
            return this.bold;
        }

        public void setBold(boolean bold) {
            this.bold = bold;
            this.hashCode = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontMetricsKey that = (FontMetricsKey)o;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            if (this.antiAliased != that.antiAliased) {
                return false;
            }
            if (this.embedded != that.embedded) {
                return false;
            }
            if (this.bold != that.bold) {
                return false;
            }
            if (this.italics != that.italics) {
                return false;
            }
            if (that.fontSize != this.fontSize) {
                return false;
            }
            if (this.encoding != null ? !this.encoding.equals(that.encoding) : that.encoding != null) {
                return false;
            }
            return this.fontFamily.equals(that.fontFamily);
        }

        public int hashCode() {
            Integer hashCode = this.hashCode;
            if (hashCode == null) {
                int result = this.fontFamily.hashCode();
                long temp = this.fontSize != 0.0 ? Double.doubleToLongBits(this.fontSize) : 0L;
                result = 29 * result + (int)(temp ^ temp >>> 32);
                result = 29 * result + (this.antiAliased ? 1 : 0);
                result = 29 * result + (this.embedded ? 1 : 0);
                result = 29 * result + (this.italics ? 1 : 0);
                result = 29 * result + (this.bold ? 1 : 0);
                result = 29 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
                this.hashCode = new Integer(result);
                return result;
            }
            return hashCode;
        }
    }
}

