/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.model;

import java.util.Arrays;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.parser.StyleSheetParserUtil;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class CSSDeclarationRule
extends StyleRule {
    private CSSValue[] styleValues;
    private boolean[] importantValues;
    private StyleSheetParserUtil styleSheetParserUtil;

    protected CSSDeclarationRule(StyleSheet parentStyle, StyleRule parentRule) {
        super(parentStyle, parentRule);
    }

    public boolean isImportant(StyleKey propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        if (this.importantValues == null) {
            return false;
        }
        return this.importantValues[propertyName.index];
    }

    protected void setImportant(StyleKey propertyName, boolean important) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        if (this.importantValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.importantValues = new boolean[styleKeyRegistry.getKeyCount()];
        }
        this.importantValues[propertyName.index] = important;
    }

    public CSSValue getPropertyCSSValue(StyleKey propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        if (this.styleValues == null) {
            return null;
        }
        return this.styleValues[propertyName.index];
    }

    public void setPropertyValueAsString(StyleKey styleKey, String value) {
        CSSStyleRule cssValues;
        StyleSheet parent;
        StyleSheet parentStyle = this.getParentStyle();
        ResourceKey source = parentStyle == null ? null : parentStyle.getSource();
        if (this.styleSheetParserUtil == null) {
            this.styleSheetParserUtil = new StyleSheetParserUtil();
        }
        if ((parent = this.getParentStyle()) != null) {
            cssValues = this.styleSheetParserUtil.parseStyles(parent.getNamespaces(), styleKey.getName(), value, source, parent.getResourceManager(), StyleKeyRegistry.getRegistry());
        } else {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            cssValues = this.styleSheetParserUtil.parseStyles(null, styleKey.getName(), value, source, resourceManager, StyleKeyRegistry.getRegistry());
        }
        if (cssValues != null) {
            if (cssValues.isEmpty()) {
                return;
            }
            boolean[] importantFlags = cssValues.getImportantValues();
            CSSValue[] values = cssValues.getStyleValues();
            StyleKey[] keys = cssValues.getPropertyKeysAsArray();
            for (int i = 0; i < values.length; ++i) {
                CSSValue cssValue = values[i];
                if (cssValue == null) continue;
                this.setPropertyValue(keys[i], cssValue, importantFlags[i]);
            }
        }
    }

    public void setPropertyValue(StyleKey propertyName, CSSValue value) {
        this.setPropertyValue(propertyName, value, false);
    }

    public void setPropertyValue(StyleKey propertyName, CSSValue value, boolean important) {
        if (this.styleValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.styleValues = new CSSValue[styleKeyRegistry.getKeyCount()];
        }
        this.styleValues[propertyName.index] = value;
        this.setImportant(propertyName, important);
    }

    public void removeProperty(StyleKey name) {
        if (this.styleValues == null) {
            return;
        }
        this.setPropertyValue(name, null);
    }

    public void clear() {
        if (this.styleValues != null) {
            Arrays.fill(this.styleValues, null);
        }
        if (this.importantValues != null) {
            Arrays.fill(this.importantValues, false);
        }
    }

    public StyleKey[] getPropertyKeysAsArray() {
        return this.getStyleKeyRegistry().getKeys();
    }

    public CSSValue[] getStyleValues() {
        if (this.styleValues == null) {
            StyleKeyRegistry styleKeyRegistry = this.getStyleKeyRegistry();
            this.styleValues = new CSSValue[styleKeyRegistry.getKeyCount()];
        }
        return (CSSValue[])this.styleValues.clone();
    }

    public boolean[] getImportantValues() {
        if (this.importantValues == null) {
            this.importantValues = new boolean[this.getStyleKeyRegistry().getKeyCount()];
        }
        return (boolean[])this.importantValues.clone();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CSSDeclarationRule rule = (CSSDeclarationRule)super.clone();
        if (this.importantValues != null) {
            rule.importantValues = (boolean[])this.importantValues.clone();
        }
        if (this.styleValues != null) {
            rule.styleValues = (CSSValue[])this.styleValues.clone();
        }
        return rule;
    }

    public boolean isEmpty() {
        return this.importantValues == null && this.styleValues == null;
    }
}

