/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.model;

import org.pentaho.reporting.libraries.css.UnmodifiableStyleSheetException;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.selectors.CSSSelector;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class CSSStyleRule
extends CSSDeclarationRule {
    private CSSSelector selector;

    public CSSStyleRule(StyleSheet parentStyle, StyleRule parentRule) {
        super(parentStyle, parentRule);
    }

    public CSSSelector getSelector() {
        return this.selector;
    }

    public void setSelector(CSSSelector selector) {
        if (this.isReadOnly()) {
            throw new UnmodifiableStyleSheetException();
        }
        this.selector = selector;
    }

    public void merge(CSSStyleRule elementRule) {
        if (elementRule.isEmpty()) {
            return;
        }
        boolean[] importantFlags = elementRule.getImportantValues();
        CSSValue[] values = elementRule.getStyleValues();
        StyleKey[] keys = elementRule.getPropertyKeysAsArray();
        for (int i = 0; i < values.length; ++i) {
            CSSValue cssValue = values[i];
            if (cssValue == null) continue;
            StyleKey propertyName = keys[i];
            this.setPropertyValue(propertyName, cssValue, importantFlags[i] && this.isImportant(propertyName));
        }
    }
}

