/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.Empty;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class StyleSheet
implements Cloneable,
Serializable {
    private transient ResourceManager resourceManager;
    private transient Map roNamespaces;
    private boolean readOnly;
    private ResourceKey source;
    private ArrayList rules;
    private ArrayList styleSheets;
    private HashMap namespaces;
    private StyleKeyRegistry styleKeyRegistry = StyleKeyRegistry.getRegistry();
    private static final String[] EMPTY_STRINGS = new String[0];

    public StyleKeyRegistry getStyleKeyRegistry() {
        return this.styleKeyRegistry;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public void setSource(ResourceKey href) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        this.source = href;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        return this.resourceManager;
    }

    public void addRule(StyleRule rule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        this.rules.add(rule);
    }

    public void insertRule(int index, StyleRule rule) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        this.rules.add(index, rule);
    }

    public void deleteRule(int index) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (this.rules == null) {
            throw new IndexOutOfBoundsException();
        }
        this.rules.remove(index);
    }

    public int getRuleCount() {
        if (this.rules == null) {
            return 0;
        }
        return this.rules.size();
    }

    public StyleRule getRule(int index) {
        if (this.rules == null) {
            throw new IndexOutOfBoundsException();
        }
        return (StyleRule)this.rules.get(index);
    }

    public void addStyleSheet(StyleSheet styleSheet) {
        if (this.styleSheets == null) {
            this.styleSheets = new ArrayList();
        }
        this.styleSheets.add(styleSheet);
    }

    public int getStyleSheetCount() {
        if (this.styleSheets == null) {
            return 0;
        }
        return this.styleSheets.size();
    }

    public StyleSheet getStyleSheet(int index) {
        if (this.styleSheets == null) {
            throw new IndexOutOfBoundsException();
        }
        return (StyleSheet)this.styleSheets.get(index);
    }

    public void removeStyleSheet(StyleSheet styleSheet) {
        if (this.styleSheets == null) {
            throw new IndexOutOfBoundsException();
        }
        this.styleSheets.remove(styleSheet);
    }

    public void addNamespace(String prefix, String uri) {
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        this.namespaces.put(prefix, uri);
        this.roNamespaces = null;
    }

    public String getNamespaceURI(String prefix) {
        if (this.namespaces == null) {
            return null;
        }
        return (String)this.namespaces.get(prefix);
    }

    public String[] getNamespacePrefixes() {
        if (this.namespaces == null) {
            return EMPTY_STRINGS;
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.size()]);
    }

    public Map getNamespaces() {
        if (this.namespaces == null) {
            return Empty.MAP;
        }
        if (this.roNamespaces == null) {
            this.roNamespaces = Collections.unmodifiableMap(this.namespaces);
        }
        return this.roNamespaces;
    }

    public Object clone() throws CloneNotSupportedException {
        StyleSheet styleSheet = (StyleSheet)super.clone();
        return styleSheet;
    }
}

