/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.css.PageAreaType;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.CSSFontFaceRule;
import org.pentaho.reporting.libraries.css.model.CSSMediaRule;
import org.pentaho.reporting.libraries.css.model.CSSPageAreaRule;
import org.pentaho.reporting.libraries.css.model.CSSPageRule;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleRule;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.parser.CSSParserContext;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.StyleSheetParserUtil;
import org.pentaho.reporting.libraries.css.selectors.CSSSelector;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StyleSheetHandler
implements DocumentHandler,
ErrorHandler {
    private Log logger = LogFactory.getLog(StyleSheetHandler.class);
    private HashMap namespaces = new HashMap();
    private StyleSheet styleSheet;
    private FastStack parentRules = new FastStack();
    private CSSDeclarationRule styleRule;
    private StyleKeyRegistry styleKeyRegistry;
    private ResourceManager resourceManager;
    private ResourceKey source;
    private DependencyCollector dependencies;
    private String defaultNamespace;

    public void init(StyleKeyRegistry styleKeyRegistry, ResourceManager resourceManager, ResourceKey source, long version, StyleRule parentRule) {
        if (styleKeyRegistry == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.styleKeyRegistry = styleKeyRegistry;
        this.resourceManager = resourceManager;
        this.source = source;
        if (source != null) {
            this.dependencies = new DependencyCollector(source, version);
        }
        this.parentRules.clear();
        if (parentRule != null) {
            this.parentRules.push((Object)parentRule);
        }
        this.namespaces.clear();
    }

    public void registerNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        if (uri == null) {
            throw new NullPointerException();
        }
        this.namespaces.put(prefix, uri);
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespaceURI(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public DependencyCollector getDependencies() {
        return this.dependencies;
    }

    public CSSDeclarationRule getStyleRule() {
        return this.styleRule;
    }

    public void setStyleRule(CSSDeclarationRule styleRule) {
        this.styleRule = styleRule;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        this.styleSheet = styleSheet;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void initParseContext(InputSource source) {
        CSSParserContext parserContext = CSSParserContext.getContext();
        parserContext.setNamespaces(this.namespaces);
        parserContext.setStyleKeyRegistry(this.styleKeyRegistry);
        parserContext.setSource(this.getSource());
    }

    public void startDocument(InputSource source) throws CSSException {
        this.initParseContext(source);
        if (this.styleSheet == null) {
            this.styleSheet = new StyleSheet();
            this.styleSheet.setSource(this.getSource());
        }
    }

    public void endDocument(InputSource source) throws CSSException {
        for (Map.Entry entry : this.namespaces.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            this.styleSheet.addNamespace(prefix, uri);
        }
    }

    public void comment(String text) throws CSSException {
    }

    public void ignorableAtRule(String atRule) throws CSSException {
        StringTokenizer strtok = new StringTokenizer(atRule);
        if (!strtok.hasMoreTokens()) {
            return;
        }
        String ruleName = strtok.nextToken();
        if (ruleName.equalsIgnoreCase("@namespace")) {
            this.parseNamespaceRule(strtok);
        } else if (this.styleRule instanceof CSSPageRule) {
            CSSPageRule pageRule = (CSSPageRule)this.styleRule;
            if (ruleName.length() <= 1) {
                return;
            }
            String areaName = ruleName.substring(1);
            PageAreaType[] pageAreas = PageAreaType.getPageAreas();
            for (int i = 0; i < pageAreas.length; ++i) {
                PageAreaType pageArea = pageAreas[i];
                if (!areaName.equalsIgnoreCase(pageArea.getName())) continue;
                CSSPageAreaRule areaRule = this.parsePageRule(pageArea, atRule);
                if (areaRule != null) {
                    pageRule.addRule(areaRule);
                }
                return;
            }
            this.logger.info((Object)("Did not recognize page @rule: " + atRule));
        } else {
            this.logger.info((Object)("Ignorable @rule: " + atRule));
        }
    }

    private CSSPageAreaRule parsePageRule(PageAreaType areaType, String atRule) {
        ResourceKey source = this.source;
        CSSPageAreaRule areaRule = new CSSPageAreaRule(this.styleSheet, this.styleRule, areaType);
        int firstBrace = atRule.indexOf(123);
        int lastBrace = atRule.indexOf(125);
        if (firstBrace < 0 || lastBrace < firstBrace) {
            return null;
        }
        StyleSheetParserUtil.getInstance().parseStyleRule(this.namespaces, atRule.substring(firstBrace + 1, lastBrace - 1), source, areaRule, this.getResourceManager(), this.styleKeyRegistry);
        return areaRule;
    }

    private void parseNamespaceRule(StringTokenizer strtok) {
        String uri;
        String prefix;
        String next = strtok.nextToken();
        if (next.startsWith("url(")) {
            prefix = "";
            uri = next;
        } else {
            prefix = next;
            if (!strtok.hasMoreTokens()) {
                return;
            }
            uri = strtok.nextToken();
        }
        int uriStart = uri.indexOf(40);
        if (uriStart == -1) {
            return;
        }
        int uriEnd = uri.indexOf(41);
        if (uriEnd == -1) {
            return;
        }
        if (uriStart > uriEnd) {
            return;
        }
        String uriValue = uri.substring(uriStart + 1, uriEnd);
        this.namespaceDeclaration(prefix, uriValue);
    }

    public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        if (prefix == null || "".equals(prefix)) {
            this.namespaces.put("", uri);
            this.defaultNamespace = uri;
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        } else {
            this.namespaces.put(prefix, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        ResourceManager manager = this.getResourceManager();
        if (manager == null) {
            return;
        }
        try {
            CSSParserContext.getContext().setDefaultNamespace(defaultNamespaceURI);
            ResourceKey key = this.source == null ? manager.createKey((Object)uri) : manager.deriveKey(this.source, uri);
            Resource res = manager.create(key, this.source, StyleSheet.class);
            if (res == null) {
                return;
            }
            StyleSheet styleSheet = (StyleSheet)res.getResource();
            this.styleSheet.addStyleSheet(styleSheet);
        }
        catch (ResourceException resourceException) {
        }
        finally {
            CSSParserContext.getContext().setStyleKeyRegistry(this.styleKeyRegistry);
            CSSParserContext.getContext().setSource(this.getSource());
            CSSParserContext.getContext().setNamespaces(this.namespaces);
            CSSParserContext.getContext().setDefaultNamespace(this.defaultNamespace);
        }
    }

    public void startMedia(SACMediaList media) throws CSSException {
        this.styleRule = new CSSMediaRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    public void endMedia(SACMediaList media) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startPage(String name, String pseudo_page) throws CSSException {
        this.styleRule = new CSSPageRule(this.styleSheet, this.getParentRule(), name, pseudo_page);
        this.parentRules.push((Object)this.styleRule);
    }

    public void endPage(String name, String pseudo_page) throws CSSException {
        this.parentRules.pop();
        this.styleSheet.addRule(this.styleRule);
        this.styleRule = null;
    }

    public void startFontFace() throws CSSException {
        this.styleRule = new CSSFontFaceRule(this.styleSheet, this.getParentRule());
        this.parentRules.push((Object)this.styleRule);
    }

    protected StyleRule getParentRule() {
        if (!this.parentRules.isEmpty()) {
            return (StyleRule)this.parentRules.peek();
        }
        return null;
    }

    public void endFontFace() throws CSSException {
        this.parentRules.pop();
    }

    public void startSelector(SelectorList selectors) throws CSSException {
        this.styleRule = new CSSStyleRule(this.styleSheet, this.getParentRule());
    }

    public void endSelector(SelectorList selectors) throws CSSException {
        if (this.styleRule.isEmpty()) {
            return;
        }
        int length = selectors.getLength();
        for (int i = 0; i < length; ++i) {
            Selector selector = selectors.item(i);
            try {
                CSSStyleRule rule = (CSSStyleRule)this.styleRule.clone();
                rule.setSelector((CSSSelector)selector);
                this.styleSheet.addRule(rule);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }

    public void property(String name, LexicalUnit value, boolean important) throws CSSException {
        CSSValueFactory factory = CSSParserContext.getContext().getValueFactory();
        try {
            factory.parseValue(this.styleRule, name, value, important);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Error parsing style key: " + name), (Throwable)e);
        }
    }

    public void warning(CSSParseException exception) throws CSSException {
        this.logger.warn((Object)("Warning: " + exception.getMessage()));
    }

    public void error(CSSParseException exception) throws CSSException {
        this.logger.warn((Object)"Error: ", (Throwable)exception);
    }

    public void fatalError(CSSParseException exception) throws CSSException {
        this.logger.warn((Object)"Fatal Error: ", (Throwable)exception);
    }
}

