/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.css.model.CSSDeclarationRule;
import org.pentaho.reporting.libraries.css.model.CSSStyleRule;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.model.StyleSheet;
import org.pentaho.reporting.libraries.css.parser.CSSParserContext;
import org.pentaho.reporting.libraries.css.parser.CSSParserFactory;
import org.pentaho.reporting.libraries.css.parser.CSSParserInstantiationException;
import org.pentaho.reporting.libraries.css.parser.StyleSheetHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;

public final class StyleSheetParserUtil {
    private static StyleSheetParserUtil singleton;
    private Parser parser;

    public static synchronized StyleSheetParserUtil getInstance() {
        if (singleton == null) {
            singleton = new StyleSheetParserUtil();
        }
        return singleton;
    }

    private void setupNamespaces(Map namespaces, StyleSheetHandler handler) {
        if (namespaces == null) {
            return;
        }
        for (Map.Entry entry : namespaces.entrySet()) {
            String prefix = (String)entry.getKey();
            String uri = (String)entry.getValue();
            handler.registerNamespace(prefix, uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSValue parseStyleValue(Map namespaces, StyleKey key, String value, ResourceKey baseURL, ResourceManager resourceManager, StyleKeyRegistry styleKeyRegistry) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                this.setupNamespaces(namespaces, handler);
                handler.init(styleKeyRegistry, resourceManager, baseURL, -1L, null);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(value));
                handler.initParseContext(source);
                handler.setStyleRule(new CSSStyleRule(new StyleSheet(), null));
                parser.setDocumentHandler((DocumentHandler)handler);
                LexicalUnit lu = parser.parsePropertyValue(source);
                handler.property(key.getName(), lu, false);
                CSSStyleRule rule = (CSSStyleRule)handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule.getPropertyCSSValue(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSDeclarationRule parseStyleRule(Map namespaces, String styleText, ResourceKey baseURL, CSSDeclarationRule baseRule, ResourceManager resourceManager, StyleKeyRegistry styleKeyRegistry) {
        if (styleText == null) {
            throw new NullPointerException("Name is null");
        }
        if (resourceManager == null) {
            throw new NullPointerException("ResourceManager must not be null");
        }
        if (styleKeyRegistry == null) {
            throw new NullPointerException("Style-Key Registry must not be null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                this.setupNamespaces(namespaces, handler);
                handler.init(styleKeyRegistry, resourceManager, baseURL, -1L, null);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(styleText));
                handler.initParseContext(source);
                if (baseRule != null) {
                    handler.setStyleRule(baseRule);
                } else {
                    handler.setStyleRule(new CSSStyleRule(new StyleSheet(), null));
                }
                parser.setDocumentHandler((DocumentHandler)handler);
                parser.parseStyleDeclaration(source);
                CSSDeclarationRule rule = handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public CSSStyleRule parseStyles(Map namespaces, String name, String value, ResourceKey baseURL, ResourceManager resourceManager, StyleKeyRegistry styleKeyRegistry) {
        CSSStyleRule cssStyleRule = new CSSStyleRule(new StyleSheet(), null);
        return this.parseStyles(namespaces, name, value, baseURL, cssStyleRule, resourceManager, styleKeyRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleRule parseStyles(Map namespaces, String name, String value, ResourceKey baseURL, CSSDeclarationRule baseRule, ResourceManager resourceManager, StyleKeyRegistry styleKeyRegistry) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        try {
            Parser parser;
            Parser parser2 = parser = this.getParser();
            synchronized (parser2) {
                StyleSheetHandler handler = new StyleSheetHandler();
                handler.init(styleKeyRegistry, resourceManager, baseURL, -1L, null);
                this.setupNamespaces(namespaces, handler);
                InputSource source = new InputSource();
                source.setCharacterStream((Reader)new StringReader(value));
                handler.initParseContext(source);
                handler.setStyleRule(baseRule);
                parser.setDocumentHandler((DocumentHandler)handler);
                LexicalUnit lu = parser.parsePropertyValue(source);
                handler.property(name, lu, false);
                CSSStyleRule rule = (CSSStyleRule)handler.getStyleRule();
                CSSParserContext.getContext().destroy();
                return rule;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized Parser getParser() throws CSSParserInstantiationException {
        if (this.parser == null) {
            this.parser = CSSParserFactory.getInstance().createCSSParser();
        }
        return this.parser;
    }

    public static String[] parseNamespaceIdent(String attrName) {
        String name;
        String namespace;
        StringTokenizer strtok = new StringTokenizer(attrName, "|");
        CSSParserContext context = CSSParserContext.getContext();
        if (strtok.countTokens() == 2) {
            String tkNamespace = strtok.nextToken();
            namespace = tkNamespace.length() == 0 ? null : ("*".equals(tkNamespace) ? "*" : (String)context.getNamespaces().get(tkNamespace));
            name = strtok.nextToken();
        } else {
            name = strtok.nextToken();
            namespace = context.getDefaultNamespace();
        }
        return new String[]{namespace, name};
    }
}

