/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler;

import java.util.HashMap;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class OneOfConstantsReadHandler
implements CSSValueReadHandler {
    private HashMap constants = new HashMap();
    private boolean autoAllowed;

    protected OneOfConstantsReadHandler(boolean auto) {
        this.autoAllowed = auto;
        if (this.autoAllowed) {
            this.constants.put("auto", CSSAutoValue.getInstance());
        }
    }

    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        return this.lookupValue(value);
    }

    protected CSSValue lookupValue(LexicalUnit value) {
        if (value.getLexicalUnitType() != 35) {
            return null;
        }
        return (CSSValue)this.constants.get(value.getStringValue().toLowerCase());
    }

    protected void addValue(CSSConstant constant) {
        this.constants.put(constant.getCSSText().toLowerCase(), constant);
    }

    public boolean isAutoAllowed() {
        return this.autoAllowed;
    }
}

