/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.border;

import java.util.ArrayList;
import org.pentaho.reporting.libraries.css.keys.border.BackgroundRepeat;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.css.values.CSSValueList;
import org.pentaho.reporting.libraries.css.values.CSSValuePair;
import org.w3c.css.sac.LexicalUnit;

public class BackgroundRepeatReadHandler
implements CSSValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        ArrayList<CSSValuePair> values = new ArrayList<CSSValuePair>();
        while (value != null) {
            CSSConstant vertical;
            CSSConstant horizontal;
            if (value.getLexicalUnitType() != 35) {
                return null;
            }
            String horizontalString = value.getStringValue();
            if (horizontalString.equalsIgnoreCase("repeat-x")) {
                horizontal = BackgroundRepeat.REPEAT;
                vertical = BackgroundRepeat.NOREPEAT;
            } else if (value.getStringValue().equalsIgnoreCase("repeat-y")) {
                horizontal = BackgroundRepeat.NOREPEAT;
                vertical = BackgroundRepeat.REPEAT;
            } else {
                horizontal = this.translateRepeat(horizontalString);
                if (horizontal == null) {
                    return null;
                }
                if ((value = value.getNextLexicalUnit()) == null) {
                    vertical = horizontal;
                } else {
                    if (value.getLexicalUnitType() != 35) {
                        return null;
                    }
                    vertical = this.translateRepeat(value.getStringValue());
                    if (vertical == null) {
                        return null;
                    }
                }
            }
            values.add(new CSSValuePair(horizontal, vertical));
            value = CSSValueFactory.parseComma(value);
        }
        return new CSSValueList(values);
    }

    private CSSConstant translateRepeat(String value) {
        if (value.equalsIgnoreCase("repeat")) {
            return BackgroundRepeat.REPEAT;
        }
        if (value.equalsIgnoreCase("no-repeat")) {
            return BackgroundRepeat.NOREPEAT;
        }
        if (value.equalsIgnoreCase("space")) {
            return BackgroundRepeat.SPACE;
        }
        return null;
    }
}

