/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.box;

import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.parser.CSSValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSAutoValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSRectangleType;
import org.pentaho.reporting.libraries.css.values.CSSRectangleValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class CropReadHandler
implements CSSValueReadHandler {
    @Override
    public CSSValue createValue(StyleKey name, LexicalUnit value) {
        if (value.getLexicalUnitType() == 35) {
            String stringValue = value.getStringValue();
            if (stringValue.equalsIgnoreCase("auto") || stringValue.equalsIgnoreCase("none")) {
                return CSSAutoValue.getInstance();
            }
        } else {
            if (value.getLexicalUnitType() == 41) {
                if (value.getFunctionName().equalsIgnoreCase("inset-rect")) {
                    return CropReadHandler.getRectangle(CSSRectangleType.INSET_RECT, value.getParameters());
                }
                return null;
            }
            if (value.getLexicalUnitType() == 38) {
                return CropReadHandler.getRectangle(CSSRectangleType.RECT, value.getParameters());
            }
        }
        return null;
    }

    private static CSSRectangleValue getRectangle(CSSRectangleType type, LexicalUnit value) {
        CSSNumericValue[] list = new CSSNumericValue[4];
        for (int index = 0; index < 4; ++index) {
            if (value == null) {
                return null;
            }
            CSSNumericValue nval = CSSValueFactory.createLengthValue(value);
            if (nval != null) {
                list[index] = nval;
            } else if (value.getLexicalUnitType() == 23) {
                list[index] = CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
            } else {
                return null;
            }
            value = CSSValueFactory.parseComma(value);
        }
        return new CSSRectangleValue(type, list[0], list[1], list[2], list[3]);
    }
}

