/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.font;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.line.LineStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.font.FontFamilyReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.font.FontSizeReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.font.FontStyleReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.font.FontVariantReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.font.FontWeightReadHandler;
import org.pentaho.reporting.libraries.css.parser.stylehandler.line.LineHeightReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public class FontReadHandler
implements CSSCompoundValueReadHandler {
    private FontStyleReadHandler styleReadHandler = new FontStyleReadHandler();
    private FontSizeReadHandler sizeReadHandler = new FontSizeReadHandler();
    private FontWeightReadHandler weightReadHandler = new FontWeightReadHandler();
    private FontVariantReadHandler variantReadHandler = new FontVariantReadHandler();
    private LineHeightReadHandler lineHeightReadHandler = new LineHeightReadHandler();
    private FontFamilyReadHandler fontFamilyReadHandler = new FontFamilyReadHandler();

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue fontFamily;
        CSSValue fontStyle = this.styleReadHandler.createValue(null, unit);
        if (fontStyle != null && (unit = unit.getNextLexicalUnit()) == null) {
            return null;
        }
        CSSValue fontVariant = this.variantReadHandler.createValue(null, unit);
        if (fontVariant != null && (unit = unit.getNextLexicalUnit()) == null) {
            return null;
        }
        CSSValue fontWeight = this.weightReadHandler.createValue(null, unit);
        if (fontWeight != null && (unit = unit.getNextLexicalUnit()) == null) {
            return null;
        }
        CSSValue fontSize = this.sizeReadHandler.createValue(null, unit);
        if (fontSize == null) {
            return null;
        }
        if ((unit = unit.getNextLexicalUnit()) == null) {
            return null;
        }
        CSSValue lineHeight = null;
        if (unit.getLexicalUnitType() == 4) {
            if ((unit = unit.getNextLexicalUnit()) == null) {
                return null;
            }
            lineHeight = this.lineHeightReadHandler.createValue(null, unit);
            if (lineHeight == null) {
                return null;
            }
            if ((unit = unit.getNextLexicalUnit()) == null) {
                return null;
            }
        }
        if ((fontFamily = this.fontFamilyReadHandler.createValue(null, unit)) == null) {
            return null;
        }
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(FontStyleKeys.FONT_FAMILY, fontFamily);
        map.put(FontStyleKeys.FONT_SIZE, fontSize);
        if (lineHeight != null) {
            map.put(LineStyleKeys.LINE_HEIGHT, lineHeight);
        }
        if (fontWeight != null) {
            map.put(FontStyleKeys.FONT_WEIGHT, fontWeight);
        }
        if (fontVariant != null) {
            map.put(FontStyleKeys.FONT_VARIANT, fontVariant);
        }
        if (fontStyle != null) {
            map.put(FontStyleKeys.FONT_STYLE, fontStyle);
        }
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{FontStyleKeys.FONT_FAMILY, FontStyleKeys.FONT_SIZE, FontStyleKeys.FONT_WEIGHT, FontStyleKeys.FONT_VARIANT, FontStyleKeys.FONT_STYLE, LineStyleKeys.LINE_HEIGHT};
    }
}

