/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.parser.CSSValueFactory;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericType;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class SpacingLimitReadHandler
implements CSSCompoundValueReadHandler {
    public static final CSSConstant NORMAL = new CSSConstant("normal");

    @Override
    public Map createValues(LexicalUnit unit) {
        CSSValue optimum = this.parseSingleSpacingValue(unit);
        if (optimum == null) {
            return null;
        }
        CSSValue minimum = this.parseSingleSpacingValue(unit = unit.getNextLexicalUnit());
        if (minimum != null) {
            unit = unit.getNextLexicalUnit();
        }
        CSSValue maximum = this.parseSingleSpacingValue(unit);
        HashMap<StyleKey, CSSValue> map = new HashMap<StyleKey, CSSValue>();
        map.put(this.getMinimumKey(), minimum);
        map.put(TextStyleKeys.X_MAX_LETTER_SPACING, maximum);
        map.put(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, optimum);
        return map;
    }

    protected abstract StyleKey getMinimumKey();

    protected abstract StyleKey getMaximumKey();

    protected abstract StyleKey getOptimumKey();

    private CSSValue parseSingleSpacingValue(LexicalUnit value) {
        if (value == null) {
            return null;
        }
        if (value.getLexicalUnitType() == 35) {
            if (value.getStringValue().equalsIgnoreCase("normal")) {
                return NORMAL;
            }
            return null;
        }
        if (value.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, value.getFloatValue());
        }
        return CSSValueFactory.createLengthValue(value);
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{this.getMinimumKey(), this.getMaximumKey(), this.getOptimumKey()};
    }
}

