/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.css.keys.text.BlockProgression;
import org.pentaho.reporting.libraries.css.keys.text.Direction;
import org.pentaho.reporting.libraries.css.keys.text.TextStyleKeys;
import org.pentaho.reporting.libraries.css.model.StyleKey;
import org.pentaho.reporting.libraries.css.parser.CSSCompoundValueReadHandler;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSInheritValue;
import org.w3c.css.sac.LexicalUnit;

public class WritingModeReadHandler
implements CSSCompoundValueReadHandler {
    @Override
    public Map createValues(LexicalUnit unit) {
        CSSConstant blockProgression;
        CSSConstant direction;
        if (unit.getLexicalUnitType() == 12) {
            HashMap<StyleKey, CSSInheritValue> map = new HashMap<StyleKey, CSSInheritValue>();
            map.put(TextStyleKeys.DIRECTION, CSSInheritValue.getInstance());
            map.put(TextStyleKeys.BLOCK_PROGRESSION, CSSInheritValue.getInstance());
            return map;
        }
        if (unit.getLexicalUnitType() != 35) {
            return null;
        }
        String strValue = unit.getStringValue();
        if (strValue.equalsIgnoreCase("lr-tb")) {
            direction = Direction.LTR;
            blockProgression = BlockProgression.TB;
        } else if (strValue.equalsIgnoreCase("rl-tb")) {
            direction = Direction.RTL;
            blockProgression = BlockProgression.TB;
        } else if (strValue.equalsIgnoreCase("tb-rl")) {
            direction = Direction.LTR;
            blockProgression = BlockProgression.RL;
        } else if (strValue.equalsIgnoreCase("tb-lr")) {
            direction = Direction.RTL;
            blockProgression = BlockProgression.LR;
        } else {
            return null;
        }
        HashMap<StyleKey, CSSConstant> map = new HashMap<StyleKey, CSSConstant>();
        map.put(TextStyleKeys.DIRECTION, direction);
        map.put(TextStyleKeys.BLOCK_PROGRESSION, blockProgression);
        return map;
    }

    @Override
    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{TextStyleKeys.DIRECTION, TextStyleKeys.BLOCK_PROGRESSION};
    }
}

