/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.css.resolver.function.content;

import java.net.URL;
import java.util.Date;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutElement;
import org.pentaho.reporting.libraries.css.resolver.FunctionEvaluationException;
import org.pentaho.reporting.libraries.css.resolver.function.ContentFunction;
import org.pentaho.reporting.libraries.css.resolver.function.FunctionUtilities;
import org.pentaho.reporting.libraries.css.resolver.tokens.ContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.ExternalContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.ResourceContentToken;
import org.pentaho.reporting.libraries.css.resolver.tokens.statics.StaticTextToken;
import org.pentaho.reporting.libraries.css.util.ColorUtil;
import org.pentaho.reporting.libraries.css.values.CSSFunctionValue;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSResourceValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class AttrValueFunction
implements ContentFunction {
    @Override
    public ContentToken evaluate(DocumentContext layoutProcess, LayoutElement element, CSSFunctionValue function) throws FunctionEvaluationException {
        CSSValue[] params = function.getParameters();
        if (params.length < 2) {
            throw new FunctionEvaluationException("The parsed attr() function needs at least two parameters.");
        }
        String namespace = FunctionUtilities.resolveString(layoutProcess, element, params[0]);
        String name = FunctionUtilities.resolveString(layoutProcess, element, params[1]);
        String type = null;
        if (params.length >= 3) {
            type = FunctionUtilities.resolveString(layoutProcess, element, params[2]);
        }
        if (namespace == null || "".equals(namespace)) {
            Object value = element.getAttribute(element.getNamespace(), name);
            return this.convertValue(layoutProcess, value, type);
        }
        if ("*".equals(namespace)) {
            Object value = element.getAttribute("*", name);
            return this.convertValue(layoutProcess, value, type);
        }
        Object value = element.getAttribute(namespace, name);
        return this.convertValue(layoutProcess, value, type);
    }

    private ContentToken convertValue(DocumentContext layoutProcess, Object value, String type) throws FunctionEvaluationException {
        if (value instanceof CSSValue) {
            throw new FunctionEvaluationException();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if ("length".equals(type)) {
                CSSNumericValue cssNumericValue = FunctionUtilities.parseNumberValue(strVal);
                return new StaticTextToken(cssNumericValue.getCSSText());
            }
            if ("url".equals(type)) {
                CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, strVal);
                Resource resource = cssResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if ("color".equals(type)) {
                CSSValue colorValue = ColorUtil.parseColor(strVal);
                if (colorValue == null) {
                    throw new FunctionEvaluationException();
                }
                return new StaticTextToken(colorValue.getCSSText());
            }
            CSSValue cssValue = FunctionUtilities.parseValue(layoutProcess, strVal);
            if (cssValue instanceof CSSResourceValue) {
                CSSResourceValue cssResourceValue = (CSSResourceValue)cssValue;
                Resource resource = cssResourceValue.getValue();
                return new ResourceContentToken(resource);
            }
            if (cssValue instanceof CSSStringValue) {
                CSSStringValue sval = (CSSStringValue)cssValue;
                return new StaticTextToken(sval.getValue());
            }
            return new StaticTextToken(cssValue.getCSSText());
        }
        if (value instanceof URL) {
            CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, value);
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (value instanceof Resource) {
            return new ResourceContentToken((Resource)value);
        }
        if (value instanceof ResourceKey) {
            CSSResourceValue cssResourceValue = FunctionUtilities.loadResource(layoutProcess, value);
            Resource resource = cssResourceValue.getValue();
            return new ResourceContentToken(resource);
        }
        if (value instanceof Date) {
            return new StaticTextToken(String.valueOf(value));
        }
        if (value instanceof Number) {
            return new StaticTextToken(String.valueOf(value));
        }
        return new ExternalContentToken(value);
    }
}

